/*
 * Decompiled with CFR 0.152.
 */
package net.nuclearteam.createnuclear.content.effects;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.nuclearteam.createnuclear.CNEffects;
import net.nuclearteam.createnuclear.CNTags;
import net.nuclearteam.createnuclear.content.equipment.armor.AntiRadiationArmorItem;

public class RadiationEffect
extends MobEffect {
    public RadiationEffect() {
        super(MobEffectCategory.HARMFUL, 15453236);
        this.addAttributeModifier(Attributes.MOVEMENT_SPEED, ResourceLocation.fromNamespaceAndPath((String)"createnuclear", (String)"radiation_movement_speed"), -0.2, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        this.addAttributeModifier(Attributes.ATTACK_DAMAGE, ResourceLocation.fromNamespaceAndPath((String)"createnuclear", (String)"radiation_attack_damage"), -0.2, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        this.addAttributeModifier(Attributes.ATTACK_SPEED, ResourceLocation.fromNamespaceAndPath((String)"createnuclear", (String)"radiation_attack_speed"), -0.2, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
    }

    public boolean applyEffectTick(LivingEntity livingEntity, int amplifier) {
        if (livingEntity.getType().is(CNTags.CNEntityTags.IRRADIATED_IMMUNE.tag)) {
            livingEntity.removeEffect(CNEffects.RADIATION);
            return true;
        }
        boolean isWearingAntiRadiationArmor = false;
        for (ItemStack armor : livingEntity.getArmorSlots()) {
            if (!AntiRadiationArmorItem.Armor.isArmored(armor)) continue;
            isWearingAntiRadiationArmor = true;
            break;
        }
        if (isWearingAntiRadiationArmor) {
            return false;
        }
        int damage = 1 << amplifier;
        livingEntity.hurt(livingEntity.damageSources().magic(), (float)damage);
        return true;
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return duration >= 1;
    }
}

