/*
 * Decompiled with CFR 0.152.
 */
package net.nuclearteam.createnuclear.content.contraptions.irradiated.wolf;

import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.nuclearteam.createnuclear.CreateNuclear;
import net.nuclearteam.createnuclear.content.contraptions.irradiated.CNModelLayers;
import net.nuclearteam.createnuclear.content.contraptions.irradiated.wolf.IrradiatedWolf;
import net.nuclearteam.createnuclear.content.contraptions.irradiated.wolf.IrradiatedWolfModel;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class IrradiatedWolfRenderer
extends MobRenderer<IrradiatedWolf, IrradiatedWolfModel<IrradiatedWolf>> {
    private static final ResourceLocation WOLF_LOCATION = CreateNuclear.asResource("textures/entity/irradiated_wolf.png");
    private static final ResourceLocation WOLF_TAME_LOCATION = CreateNuclear.asResource("textures/entity/irradiated_wolf.png");
    private static final ResourceLocation WOLF_ANGRY_LOCATION = CreateNuclear.asResource("textures/entity/irradiated_wolf_angry.png");

    public IrradiatedWolfRenderer(EntityRendererProvider.Context context) {
        super(context, new IrradiatedWolfModel(context.bakeLayer(CNModelLayers.IRRADIATED_WOLF)), 0.5f);
    }

    protected float getBob(IrradiatedWolf livingBase, float partialTicks) {
        return livingBase.getTailAngle();
    }

    public void render(IrradiatedWolf entity, float entityYaw, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int packedLight) {
        if (entity.isWet()) {
            float f = entity.getWetShade(partialTicks);
            ((IrradiatedWolfModel)this.model).setColor((int)f);
        }
        super.render((LivingEntity)entity, entityYaw, partialTicks, matrixStack, buffer, packedLight);
        if (entity.isWet()) {
            ((IrradiatedWolfModel)this.model).setColor(1);
        }
    }

    @NotNull
    public ResourceLocation getTextureLocation(IrradiatedWolf entity) {
        if (entity.isTame()) {
            return WOLF_TAME_LOCATION;
        }
        return entity.isAngry() ? WOLF_ANGRY_LOCATION : WOLF_LOCATION;
    }
}

