/*
 * Decompiled with CFR 0.152.
 */
package net.nuclearteam.createnuclear.content.contraptions.irradiated.wolf;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.model.ColorableAgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.nuclearteam.createnuclear.content.contraptions.irradiated.wolf.IrradiatedWolf;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class IrradiatedWolfModel<T extends IrradiatedWolf>
extends ColorableAgeableListModel<T> {
    private final ModelPart head;
    private final ModelPart pustule1;
    private final ModelPart pustule2;
    private final ModelPart croc1;
    private final ModelPart croc2;
    private final ModelPart body;
    private final ModelPart mane;
    private final ModelPart mane_rotation;
    private final ModelPart leg1;
    private final ModelPart leg2;
    private final ModelPart body_rotation;
    private final ModelPart pustule4;
    private final ModelPart pustule5;
    private final ModelPart leg4;
    private final ModelPart pustule3;
    private final ModelPart leg3;
    private final ModelPart tail;

    public IrradiatedWolfModel(ModelPart root) {
        this.head = root.getChild("head");
        this.pustule1 = this.head.getChild("pustule1");
        this.pustule2 = this.head.getChild("pustule2");
        this.croc1 = this.head.getChild("croc1");
        this.croc2 = this.head.getChild("croc2");
        this.body = root.getChild("body");
        this.body_rotation = this.body.getChild("body_rotation");
        this.pustule4 = this.body_rotation.getChild("pustule4");
        this.pustule5 = this.body_rotation.getChild("pustule5");
        this.mane = root.getChild("mane");
        this.mane_rotation = this.mane.getChild("mane_rotation");
        this.leg1 = root.getChild("leg1");
        this.pustule3 = this.leg1.getChild("pustule3");
        this.leg2 = root.getChild("leg2");
        this.leg3 = root.getChild("leg3");
        this.leg4 = root.getChild("leg4");
        this.tail = root.getChild("tail");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.getRoot();
        PartDefinition head = modelPartData.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, -3.0f, -2.0f, 6.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(16, 14).addBox(2.0f, -5.0f, 0.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(16, 14).addBox(-2.0f, -5.0f, 0.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 10).addBox(-0.5f, -0.02f, -5.0f, 3.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-1.0f, (float)13.5f, (float)-7.0f));
        PartDefinition pustule1 = head.addOrReplaceChild("pustule1", CubeListBuilder.create().texOffs(37, 15).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.7373f, (float)-2.3286f, (float)-1.7075f, (float)0.2892f, (float)0.858f, (float)-0.0023f));
        PartDefinition pustule2 = head.addOrReplaceChild("pustule2", CubeListBuilder.create().texOffs(37, 15).addBox(-1.0f, -0.2f, -0.9f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.4627f, (float)0.6714f, (float)-0.7075f, (float)0.15f, (float)-0.2024f, (float)-0.0367f));
        PartDefinition croc1 = head.addOrReplaceChild("croc1", CubeListBuilder.create().texOffs(47, 16).addBox(-0.5f, -1.4f, -1.6f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.2f, (float)2.9f, (float)-2.8f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition croc2 = head.addOrReplaceChild("croc2", CubeListBuilder.create().texOffs(47, 16).addBox(-0.6f, -1.4f, -1.6f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.3f, (float)2.9f, (float)-2.8f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition body = modelPartData.addOrReplaceChild("body", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)14.0f, (float)2.0f));
        PartDefinition body_rotation = body.addOrReplaceChild("body_rotation", CubeListBuilder.create().texOffs(18, 14).addBox(-3.0f, -2.0f, -3.0f, 6.0f, 9.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition pustule4 = body_rotation.addOrReplaceChild("pustule4", CubeListBuilder.create().texOffs(37, 15).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.3651f, (float)0.3994f, (float)0.6f, (float)-1.7257f, (float)-0.1643f, (float)0.0375f));
        PartDefinition pustule5 = body_rotation.addOrReplaceChild("pustule5", CubeListBuilder.create().texOffs(37, 15).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.5127f, (float)5.3402f, (float)2.6436f, (float)-2.2397f, (float)-1.2467f, (float)2.3103f));
        PartDefinition mane = modelPartData.addOrReplaceChild("mane", CubeListBuilder.create(), PartPose.offset((float)-1.0f, (float)14.0f, (float)2.0f));
        PartDefinition mane_rotation = mane.addOrReplaceChild("mane_rotation", CubeListBuilder.create().texOffs(21, 0).addBox(-4.0f, -5.5f, -0.5f, 8.0f, 6.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)2.5f, (float)-2.5f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition leg1 = modelPartData.addOrReplaceChild("leg1", CubeListBuilder.create().texOffs(0, 18).addBox(0.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.5f, (float)16.0f, (float)7.0f));
        PartDefinition pustule3 = leg1.addOrReplaceChild("pustule3", CubeListBuilder.create().texOffs(39, 15).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.495f, (float)2.9934f, (float)0.6936f, (float)3.0237f, (float)0.8634f, (float)-3.0314f));
        PartDefinition leg2 = modelPartData.addOrReplaceChild("leg2", CubeListBuilder.create().texOffs(0, 18).addBox(0.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.5f, (float)16.0f, (float)7.0f));
        PartDefinition leg3 = modelPartData.addOrReplaceChild("leg3", CubeListBuilder.create().texOffs(0, 18).addBox(0.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.5f, (float)16.0f, (float)-4.0f));
        PartDefinition leg4 = modelPartData.addOrReplaceChild("leg4", CubeListBuilder.create().texOffs(0, 18).addBox(0.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.5f, (float)16.0f, (float)-4.0f));
        PartDefinition tail = modelPartData.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(9, 18).addBox(0.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-1.0f, (float)12.0f, (float)10.0f));
        return LayerDefinition.create((MeshDefinition)modelData, (int)64, (int)32);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.tail.xRot = ageInTicks;
        this.tail.yRot = entity.isAngry() ? 0.0f : Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.tail.setPos(-1.0f, 12.0f, 8.0f);
        this.leg1.setPos(-2.5f, 16.0f, 7.0f);
        this.leg2.setPos(0.5f, 16.0f, 7.0f);
        this.leg3.setPos(-2.5f, 16.0f, -4.0f);
        this.leg4.setPos(0.5f, 16.0f, -4.0f);
        this.leg1.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.leg2.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.leg3.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.leg4.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.body.zRot = ((IrradiatedWolf)((Object)entity)).getBodyRollAngle(headPitch, -0.16f);
        this.tail.zRot = ((IrradiatedWolf)((Object)entity)).getBodyRollAngle(headPitch, -0.2f);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.head.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.mane.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.leg1.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.leg2.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.leg3.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.leg4.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.tail.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }

    protected Iterable<ModelPart> headParts() {
        return null;
    }

    protected Iterable<ModelPart> bodyParts() {
        return null;
    }
}

