/*
 * Decompiled with CFR 0.152.
 */
package net.nuclearteam.createnuclear.content.contraptions.irradiated.cat;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.nuclearteam.createnuclear.content.contraptions.irradiated.cat.IrradiatedCat;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class IrradiatedCatModel<T extends IrradiatedCat>
extends AgeableListModel<T> {
    private final ModelPart pustule3;
    private final ModelPart pustule2;
    private final ModelPart teeth2;
    private final ModelPart teeth;
    private final ModelPart pustule;
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart leftFrontLeg;
    private final ModelPart rightFrontLeg;
    private final ModelPart leftHindLeg;
    private final ModelPart rightHindLeg;
    private final ModelPart tail1;
    private final ModelPart tail2;
    protected int state = 1;

    public IrradiatedCatModel(ModelPart root) {
        this.pustule = root.getChild("pustule");
        this.pustule3 = root.getChild("pustule3");
        this.pustule2 = root.getChild("pustule2");
        this.teeth2 = root.getChild("teeth2");
        this.teeth = root.getChild("teeth");
        this.head = root.getChild("head");
        this.body = root.getChild("body");
        this.leftFrontLeg = root.getChild("left_front_leg");
        this.rightFrontLeg = root.getChild("right_front_leg");
        this.leftHindLeg = root.getChild("left_hind_leg");
        this.rightHindLeg = root.getChild("right_hind_leg");
        this.tail1 = root.getChild("tail1");
        this.tail2 = root.getChild("tail2");
    }

    protected Iterable<ModelPart> headParts() {
        return ImmutableList.of((Object)this.head, (Object)this.pustule);
    }

    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.body, (Object)this.leftHindLeg, (Object)this.rightHindLeg, (Object)this.leftFrontLeg, (Object)this.rightFrontLeg, (Object)this.tail1, (Object)this.tail2, (Object)this.pustule2, (Object)this.pustule3);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        if (this.state != 3) {
            this.body.xRot = 1.5707964f;
            if (this.state == 2) {
                this.leftHindLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * limbSwingAmount;
                this.rightHindLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f + 0.3f)) * limbSwingAmount;
                this.leftFrontLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI + 0.3f)) * limbSwingAmount;
                this.rightFrontLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * limbSwingAmount;
                this.tail2.xRot = 1.7278761f + 0.31415927f * Mth.cos((float)limbSwing) * limbSwingAmount;
            } else {
                this.leftHindLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * limbSwingAmount;
                this.rightHindLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * limbSwingAmount;
                this.leftFrontLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * limbSwingAmount;
                this.rightFrontLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * limbSwingAmount;
                this.tail2.xRot = this.state == 1 ? 1.7278761f + 0.7853982f * Mth.cos((float)limbSwing) * limbSwingAmount : 1.7278761f + 0.47123894f * Mth.cos((float)limbSwing) * limbSwingAmount;
            }
        }
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.head.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.leftFrontLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.rightFrontLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.leftHindLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.rightHindLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.tail1.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.tail2.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.pustule.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.pustule3.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.pustule2.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.teeth2.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.teeth.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("pustule3", CubeListBuilder.create().texOffs(46, 24).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.5f, (float)19.6f, (float)-4.5f, (float)1.8282f, (float)-1.4377f, (float)3.0129f));
        partdefinition.addOrReplaceChild("pustule2", CubeListBuilder.create().texOffs(46, 24).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.5f, (float)14.6f, (float)4.5f, (float)1.442f, (float)0.0338f, (float)1.6973f));
        partdefinition.addOrReplaceChild("teeth2", CubeListBuilder.create().texOffs(41, 23).addBox(-0.5f, -0.5f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.8f, (float)17.1f, (float)-12.2f, (float)0.3927f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("teeth", CubeListBuilder.create().texOffs(41, 23).addBox(-0.5f, -0.5f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.8f, (float)17.1f, (float)-12.2f, (float)0.3927f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-2.5f, -2.0f, -3.0f, 5.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(0, 24).addBox(-1.5f, -0.02f, -4.0f, 3.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(0, 10).addBox(-2.0f, -3.0f, 0.0f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(6, 10).addBox(1.0f, -3.0f, 0.0f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)15.0f, (float)-9.0f));
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(20, 0).addBox(-2.0f, 3.0f, -8.0f, 4.0f, 16.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)12.0f, (float)-10.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("left_front_leg", CubeListBuilder.create().texOffs(40, 0).addBox(-1.0f, 0.0f, 0.0f, 2.0f, 10.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.1f, (float)14.1f, (float)-5.0f));
        partdefinition.addOrReplaceChild("right_front_leg", CubeListBuilder.create().texOffs(40, 0).addBox(-1.0f, 0.0f, 0.0f, 2.0f, 10.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-1.1f, (float)14.1f, (float)-5.0f));
        partdefinition.addOrReplaceChild("left_hind_leg", CubeListBuilder.create().texOffs(8, 13).addBox(-1.0f, 0.0f, 1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.1f, (float)18.0f, (float)5.0f));
        partdefinition.addOrReplaceChild("right_hind_leg", CubeListBuilder.create().texOffs(8, 13).addBox(-1.0f, 0.0f, 1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-1.1f, (float)18.0f, (float)5.0f));
        partdefinition.addOrReplaceChild("tail1", CubeListBuilder.create().texOffs(0, 15).addBox(-0.5f, 0.0f, 0.0f, 1.0f, 8.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)15.0f, (float)8.0f, (float)0.9f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("tail2", CubeListBuilder.create().texOffs(4, 15).addBox(-0.5f, 0.0f, 0.0f, 1.0f, 8.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)20.0f, (float)14.0f));
        partdefinition.addOrReplaceChild("pustule", CubeListBuilder.create().texOffs(46, 24).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.1f, (float)15.5f, (float)-10.0f, (float)-0.2597f, (float)0.0338f, (float)1.6973f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }
}

