/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.util;

import dev.architectury.platform.Platform;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.PlayerTeam;
import net.sweenus.simplyswords.SimplySwordsExpectPlatform;
import net.sweenus.simplyswords.compat.opac.OpacCompat;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.effect.instance.SimplySwordsStatusEffectInstance;
import net.sweenus.simplyswords.entity.BattleStandardDarkEntity;
import net.sweenus.simplyswords.entity.BattleStandardEntity;
import net.sweenus.simplyswords.item.TwoHandedWeapon;
import net.sweenus.simplyswords.registry.ParticlesRegistry;
import net.sweenus.simplyswords.registry.SoundRegistry;

public class HelperMethods {
    private static final Random random = new Random();

    public static Random random() {
        return random;
    }

    public static Entity getTargetedEntity(Entity user, double range) {
        AABB searchBox;
        Vec3 userView;
        Vec3 rayCastEnd;
        Vec3 rayCastOrigin = user.getEyePosition();
        EntityHitResult hitResult = ProjectileUtil.getEntityHitResult((Entity)user, (Vec3)rayCastOrigin, (Vec3)(rayCastEnd = rayCastOrigin.add(userView = user.getViewVector(1.0f).normalize().scale(range))), (AABB)(searchBox = user.getBoundingBox().inflate(range, range, range)), target -> !target.isSpectator() && target.isPickable() && target instanceof LivingEntity, (double)(range * range));
        if (hitResult != null) {
            return hitResult.getEntity();
        }
        return null;
    }

    public static boolean isWalking(Entity entity) {
        Player player;
        return entity instanceof Player && !(player = (Player)entity).isDeadOrDying() && (player.isSwimming() || player.getDeltaMovement().horizontalDistance() > 0.1);
    }

    public static boolean checkFriendlyFire(LivingEntity livingEntity, LivingEntity attackingEntity) {
        if (livingEntity == null || attackingEntity == null) {
            return false;
        }
        if (!HelperMethods.checkEntityBlacklist(livingEntity, attackingEntity)) {
            return false;
        }
        if (livingEntity == attackingEntity) {
            return false;
        }
        PlayerTeam playerTeam = attackingEntity.getTeam();
        PlayerTeam entityTeam = livingEntity.getTeam();
        if (HelperMethods.isOpacLoaded() && livingEntity instanceof Player && attackingEntity instanceof Player) {
            Player playerEntity = (Player)attackingEntity;
            return OpacCompat.checkOpacFriendlyFire(livingEntity, playerEntity);
        }
        if (playerTeam != null && entityTeam != null && livingEntity.isAlliedTo((Entity)attackingEntity)) {
            return false;
        }
        if (livingEntity instanceof Player) {
            Player playerEntity = (Player)livingEntity;
            if (attackingEntity instanceof Player) {
                Player player = (Player)attackingEntity;
                if (playerEntity == attackingEntity) {
                    return false;
                }
                return playerEntity.canHarmPlayer(player);
            }
        }
        if (livingEntity instanceof OwnableEntity) {
            OwnableEntity tameable = (OwnableEntity)livingEntity;
            if (tameable.getOwner() != null) {
                LivingEntity livingEntity2;
                if (tameable.getOwner() != attackingEntity && (livingEntity2 = tameable.getOwner()) instanceof Player) {
                    Player ownerPlayer = (Player)livingEntity2;
                    if (attackingEntity instanceof Player) {
                        Player playerEntity = (Player)attackingEntity;
                        if (HelperMethods.isOpacLoaded()) {
                            return OpacCompat.checkOpacFriendlyFire((LivingEntity)ownerPlayer, playerEntity);
                        }
                        return playerEntity.canHarmPlayer(ownerPlayer);
                    }
                }
                return tameable.getOwner() != attackingEntity;
            }
            return true;
        }
        return true;
    }

    public static boolean isOpacLoaded() {
        return Platform.isModLoaded((String)"openpartiesandclaims");
    }

    public static boolean checkEntityBlacklist(LivingEntity target, LivingEntity player) {
        if (target == null || player == null) {
            return false;
        }
        return !(target instanceof ArmorStand) && !(target instanceof Villager) && !(target instanceof BattleStandardEntity) && !(target instanceof BattleStandardDarkEntity);
    }

    public static void spawnParticle(Level world, ParticleOptions particle, double xpos, double ypos, double zpos, double xvelocity, double yvelocity, double zvelocity) {
        if (world.isClientSide) {
            world.addParticle(particle, xpos, ypos, zpos, xvelocity, yvelocity, zvelocity);
        } else if (world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            serverWorld.sendParticles(particle, xpos, ypos, zpos, 1, xvelocity, yvelocity, zvelocity, 0.1);
        }
    }

    public static void createServerBubbleTrail(ServerLevel serverWorld, ServerPlayer player) {
        if (player.tickCount % 10 == 0) {
            double x = player.getX() + (serverWorld.random.nextDouble() - 0.5) * 0.3;
            double y = player.getY() + 0.1;
            double z = player.getZ() + (serverWorld.random.nextDouble() - 0.5) * 0.3;
            serverWorld.sendParticles((ParticleOptions)((SimpleParticleType)ParticlesRegistry.CUSTOM_BUBBLE.get()), x, y, z, 2, 0.1, 0.05, 0.1, 0.02);
        }
    }

    public static void playHitSounds(LivingEntity attacker, LivingEntity target) {
        if (!attacker.level().isClientSide()) {
            ServerLevel world = (ServerLevel)attacker.level();
            boolean impactsounds_enabled = Config.general.enableWeaponImpactSounds;
            float impactsounds_volume = Config.general.weaponImpactSoundsVolume;
            if (impactsounds_enabled) {
                int choose_sound = (int)(Math.random() * 30.0);
                float choose_pitch = (float)Math.random() * 2.0f;
                if (choose_sound <= 10) {
                    world.playSound(null, (Entity)target, (SoundEvent)SoundRegistry.MAGIC_SWORD_ATTACK_WITH_BLOOD_01.get(), SoundSource.PLAYERS, impactsounds_volume, 1.1f + choose_pitch);
                } else if (choose_sound <= 20) {
                    world.playSound(null, (Entity)target, (SoundEvent)SoundRegistry.MAGIC_SWORD_ATTACK_WITH_BLOOD_02.get(), SoundSource.PLAYERS, impactsounds_volume, 1.1f + choose_pitch);
                } else if (choose_sound <= 30) {
                    world.playSound(null, (Entity)target, (SoundEvent)SoundRegistry.MAGIC_SWORD_ATTACK_WITH_BLOOD_03.get(), SoundSource.PLAYERS, impactsounds_volume, 1.1f + choose_pitch);
                } else if (choose_sound <= 40) {
                    world.playSound(null, (Entity)target, (SoundEvent)SoundRegistry.MAGIC_SWORD_ATTACK_WITH_BLOOD_04.get(), SoundSource.PLAYERS, impactsounds_volume, 1.1f + choose_pitch);
                }
            }
        }
    }

    public static boolean isUniqueTwohanded(ItemStack stack) {
        return stack.getItem() instanceof TwoHandedWeapon;
    }

    public static AABB createBox(Entity entity, double radius) {
        return new AABB(entity.getX() + radius, entity.getY() + (double)((float)radius / 3.0f), entity.getZ() + radius, entity.getX() - radius, entity.getY() - (double)((float)radius / 3.0f), entity.getZ() - radius);
    }

    public static Vec3 getPositionLookingAt(Player player, int range) {
        HitResult result = player.pick((double)range, 0.0f, false);
        if (result.getType() != HitResult.Type.BLOCK) {
            return null;
        }
        BlockHitResult blockResult = (BlockHitResult)result;
        return blockResult.getLocation();
    }

    public static void incrementStatusEffect(LivingEntity livingEntity, Holder<MobEffect> statusEffect, int duration, int amplifier, int amplifierMax) {
        if (livingEntity.hasEffect(statusEffect)) {
            int currentDuration = livingEntity.getEffect(statusEffect).getDuration();
            int currentAmplifier = livingEntity.getEffect(statusEffect).getAmplifier();
            if (currentAmplifier >= amplifierMax) {
                livingEntity.addEffect(new MobEffectInstance(statusEffect, Math.max(currentDuration, duration), currentAmplifier, false, false, true));
                return;
            }
            livingEntity.addEffect(new MobEffectInstance(statusEffect, Math.max(currentDuration, duration), Math.min(amplifierMax, currentAmplifier + amplifier), false, false, true));
        }
        livingEntity.addEffect(new MobEffectInstance(statusEffect, duration, amplifier, false, false, true));
    }

    public static SimplySwordsStatusEffectInstance incrementSimplySwordsStatusEffect(LivingEntity livingEntity, Holder<MobEffect> statusEffect, int duration, int amplifier, int amplifierMax) {
        if (livingEntity.hasEffect(statusEffect)) {
            int currentDuration = livingEntity.getEffect(statusEffect).getDuration();
            int currentAmplifier = livingEntity.getEffect(statusEffect).getAmplifier();
            if (currentAmplifier >= amplifierMax) {
                SimplySwordsStatusEffectInstance statusReturn = new SimplySwordsStatusEffectInstance(statusEffect, Math.max(currentDuration, duration), currentAmplifier, false, false, true);
                livingEntity.addEffect((MobEffectInstance)statusReturn);
                return statusReturn;
            }
            livingEntity.addEffect(new MobEffectInstance(statusEffect, Math.max(currentDuration, duration), Math.min(amplifierMax, currentAmplifier + amplifier), false, false, true));
        }
        SimplySwordsStatusEffectInstance statusReturn = new SimplySwordsStatusEffectInstance(statusEffect, duration, 0, false, false, true);
        livingEntity.addEffect((MobEffectInstance)statusReturn);
        return statusReturn;
    }

    public static void decrementStatusEffect(LivingEntity livingEntity, Holder<MobEffect> statusEffect) {
        if (livingEntity.hasEffect(statusEffect)) {
            int currentAmplifier = livingEntity.getEffect(statusEffect).getAmplifier();
            int currentDuration = livingEntity.getEffect(statusEffect).getDuration();
            if (currentAmplifier < 1) {
                livingEntity.removeEffect(statusEffect);
                return;
            }
            livingEntity.removeEffect(statusEffect);
            livingEntity.addEffect(new MobEffectInstance(statusEffect, currentDuration, currentAmplifier - 1, false, false, true));
        }
    }

    public static void createFootfalls(Entity entity, ItemStack stack, Level world, ParticleOptions particle, ParticleOptions sprintParticle, ParticleOptions passiveParticle, boolean passiveParticles) {
        int stepMod = 7 - (int)(world.getGameTime() % 7L);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (Config.general.enableWeaponFootfalls && player.getItemBySlot(EquipmentSlot.MAINHAND) == stack) {
                if (HelperMethods.isWalking((Entity)player) && !player.isSwimming() && player.onGround()) {
                    if (stepMod == 6) {
                        if (player.isSprinting()) {
                            world.addParticle(sprintParticle, player.getX() + player.getHandHoldingItemAngle(stack.getItem()).x(), player.getY() + player.getHandHoldingItemAngle(stack.getItem()).y() + 0.2, player.getZ() + player.getHandHoldingItemAngle(stack.getItem()).z(), 0.0, 0.0, 0.0);
                        } else {
                            world.addParticle(particle, player.getX() + player.getHandHoldingItemAngle(stack.getItem()).x(), player.getY() + player.getHandHoldingItemAngle(stack.getItem()).y() + 0.2, player.getZ() + player.getHandHoldingItemAngle(stack.getItem()).z(), 0.0, 0.0, 0.0);
                        }
                    } else if (stepMod == 3) {
                        if (player.isSprinting()) {
                            world.addParticle(sprintParticle, player.getX() - player.getHandHoldingItemAngle(stack.getItem()).x(), player.getY() + player.getHandHoldingItemAngle(stack.getItem()).y() + 0.2, player.getZ() - player.getHandHoldingItemAngle(stack.getItem()).z(), 0.0, 0.0, 0.0);
                        } else {
                            world.addParticle(particle, player.getX() - player.getHandHoldingItemAngle(stack.getItem()).x(), player.getY() + player.getHandHoldingItemAngle(stack.getItem()).y() + 0.2, player.getZ() - player.getHandHoldingItemAngle(stack.getItem()).z(), 0.0, 0.0, 0.0);
                        }
                    }
                }
                if (passiveParticles && Config.general.enablePassiveParticles) {
                    float randomy = (float)Math.random();
                    if (stepMod == 1) {
                        world.addParticle(passiveParticle, player.getX() - player.getHandHoldingItemAngle(stack.getItem()).x(), player.getY() + player.getHandHoldingItemAngle(stack.getItem()).y() + 0.4 + (double)randomy, player.getZ() - player.getHandHoldingItemAngle(stack.getItem()).z(), 0.0, 0.0, 0.0);
                        world.addParticle(passiveParticle, player.getX() - player.getHandHoldingItemAngle(stack.getItem()).x() + 0.1, player.getY() + player.getHandHoldingItemAngle(stack.getItem()).y() + (double)randomy, player.getZ() - player.getHandHoldingItemAngle(stack.getItem()).z() - 0.1, 0.0, 0.0, 0.0);
                    } else if (stepMod == 4) {
                        world.addParticle(passiveParticle, player.getX() + player.getHandHoldingItemAngle(stack.getItem()).x(), player.getY() + player.getHandHoldingItemAngle(stack.getItem()).y() + 0.4 + (double)randomy, player.getZ() + player.getHandHoldingItemAngle(stack.getItem()).z(), 0.0, 0.0, 0.0);
                        world.addParticle(passiveParticle, player.getX() + player.getHandHoldingItemAngle(stack.getItem()).x() - 0.1, player.getY() + player.getHandHoldingItemAngle(stack.getItem()).y() + (double)randomy, player.getZ() + player.getHandHoldingItemAngle(stack.getItem()).z() + 0.1, 0.0, 0.0, 0.0);
                    }
                }
            }
        }
    }

    public static void spawnOrbitParticles(ServerLevel world, Vec3 center, ParticleOptions particleType, double radius, int particleCount) {
        for (int i = 0; i < particleCount; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)particleCount;
            double x = center.x + radius * Math.cos(angle);
            double z = center.z + radius * Math.sin(angle);
            double y = center.y;
            world.sendParticles(particleType, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public static void spawnWaistHeightParticles(ServerLevel world, ParticleOptions particle, Entity entity1, Entity entity2, int count) {
        Vec3 startPos = entity1.position().add(0.0, (double)entity1.getBbHeight() / 2.0, 0.0);
        Vec3 endPos = entity2.position().add(0.0, (double)entity2.getBbHeight() / 2.0, 0.0);
        Vec3 direction = endPos.subtract(startPos);
        double distance = direction.length();
        Vec3 normalizedDirection = direction.normalize();
        for (int i = 0; i < count; ++i) {
            double lerpFactor = (double)i / (double)(count - 1);
            Vec3 currentPos = startPos.add(normalizedDirection.scale(distance * lerpFactor));
            world.sendParticles(particle, currentPos.x, currentPos.y, currentPos.z, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public static void spawnRainingParticles(ServerLevel world, ParticleOptions particle, Entity entity2, int count, double blocksAbove) {
        Vec3 endPos = entity2.position().add(0.0, (double)entity2.getBbHeight() / 2.0, 0.0);
        Vec3 startPos = endPos.add(0.0, blocksAbove, 0.0);
        Vec3 direction = endPos.subtract(startPos);
        double distance = direction.length();
        Vec3 normalizedDirection = direction.normalize();
        for (int i = 0; i < count; ++i) {
            double lerpFactor = (double)i / (double)(count - 1);
            Vec3 currentPos = startPos.add(normalizedDirection.scale(distance * lerpFactor));
            world.sendParticles(particle, currentPos.x, currentPos.y, currentPos.z, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public static void spawnParticlesBetween(ServerPlayer player, BlockPos blockPos, ServerLevel world, ParticleOptions particleType, int particleCount) {
        Vec3 start = player.position().add(0.0, (double)player.getBbHeight() / 2.0, 0.0);
        Vec3 end = Vec3.atCenterOf((Vec3i)blockPos);
        double stepSize = 1.0 / (double)particleCount;
        for (int i = 0; i <= particleCount; ++i) {
            double t = (double)i * stepSize;
            double x = start.x + (end.x - start.x) * t;
            double y = start.y + (end.y - start.y) * t;
            double z = start.z + (end.z - start.z) * t;
            world.sendParticles(particleType, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public static float spellScaledDamage(String spellSchool, Entity entity, float damageModifier, float damageFallback) {
        float scaling = HelperMethods.commonSpellAttributeScaling(damageModifier, entity, spellSchool);
        return scaling > 0.0f ? scaling : damageFallback;
    }

    public static float commonSpellAttributeScaling(float damageModifier, Entity entity, String magicSchool) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (((Boolean)Config.general.compatEnableSpellPowerScaling.get()).booleanValue()) {
                return SimplySwordsExpectPlatform.getSpellPowerDamage(damageModifier, player, magicSchool);
            }
        }
        return 0.0f;
    }

    public static Optional<LivingEntity> findClosestTarget(LivingEntity livingEntity, double maxDistance, double width) {
        Level world = livingEntity.getCommandSenderWorld();
        Vec3 eyePosition = livingEntity.getEyePosition();
        Vec3 lookVec = livingEntity.getViewVector(1.0f);
        Vec3 targetVec = eyePosition.add(lookVec.x * maxDistance, lookVec.y * maxDistance, lookVec.z * maxDistance);
        Vec3 perpVec = new Vec3(-lookVec.z, 0.0, lookVec.x).normalize().scale(width / 2.0);
        AABB searchBox = new AABB(eyePosition.subtract(perpVec.x, 1.0, perpVec.z), targetVec.add(perpVec.x, 1.0, perpVec.z));
        List entities = world.getEntitiesOfClass(LivingEntity.class, searchBox, e -> e != livingEntity);
        return entities.stream().min(Comparator.comparingDouble(e -> e.distanceToSqr((Entity)livingEntity)));
    }

    public static List<LivingEntity> getNearbyLivingEntities(Level world, Vec3 position, double radius) {
        AABB searchBox = new AABB(position.x - radius, position.y - radius, position.z - radius, position.x + radius, position.y + radius, position.z + radius);
        return world.getEntitiesOfClass(LivingEntity.class, searchBox, entity -> true);
    }

    public static double getEntityAttackDamage(LivingEntity livingEntity) {
        AttributeInstance attackDamageAttribute = livingEntity.getAttribute(Attributes.ATTACK_DAMAGE);
        if (attackDamageAttribute != null) {
            return attackDamageAttribute.getValue();
        }
        return 0.0;
    }

    public static double[] getAttackFromSlot(Player player, ItemStack stack, InteractionHand hand) {
        EquipmentSlotGroup attributeModifierSlot;
        double attackValue = 0.0;
        double attackSpeedValue = 0.0;
        EquipmentSlotGroup equipmentSlotGroup = attributeModifierSlot = hand == InteractionHand.MAIN_HAND ? EquipmentSlotGroup.MAINHAND : EquipmentSlotGroup.OFFHAND;
        if (!stack.isEmpty()) {
            ItemAttributeModifiers attributeModifiersComponent = (ItemAttributeModifiers)stack.getOrDefault(DataComponents.ATTRIBUTE_MODIFIERS, (Object)ItemAttributeModifiers.EMPTY);
            for (ItemAttributeModifiers.Entry entry : attributeModifiersComponent.modifiers()) {
                if (entry.attribute() != Attributes.ATTACK_DAMAGE || entry.slot() != attributeModifierSlot) continue;
                attackValue += entry.modifier().amount();
            }
        }
        return new double[]{attackValue, attackSpeedValue};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void applyDamageWithoutKnockback(LivingEntity target, DamageSource source, float amount) {
        AttributeInstance knockbackResistance = target.getAttribute(Attributes.KNOCKBACK_RESISTANCE);
        double originalKnockbackResistance = 0.0;
        if (knockbackResistance != null) {
            originalKnockbackResistance = knockbackResistance.getValue();
            knockbackResistance.setBaseValue(1.0);
        }
        try {
            target.hurt(source, amount);
        }
        finally {
            if (knockbackResistance != null) {
                knockbackResistance.setBaseValue(originalKnockbackResistance);
            }
        }
    }

    public static void spawnDirectionalParticles(ServerLevel world, ParticleOptions particle, Entity entity, int count, double distance) {
        Vec3 startPos = entity.position().add(0.0, (double)entity.getBbHeight() / 2.0, 0.0);
        float pitch = entity.getViewXRot(1.0f);
        float yaw = entity.getViewYRot(1.0f);
        double pitchRadians = Math.toRadians(pitch);
        double yawRadians = Math.toRadians(yaw);
        double xDirection = -Math.sin(yawRadians) * Math.cos(pitchRadians);
        double yDirection = -Math.sin(pitchRadians);
        double zDirection = Math.cos(yawRadians) * Math.cos(pitchRadians);
        Vec3 direction = new Vec3(xDirection, yDirection, zDirection).normalize();
        for (int i = 0; i < count; ++i) {
            double lerpFactor = (double)i / (double)(count - 1);
            Vec3 currentPos = startPos.add(direction.scale(distance * lerpFactor));
            world.sendParticles(particle, currentPos.x, currentPos.y, currentPos.z, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public static void damageEntitiesInTrajectory(ServerLevel world, Entity sourceEntity, double distance, float damage, DamageSource damageSource) {
        Vec3 startPos = sourceEntity.position().add(0.0, (double)sourceEntity.getBbHeight() / 2.0, 0.0);
        float pitch = sourceEntity.getViewXRot(1.0f);
        float yaw = sourceEntity.getViewYRot(1.0f);
        double pitchRadians = Math.toRadians(pitch);
        double yawRadians = Math.toRadians(yaw);
        double xDirection = -Math.sin(yawRadians) * Math.cos(pitchRadians);
        double yDirection = -Math.sin(pitchRadians);
        double zDirection = Math.cos(yawRadians) * Math.cos(pitchRadians);
        Vec3 direction = new Vec3(xDirection, yDirection, zDirection).normalize();
        Vec3 endPos = startPos.add(direction.scale(distance));
        double boxSize = 0.5;
        AABB searchBox = new AABB(startPos, endPos).inflate(boxSize);
        for (Entity entity : world.getEntities(sourceEntity, searchBox)) {
            LivingEntity livingTarget;
            AABB entityBox = entity.getBoundingBox().inflate((double)entity.getPickRadius());
            if (!entityBox.intersects(searchBox) || !(sourceEntity instanceof Player)) continue;
            Player livingEntity = (Player)sourceEntity;
            if (!(entity instanceof LivingEntity) || !HelperMethods.checkFriendlyFire(livingTarget = (LivingEntity)entity, (LivingEntity)livingEntity)) continue;
            livingTarget.hurt(damageSource, damage);
        }
    }

    public static boolean damageThroughIframes(Entity targetEntity, DamageSource damageSource, float damage) {
        int iframes = targetEntity.invulnerableTime;
        boolean result = targetEntity.hurt(damageSource, damage);
        targetEntity.invulnerableTime = iframes;
        return result;
    }

    public static boolean isInTag(ItemStack stack, ResourceLocation tagId) {
        if (stack != null && !stack.isEmpty()) {
            TagKey tag = TagKey.create((ResourceKey)BuiltInRegistries.ITEM.key(), (ResourceLocation)tagId);
            return stack.getItem().builtInRegistryHolder().is(tag);
        }
        return false;
    }

    public static boolean isHolding(ItemStack stack, LivingEntity entity) {
        return entity.getItemBySlot(EquipmentSlot.MAINHAND).equals(stack) || entity.getItemBySlot(EquipmentSlot.OFFHAND).equals(stack);
    }

    public static boolean isHoldingItem(Item item, LivingEntity entity) {
        return entity.getItemBySlot(EquipmentSlot.MAINHAND).getItem().equals(item) || entity.getItemBySlot(EquipmentSlot.OFFHAND).getItem().equals(item);
    }

    public static boolean hasItemInInventory(Player player, Item item) {
        if (player == null || item == null) {
            return false;
        }
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            ItemStack stack = player.getInventory().getItem(i);
            if (stack.getItem() != item) continue;
            return true;
        }
        return false;
    }
}

