/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.item.custom;

import java.util.List;
import java.util.function.Supplier;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedFloat;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedInt;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.config.settings.ItemStackTooltipAppender;
import net.sweenus.simplyswords.config.settings.TooltipSettings;
import net.sweenus.simplyswords.entity.WickpiercerEntity;
import net.sweenus.simplyswords.item.UniqueSwordItem;
import net.sweenus.simplyswords.registry.EffectRegistry;
import net.sweenus.simplyswords.registry.ItemsRegistry;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.HelperMethods;
import net.sweenus.simplyswords.util.Styles;

public class WickpiercerSwordItem
extends UniqueSwordItem {
    public WickpiercerSwordItem(Tier toolMaterial, Item.Properties settings) {
        super(toolMaterial, settings);
    }

    @Override
    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!attacker.level().isClientSide()) {
            HelperMethods.playHitSounds(attacker, target);
            ServerLevel world = (ServerLevel)attacker.level();
            if (attacker instanceof Player) {
                Player player = (Player)attacker;
                DamageSource damageSource = attacker.damageSources().playerAttack(player);
                double[] doubles = HelperMethods.getAttackFromSlot(player, stack, attacker.getUsedItemHand());
                float damageModifier = (float)doubles[0] * Config.uniqueEffects.wickpiercer.damage;
                if (attacker.hasEffect(EffectRegistry.getReference(EffectRegistry.FRENZY))) {
                    target.invulnerableTime = 0;
                    HelperMethods.decrementStatusEffect((LivingEntity)player, EffectRegistry.getReference(EffectRegistry.FRENZY));
                    target.hurt(damageSource, damageModifier);
                }
            }
        }
        return super.hurtEnemy(stack, target, attacker);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        int baseEffectDuration;
        int effectDuration = baseEffectDuration = Config.uniqueEffects.wickpiercer.duration;
        ItemStack mainhand = user.getMainHandItem();
        ItemStack offhand = user.getOffhandItem();
        if (mainhand.is((Item)this) && offhand.is((Item)this)) {
            effectDuration = baseEffectDuration * 2;
        }
        world.playSound(null, user.blockPosition(), (SoundEvent)SoundRegistry.SPELL_FIRE.get(), user.getSoundSource(), 0.1f, 1.0f);
        HelperMethods.incrementStatusEffect((LivingEntity)user, EffectRegistry.getReference(EffectRegistry.FRENZY), effectDuration, 1, 4);
        ItemStack itemStack = user.getItemInHand(hand);
        if (!world.isClientSide) {
            itemStack = user.getItemInHand(hand);
            WickpiercerEntity wickpiercerEntity = new WickpiercerEntity(world, (LivingEntity)user, itemStack.copy());
            wickpiercerEntity.shootFromRotation((Entity)user, user.getXRot(), user.getYRot(), 0.0f, 1.5f, 1.0f);
            wickpiercerEntity.setYRot(user.getYRot());
            wickpiercerEntity.setXRot(user.getXRot() - 90.0f);
            double[] doubles = HelperMethods.getAttackFromSlot(user, itemStack, user.getUsedItemHand());
            wickpiercerEntity.primaryBaseDamage = (float)doubles[0] * 0.5f;
            wickpiercerEntity.hasLoyalty = 3;
            if (hand == InteractionHand.OFF_HAND) {
                wickpiercerEntity.offhandThrow = true;
            }
            wickpiercerEntity.setPosRaw(user.getX(), user.getEyeY() - 0.5, user.getZ());
            world.addFreshEntity((Entity)wickpiercerEntity);
            if (!user.getAbilities().instabuild) {
                itemStack.shrink(1);
            }
        }
        user.swing(hand);
        return InteractionResultHolder.sidedSuccess((Object)itemStack, (boolean)world.isClientSide());
    }

    @Override
    public void inventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        HelperMethods.createFootfalls(entity, stack, world, (ParticleOptions)ParticleTypes.WHITE_ASH, (ParticleOptions)ParticleTypes.WHITE_ASH, (ParticleOptions)ParticleTypes.WHITE_ASH, true);
        super.inventoryTick(stack, world, entity, slot, selected);
    }

    @Override
    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag type) {
        tooltip.add((Component)Component.literal((String)""));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.wickpiercersworditem.tooltip1").setStyle(Styles.ABILITY));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.wickpiercersworditem.tooltip2").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.literal((String)""));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.waxweaversworditem.tooltip4").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.waxweaversworditem.tooltip5").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.waxweaversworditem.tooltip6").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.waxweaversworditem.tooltip7").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.literal((String)""));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.waxweaversworditem.tooltip8").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.waxweaversworditem.tooltip9", (Object[])new Object[]{Config.uniqueEffects.waxweaver.cooldown / 20}).setStyle(Styles.TEXT));
        tooltip.add((Component)Component.literal((String)""));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.onrightclick").setStyle(Styles.RIGHT_CLICK));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.wickpiercersworditem.tooltip3").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.wickpiercersworditem.tooltip4").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.wickpiercersworditem.tooltip5").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.wickpiercersworditem.tooltip6", (Object[])new Object[]{Config.uniqueEffects.wickpiercer.duration / 20}).setStyle(Styles.TEXT));
        tooltip.add((Component)Component.literal((String)""));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.wickpiercersworditem.tooltip7").setStyle(Styles.TEXT));
        super.appendHoverText(itemStack, tooltipContext, tooltip, type);
    }

    public static class EffectSettings
    extends TooltipSettings {
        @ValidatedFloat.Restrict(min=0.0f)
        public float damage;
        @ValidatedInt.Restrict(min=0)
        public int duration;

        public EffectSettings() {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = () -> ItemsRegistry.WICKPIERCER.get();
            super(new ItemStackTooltipAppender(supplierArray));
            this.damage = 1.0f;
            this.duration = 80;
        }
    }
}

