/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.entity;

import java.util.List;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.entity.goal.AttackHostileMobsGoal;
import net.sweenus.simplyswords.entity.goal.FollowNearestPlayerGoal;
import net.sweenus.simplyswords.registry.ItemsRegistry;
import net.sweenus.simplyswords.util.HelperMethods;
import org.jetbrains.annotations.Nullable;

public class SimplySwordsAxolotlEntity
extends Axolotl
implements OwnableEntity {
    private UUID ownerUuid;
    public static int lifespan = Config.uniqueEffects.chompolotl.duration;
    private static final int READY_TO_SIT_COOLDOWN = 20;
    private int ticksSinceSitAttempt = 0;

    public SimplySwordsAxolotlEntity(EntityType<? extends Axolotl> entityType, Level world) {
        super(entityType, world);
    }

    public static AttributeSupplier.Builder createSimplyAxolotlAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 35.0).add(Attributes.FLYING_SPEED, 1.0).add(Attributes.MOVEMENT_SPEED, 1.0).add(Attributes.WATER_MOVEMENT_EFFICIENCY, 10.0).add(Attributes.ATTACK_DAMAGE, 1.0).add(Attributes.ATTACK_KNOCKBACK, 0.1).add(Attributes.STEP_HEIGHT, 1.0).add(Attributes.FOLLOW_RANGE, 48.0);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new AttackHostileMobsGoal((PathfinderMob)this, 8.0, 1.0, 16.0));
        this.goalSelector.addGoal(2, (Goal)new FollowNearestPlayerGoal(this, 0.5, 32.0, 2.0));
    }

    public void tick() {
        if (this.ticksSinceSitAttempt < 20) {
            ++this.ticksSinceSitAttempt;
        }
        this.setInvulnerable(true);
        if (this.tickCount > lifespan) {
            this.discard();
        }
        super.tick();
        if (!this.level().isClientSide && this.getVariant() == Axolotl.Variant.BLUE) {
            ServerLevel serverWorld = (ServerLevel)this.level();
            HelperMethods.spawnParticle((Level)serverWorld, (ParticleOptions)ParticleTypes.ELECTRIC_SPARK, this.getX(), this.getY() + 0.5, this.getZ(), 0.2, 0.1, 0.2);
            if (this.isInWater() && Config.uniqueEffects.chompolotl.dolphinsGrace && this.tickCount % 20 == 0) {
                double radius = 16.0;
                AABB box = new AABB(this.position().add(-radius, -radius, -radius), this.position().add(radius, radius, radius));
                List nearbyPlayers = serverWorld.getEntitiesOfClass(Player.class, box, player -> true);
                for (Player player2 : nearbyPlayers) {
                    player2.addEffect(new MobEffectInstance(MobEffects.DOLPHINS_GRACE, 200, 0, true, false, true));
                }
            }
        }
    }

    public boolean hurt(DamageSource source, float amount) {
        return false;
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ServerPlayer serverPlayer;
        boolean hasChompolotlItem;
        if (!this.level().isClientSide && player instanceof ServerPlayer && (hasChompolotlItem = HelperMethods.hasItemInInventory((Player)(serverPlayer = (ServerPlayer)player), (Item)ItemsRegistry.CHOMPOLOTL.get())) && this.ticksSinceSitAttempt >= 20) {
            boolean mounted = this.mountOnto(serverPlayer);
            this.ticksSinceSitAttempt = 0;
            return mounted ? InteractionResult.SUCCESS : InteractionResult.FAIL;
        }
        return InteractionResult.FAIL;
    }

    public boolean doHurtTarget(Entity target) {
        target.invulnerableTime = 0;
        return super.doHurtTarget(target);
    }

    public boolean mountOnto(ServerPlayer player) {
        CompoundTag nbtCompound = new CompoundTag();
        nbtCompound.putString("id", this.getEncodeId());
        this.saveWithoutId(nbtCompound);
        boolean success = player.setEntityOnShoulder(nbtCompound);
        if (success) {
            player.level().playSound(null, (Entity)player, SoundEvents.AXOLOTL_IDLE_AIR, player.getSoundSource(), 1.0f, 1.0f);
            this.discard();
        }
        return success;
    }

    @Nullable
    public UUID getOwnerUUID() {
        return this.ownerUuid;
    }

    @Nullable
    public LivingEntity getOwner() {
        if (this.ownerUuid == null) {
            return null;
        }
        try {
            Entity entity = ((ServerLevel)this.level()).getEntity(this.ownerUuid);
            if (entity instanceof LivingEntity) {
                return (LivingEntity)entity;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public void setOwner(LivingEntity livingEntity) {
        this.ownerUuid = livingEntity != null ? livingEntity.getUUID() : null;
    }
}

