/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.entity;

import com.google.common.base.Suppliers;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.entity.BattleStandardDarkEntity;
import net.sweenus.simplyswords.registry.EffectRegistry;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.HelperMethods;

public class BattleStandardEntity
extends PathfinderMob {
    public static final Supplier<EntityType<BattleStandardEntity>> TYPE = Suppliers.memoize(() -> EntityType.Builder.of(BattleStandardEntity::new, (MobCategory)MobCategory.MISC).build("battlestandard"));
    public LivingEntity ownerEntity;
    public String standardType;
    public int decayRate;
    public String positiveEffect;
    public String positiveEffectSecondary;
    public int positiveEffectAmplifier;
    public String negativeEffect;
    public String negativeEffectSecondary;
    public int negativeEffectAmplifier;
    public boolean dealsDamage = true;
    public boolean doesHealing = true;
    private static boolean errorLogged = false;

    public static AttributeSupplier.Builder createBattleStandardAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 150.0).add(Attributes.MOVEMENT_SPEED, 0.0).add(Attributes.KNOCKBACK_RESISTANCE, 100.0);
    }

    public BattleStandardEntity(EntityType<? extends PathfinderMob> entityType, Level world) {
        super(entityType, world);
    }

    private static void errorCatch(String identifier) {
        if (!errorLogged) {
            System.out.println("ERROR: Identifier " + identifier + " does not match any registered effects.\nDestroying banner entity now.");
            errorLogged = true;
        }
    }

    protected boolean isImmobile() {
        return true;
    }

    public boolean isPushable() {
        return false;
    }

    public boolean hurt(DamageSource source, float amount) {
        return this.ownerEntity == null;
    }

    public void baseTick() {
        if (!this.level().isClientSide()) {
            if (this.tickCount % 10 == 0) {
                this.setHealth(this.getHealth() - (float)this.decayRate);
                if (this.ownerEntity == null) {
                    this.setHealth(this.getHealth() - 1000.0f);
                }
            }
            if (this.ownerEntity != null && this.standardType != null) {
                LivingEntity le;
                AABB box;
                if (!this.ownerEntity.isAlive()) {
                    this.setHealth(this.getHealth() - 1000.0f);
                }
                int radius = 6;
                float abilityDamage = HelperMethods.spellScaledDamage("fire", (Entity)this.ownerEntity, Config.uniqueEffects.sunfire.spellScaling, Config.uniqueEffects.sunfire.damage);
                if (this.tickCount % 10 == 0) {
                    box = new AABB(this.getX() + (double)radius, this.getY() + (double)((float)radius / 3.0f), this.getZ() + (double)radius, this.getX() - (double)radius, this.getY() - (double)((float)radius / 3.0f), this.getZ() - (double)radius);
                    block28: for (Entity entity : this.level().getEntities((Entity)this, box, EntitySelector.LIVING_ENTITY_STILL_ALIVE)) {
                        if (!(entity instanceof LivingEntity) || !HelperMethods.checkFriendlyFire(le = (LivingEntity)entity, this.ownerEntity) || le == this.ownerEntity || le instanceof BattleStandardEntity || le instanceof BattleStandardDarkEntity) continue;
                        block9 : switch (this.standardType) {
                            case "sunfire": {
                                le.hurt(this.ownerEntity.damageSources().magic(), abilityDamage);
                                le.igniteForSeconds(1.0f);
                                le.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 120, 1), (Entity)this);
                                break;
                            }
                            case "nullification": {
                                for (Object statusEffectInstance : le.getActiveEffects()) {
                                    MobEffect statusEffect = (MobEffect)statusEffectInstance.getEffect().value();
                                    if (statusEffect == null || !statusEffect.isBeneficial()) continue;
                                    le.removeEffect(statusEffectInstance.getEffect());
                                    break block9;
                                }
                                continue block28;
                            }
                            case "api": {
                                if (this.dealsDamage) {
                                    le.hurt(this.ownerEntity.damageSources().magic(), abilityDamage);
                                }
                                if (this.negativeEffect != null) {
                                    try {
                                        Holder negativeEffectEntry = (Holder)BuiltInRegistries.MOB_EFFECT.getHolder(ResourceLocation.parse((String)this.negativeEffect)).orElseThrow();
                                        le.addEffect(new MobEffectInstance(negativeEffectEntry, 20, this.negativeEffectAmplifier), (Entity)this);
                                    }
                                    catch (Exception e) {
                                        BattleStandardEntity.errorCatch(this.negativeEffect);
                                        this.setHealth(this.getHealth() - 1000.0f);
                                    }
                                }
                                if (this.negativeEffectSecondary == null) break;
                                try {
                                    Holder negativeEffectSecondaryEntry = (Holder)BuiltInRegistries.MOB_EFFECT.getHolder(ResourceLocation.parse((String)this.negativeEffectSecondary)).orElseThrow();
                                    le.addEffect(new MobEffectInstance(negativeEffectSecondaryEntry, 20, this.negativeEffectAmplifier), (Entity)this);
                                    break;
                                }
                                catch (Exception e) {
                                    BattleStandardEntity.errorCatch(this.negativeEffectSecondary);
                                    this.setHealth(this.getHealth() - 1000.0f);
                                }
                            }
                        }
                    }
                    HelperMethods.spawnParticle(this.level(), (ParticleOptions)ParticleTypes.LAVA, this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
                }
                if (this.getHealth() > this.getMaxHealth() - 2.0f && this.onGround()) {
                    HelperMethods.spawnParticle(this.level(), (ParticleOptions)ParticleTypes.LAVA, this.getX(), this.getY(), this.getZ(), 0.0, 0.3, 0.0);
                    HelperMethods.spawnParticle(this.level(), (ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, this.getX(), this.getY(), this.getZ(), 0.0, 0.1, 0.0);
                    box = new AABB(this.getX() + 1.0, this.getY() + 1.0, this.getZ() + 1.0, this.getX() - 1.0, this.getY() - 1.0, this.getZ() - 1.0);
                    for (Entity entity : this.level().getEntities((Entity)this, box, EntitySelector.LIVING_ENTITY_STILL_ALIVE)) {
                        if (!(entity instanceof LivingEntity) || !HelperMethods.checkFriendlyFire(le = (LivingEntity)entity, this.ownerEntity) || le == this.ownerEntity) continue;
                        le.hurt(this.ownerEntity.damageSources().magic(), abilityDamage * 3.0f);
                        le.igniteForSeconds(1.0f);
                        le.setDeltaMovement((le.getX() - this.getX()) / 4.0, 0.5, (le.getZ() - this.getZ()) / 4.0);
                    }
                }
                if (this.tickCount % 80 == 0) {
                    box = new AABB(this.getX() + (double)radius, this.getY() + (double)((float)radius / 3.0f), this.getZ() + (double)radius, this.getX() - (double)radius, this.getY() - (double)((float)radius / 3.0f), this.getZ() - (double)radius);
                    block31: for (Entity entities : this.level().getEntities((Entity)this, box, EntitySelector.LIVING_ENTITY_STILL_ALIVE)) {
                        if (!(entities instanceof LivingEntity) || HelperMethods.checkFriendlyFire(le = (LivingEntity)entities, this.ownerEntity)) continue;
                        float abilityHeal = HelperMethods.spellScaledDamage("healing", (Entity)this.ownerEntity, Config.uniqueEffects.sunfire.spellScalingHeal, 3.0f);
                        block19 : switch (this.standardType) {
                            case "sunfire": {
                                le.heal(abilityHeal);
                                le.addEffect(new MobEffectInstance(MobEffects.DAMAGE_BOOST, 90, 1), (Entity)this);
                                break;
                            }
                            case "nullification": {
                                for (MobEffectInstance statusEffectInstance : le.getActiveEffects()) {
                                    Holder effectEntry = statusEffectInstance.getEffect();
                                    MobEffect effect = (MobEffect)effectEntry.value();
                                    if (effect == null || effect.isBeneficial() || Objects.equals(effectEntry, EffectRegistry.getReference(EffectRegistry.BATTLE_FATIGUE))) continue;
                                    le.removeEffect(effectEntry);
                                    break block19;
                                }
                                continue block31;
                            }
                            case "api": {
                                if (this.doesHealing) {
                                    le.heal(abilityHeal);
                                }
                                if (this.positiveEffect != null) {
                                    try {
                                        Holder positiveEffectEntry = (Holder)BuiltInRegistries.MOB_EFFECT.getHolder(ResourceLocation.parse((String)this.positiveEffect)).orElseThrow();
                                        le.addEffect(new MobEffectInstance(positiveEffectEntry, 85, this.positiveEffectAmplifier), (Entity)this);
                                    }
                                    catch (Exception e) {
                                        BattleStandardEntity.errorCatch(this.positiveEffect);
                                        this.setHealth(this.getHealth() - 1000.0f);
                                    }
                                }
                                if (this.positiveEffectSecondary == null) break;
                                try {
                                    Holder positiveEffectSecondaryEntry = (Holder)BuiltInRegistries.MOB_EFFECT.getHolder(ResourceLocation.parse((String)this.positiveEffectSecondary)).orElseThrow();
                                    le.addEffect(new MobEffectInstance(positiveEffectSecondaryEntry, 85, this.positiveEffectAmplifier), (Entity)this);
                                    break;
                                }
                                catch (Exception e) {
                                    BattleStandardEntity.errorCatch(this.positiveEffectSecondary);
                                    this.setHealth(this.getHealth() - 1000.0f);
                                }
                            }
                        }
                    }
                    this.level().playSound(null, (Entity)this, (SoundEvent)SoundRegistry.ELEMENTAL_BOW_EARTH_SHOOT_IMPACT_02.get(), this.getSoundSource(), 0.1f, 0.6f);
                    double xpos = this.getX() - (double)(radius + 1);
                    double ypos = this.getY();
                    double zpos = this.getZ() - (double)(radius + 1);
                    for (int i = radius * 2; i > 0; --i) {
                        for (int j = radius * 2; j > 0; --j) {
                            float choose = (float)(Math.random() * 1.0);
                            if (!((double)choose > 0.5)) continue;
                            HelperMethods.spawnParticle(this.level(), (ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, xpos + (double)i + (double)choose, ypos, zpos + (double)j + (double)choose, 0.0, -0.1, 0.0);
                        }
                    }
                }
            }
        }
        super.baseTick();
    }
}

