/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.effect;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.player.Player;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.effect.OrbitingEffect;
import net.sweenus.simplyswords.effect.instance.SimplySwordsStatusEffectInstance;
import net.sweenus.simplyswords.registry.EffectRegistry;
import net.sweenus.simplyswords.util.HelperMethods;

public class FrostVortexEffect
extends OrbitingEffect {
    public LivingEntity sourceEntity;
    public int additionalData;

    public FrostVortexEffect(MobEffectCategory statusEffectCategory, int color) {
        super(statusEffectCategory, color);
        this.setParticleType((ParticleOptions)ParticleTypes.SNOWFLAKE);
    }

    public void setSourcePlayer(LivingEntity livingEntity) {
        this.sourceEntity = livingEntity;
    }

    public void setAdditionalData(int data) {
        this.additionalData = data;
    }

    @Override
    public boolean applyEffectTick(LivingEntity livingEntity, int amplifier) {
        if (!livingEntity.level().isClientSide()) {
            ServerLevel serverWorld = (ServerLevel)livingEntity.level();
            float abilityDamage = 0.0f;
            MobEffectInstance mobEffectInstance = livingEntity.getEffect(EffectRegistry.getReference(EffectRegistry.FROST_VORTEX));
            if (mobEffectInstance instanceof SimplySwordsStatusEffectInstance) {
                SimplySwordsStatusEffectInstance statusEffect = (SimplySwordsStatusEffectInstance)mobEffectInstance;
                this.sourceEntity = statusEffect.getSourceEntity();
                this.additionalData = statusEffect.getAdditionalData();
            }
            if (livingEntity.tickCount % Math.max(1, 15 - amplifier) == 0 && this.additionalData != 0) {
                DamageSource damageSource = livingEntity.damageSources().magic();
                livingEntity.invulnerableTime = 0;
                if (this.sourceEntity != null) {
                    LivingEntity livingEntity2;
                    damageSource = livingEntity.damageSources().indirectMagic((Entity)livingEntity, (Entity)this.sourceEntity);
                    float spellScalingModifier = Config.uniqueEffects.tempest.spellScaling;
                    abilityDamage = HelperMethods.commonSpellAttributeScaling(spellScalingModifier, (Entity)this.sourceEntity, "frost");
                    if (livingEntity instanceof Player && (livingEntity2 = this.sourceEntity) instanceof Player) {
                        Player sourcePlayer = (Player)livingEntity2;
                        damageSource = livingEntity.damageSources().playerAttack(sourcePlayer);
                    }
                }
                livingEntity.hurt(damageSource, (float)this.additionalData + (float)amplifier / 4.0f + abilityDamage);
            }
            if (livingEntity.tickCount % 40 == 0) {
                HelperMethods.spawnOrbitParticles(serverWorld, livingEntity.position().add(0.0, (double)(livingEntity.getBbHeight() / 2.0f), 0.0), (ParticleOptions)ParticleTypes.CLOUD, 1.0, 6);
                HelperMethods.spawnOrbitParticles(serverWorld, livingEntity.position().add(0.0, (double)(livingEntity.getBbHeight() / 2.0f), 0.0), (ParticleOptions)ParticleTypes.FALLING_WATER, 1.0, 6);
            }
        }
        super.applyEffectTick(livingEntity, amplifier);
        return true;
    }

    @Override
    public void removeAttributeModifiers(AttributeMap attributes) {
        super.removeAttributeModifiers(attributes);
    }

    @Override
    public boolean shouldApplyEffectTickThisTick(int pDuration, int pAmplifier) {
        return super.shouldApplyEffectTickThisTick(pDuration, pAmplifier);
    }
}

