/*
 * Decompiled with CFR 0.152.
 */
package net.bettercombat.particle;

import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import net.bettercombat.particle.SlashParticleEffect;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;

public class BetterCombatParticles {
    private static final int default_age = 20;
    private static final int default_frames = 8;
    public static final ArrayList<Entry> ENTRIES = new ArrayList();
    public static final Entry botslash45 = BetterCombatParticles.add(new Entry("botslash45"));
    public static final Entry botslash90 = BetterCombatParticles.add(new Entry("botslash90"));
    public static final Entry botslash180 = BetterCombatParticles.add(new Entry("botslash180"));
    public static final Entry botslash270 = BetterCombatParticles.add(new Entry("botslash270"));
    public static final Entry botslash360 = BetterCombatParticles.add(new Entry("botslash360"));
    public static final Entry botstab = BetterCombatParticles.add(new Entry("botstab"));
    public static final Entry topslash45 = BetterCombatParticles.add(new Entry("topslash45"));
    public static final Entry topslash90 = BetterCombatParticles.add(new Entry("topslash90"));
    public static final Entry topslash180 = BetterCombatParticles.add(new Entry("topslash180"));
    public static final Entry topslash270 = BetterCombatParticles.add(new Entry("topslash270"));
    public static final Entry topslash360 = BetterCombatParticles.add(new Entry("topslash360"));
    public static final Entry topstab = BetterCombatParticles.add(new Entry("topstab"));

    private static ParticleType<SlashParticleEffect> createParticle() {
        return new ParticleType<SlashParticleEffect>(false){

            public MapCodec<SlashParticleEffect> codec() {
                return SlashParticleEffect.createCodec(this);
            }

            public StreamCodec<? super RegistryFriendlyByteBuf, SlashParticleEffect> streamCodec() {
                return SlashParticleEffect.createPacketCodec(this);
            }
        };
    }

    private static Entry add(Entry simpleEntry) {
        ENTRIES.add(simpleEntry);
        return simpleEntry;
    }

    public static void register() {
        for (Entry entry : ENTRIES) {
            Registry.register((Registry)BuiltInRegistries.PARTICLE_TYPE, (ResourceLocation)entry.id, entry.particleType);
        }
    }

    public record Entry(ResourceLocation id, Texture texture, StaticParams params, ParticleType<SlashParticleEffect> particleType) {
        public Entry(String name, Texture texture, StaticParams params) {
            this(ResourceLocation.fromNamespaceAndPath((String)"bettercombat", (String)name), texture, params);
        }

        public Entry(String name, int textureFrames, StaticParams params) {
            this(ResourceLocation.fromNamespaceAndPath((String)"bettercombat", (String)name), Texture.of(name, textureFrames), params);
        }

        public Entry(ResourceLocation id, Texture texture, StaticParams params) {
            this(id, texture, params, BetterCombatParticles.createParticle());
        }

        public Entry(String name) {
            this(ResourceLocation.fromNamespaceAndPath((String)"bettercombat", (String)name), Texture.of(name, 8), new StaticParams(true, 20, 1.0f));
        }
    }

    public record Texture(ResourceLocation id, int frames) {
        public static Texture vanilla(String name) {
            return new Texture(ResourceLocation.withDefaultNamespace((String)name), 1);
        }

        public static Texture vanilla(String name, int frames) {
            return new Texture(ResourceLocation.withDefaultNamespace((String)name), frames);
        }

        public static Texture of(String name) {
            return new Texture(ResourceLocation.fromNamespaceAndPath((String)"bettercombat", (String)name), 1);
        }

        public static Texture of(String name, int frames) {
            return new Texture(ResourceLocation.fromNamespaceAndPath((String)"bettercombat", (String)name), frames);
        }
    }

    public record DynamicParams(float red, float green, float blue, float alpha) {
    }

    public record StaticParams(boolean animated, int maxAge, float scale) {
    }
}

