/*
 * Decompiled with CFR 0.152.
 */
package dev.wuffs.bcc.neoforge;

import com.mojang.logging.LogUtils;
import dev.wuffs.bcc.BetterCompatibilityChecker;
import dev.wuffs.bcc.Config;
import dev.wuffs.bcc.data.BetterStatus;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.CrashReportCallables;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import org.slf4j.Logger;

@Mod(value="bcc")
public class BetterCompatibilityCheckerNeoForge {
    private static final Logger LOGGER = LogUtils.getLogger();

    public BetterCompatibilityCheckerNeoForge(IEventBus modEventBus, ModContainer modContainer) {
        BetterCompatibilityChecker.get().init();
        LOGGER.info("Better Compatibility Checker starting");
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.CONFIG);
        modEventBus.addListener(this::commonSetup);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        BetterCompatibilityChecker.get().onSetup(BetterCompatibilityCheckerNeoForge::registerCrashCallable);
    }

    private static void registerCrashCallable(BetterStatus status) {
        LOGGER.info("Loaded BetterCompatibilityChecker - Modpack: {} | Version: {}", (Object)status.name(), (Object)status.version());
        CrashReportCallables.registerCrashCallable((String)"BetterCompatibilityChecker", () -> "Modpack Name: " + status.name() + " | Modpack Version: " + status.version());
    }
}

