/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.world.temperature;

import com.lightning.northstar.block.tech.temperature_regulator.TemperatureRegulatorBlockEntity;
import com.lightning.northstar.config.NorthstarConfigs;
import com.lightning.northstar.content.NorthstarFluids;
import com.lightning.northstar.content.NorthstarTags;
import com.lightning.northstar.world.SealingProvider;
import com.lightning.northstar.world.dimension.NorthstarDimensions;
import com.lightning.northstar.world.dimension.NorthstarPlanets;
import com.lightning.northstar.world.sealer.ProgressiveBlockUpdater;
import com.lightning.northstar.world.sealer.SealingMode;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllFluids;
import it.unimi.dsi.fastutil.longs.LongCollection;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import org.jetbrains.annotations.ApiStatus;

@EventBusSubscriber(modid="northstar", value={Dist.CLIENT})
public class NorthstarTemperature {
    public static final int MINIMUM_TEMPERATURE = -273;
    public static final int MAXIMUM_TEMPERATURE = 1500;
    private final Level level;
    private final Set<Provider> providers;
    private final ProgressiveBlockUpdater updater;

    public NorthstarTemperature(Level level) {
        this.level = level;
        this.providers = new HashSet<Provider>();
        this.updater = new ProgressiveBlockUpdater(SealingMode.TEMPERATURE);
    }

    public float getTemperatureAt(Vec3 pos) {
        float temperature = 0.0f;
        int count = 0;
        for (Provider provider : this.providers) {
            if (!provider.isSealed(pos)) continue;
            temperature += provider.getTemperature();
            ++count;
        }
        return count == 0 ? NorthstarTemperature.getBaseTemperature(this.level, BlockPos.containing((Position)pos)) : temperature / (float)count;
    }

    public float getTemperatureAt(Vec3i pos) {
        BlockPos bp;
        float temperature = 0.0f;
        int count = 0;
        for (Provider provider : this.providers) {
            if (!provider.isSealed(pos)) continue;
            temperature += provider.getTemperature();
            ++count;
        }
        return count == 0 ? NorthstarTemperature.getBaseTemperature(this.level, pos instanceof BlockPos ? (bp = (BlockPos)pos) : new BlockPos(pos)) : temperature / (float)count;
    }

    public void registerSealer(Provider provider) {
        this.providers.add(provider);
    }

    public void unregisterSealer(Provider provider) {
        this.providers.remove(provider);
    }

    public void enqueueUpdates(LongCollection positions) {
        this.updater.queueUpdates(positions);
    }

    @ApiStatus.Internal
    public void processUpdates(ServerLevel level) {
        this.updater.processUpdates((Level)level);
    }

    public static float getTemperatureAt(Level level, Vec3 pos) {
        return level.northstar$temperature().getTemperatureAt(pos);
    }

    public static float getTemperatureAt(Level level, Vec3i pos) {
        return level.northstar$temperature().getTemperatureAt(pos);
    }

    public static NorthstarTemperature getDimension(Level level) {
        return level.northstar$temperature();
    }

    public static float getBaseTemperature(Level level, BlockPos pos) {
        if (level.dimension() == NorthstarDimensions.MERCURY_DIM_KEY) {
            return level.canSeeSky(pos) && !level.isNight() ? 434.0f : -200.0f;
        }
        return NorthstarPlanets.getPlanetTemp((ResourceKey<Level>)level.dimension());
    }

    @ApiStatus.Internal
    public static void tickEntity(LivingEntity entity) {
        Player player;
        if (entity.level().isClientSide()) {
            return;
        }
        float temp = NorthstarTemperature.getTemperatureAt(entity.level(), entity.getEyePosition());
        boolean hasInsulation = NorthstarTemperature.hasInsulation(entity);
        boolean hasHeatProtection = NorthstarTemperature.hasHeatProtection(entity);
        if (entity instanceof Player && ((player = (Player)entity).isCreative() || player.isSpectator())) {
            return;
        }
        if (temp > -32.0f && temp < 300.0f) {
            return;
        }
        if (temp < -32.0f && !hasInsulation && !NorthstarTags.NorthstarEntityTags.CAN_SURVIVE_COLD.matches((Entity)entity)) {
            int ticksFrozen = Math.min(entity.getTicksRequiredToFreeze(), entity.getTicksFrozen()) + 3;
            entity.setTicksFrozen(ticksFrozen);
            if (ticksFrozen >= entity.getTicksRequiredToFreeze() / 2) {
                int damage = entity.getType().is(EntityTypeTags.FREEZE_HURTS_EXTRA_TYPES) ? 7 : 2;
                entity.hurt(entity.level().damageSources().freeze(), (float)damage);
            }
        }
        if (temp > 300.0f && !entity.fireImmune() && !hasHeatProtection && !NorthstarTags.NorthstarEntityTags.CAN_SURVIVE_HEAT.matches((Entity)entity)) {
            entity.setRemainingFireTicks(100);
        }
    }

    public static boolean isCombustible(FluidState state) {
        return state.is(NorthstarFluids.HYDROCARBON.getSource().getSource());
    }

    public static int combustionTemp(FluidState state) {
        if (state.is(NorthstarFluids.HYDROCARBON.getSource().getSource()) || state.is((Fluid)NorthstarFluids.HYDROCARBON.get())) {
            return 300;
        }
        return 1000;
    }

    public static int getBoilingPoint(FluidState state) {
        if (state.is((Fluid)Fluids.WATER) || state.is((Fluid)Fluids.FLOWING_WATER)) {
            return 100;
        }
        if (state.is((Fluid)Fluids.LAVA) || state.is((Fluid)Fluids.FLOWING_LAVA)) {
            return 1200;
        }
        if (state.is((Fluid)AllFluids.CHOCOLATE.get()) || state.is((Fluid)AllFluids.HONEY.get())) {
            return 70;
        }
        if (state.is((Fluid)NorthstarFluids.METHANE.get()) || state.is(NorthstarFluids.METHANE.getSource().getSource())) {
            return -80;
        }
        if (state.is((Fluid)NorthstarFluids.HYDROCARBON.get()) || state.is(NorthstarFluids.HYDROCARBON.getSource().getSource())) {
            return 500;
        }
        if (state.is((Fluid)NorthstarFluids.LIQUID_OXYGEN.get()) || state.is(NorthstarFluids.LIQUID_OXYGEN.getSource().getSource())) {
            return -180;
        }
        if (state.is((Fluid)NorthstarFluids.LIQUID_HYDROGEN.get()) || state.is(NorthstarFluids.LIQUID_HYDROGEN.getSource().getSource())) {
            return -253;
        }
        if (state.is((Fluid)NorthstarFluids.SULFURIC_ACID.get()) || state.is(NorthstarFluids.SULFURIC_ACID.getSource().getSource())) {
            return 1200;
        }
        return Integer.MAX_VALUE;
    }

    public static int getFreezingPoint(FluidState state) {
        if (state.is((Fluid)Fluids.WATER) || state.is((Fluid)Fluids.FLOWING_WATER)) {
            return 0;
        }
        if (state.is((Fluid)Fluids.LAVA) || state.is((Fluid)Fluids.FLOWING_LAVA)) {
            return -200;
        }
        if (state.is((Fluid)AllFluids.CHOCOLATE.get()) || state.is((Fluid)AllFluids.HONEY.get())) {
            return 20;
        }
        if (state.is((Fluid)NorthstarFluids.METHANE.get()) || state.is(NorthstarFluids.METHANE.getSource().getSource())) {
            return -200;
        }
        if (state.is((Fluid)NorthstarFluids.LIQUID_OXYGEN.get()) || state.is(NorthstarFluids.LIQUID_OXYGEN.getSource().getSource())) {
            return -220;
        }
        if (state.is((Fluid)NorthstarFluids.HYDROCARBON.get()) || state.is(NorthstarFluids.HYDROCARBON.getSource().getSource())) {
            return -60;
        }
        if (state.is((Fluid)NorthstarFluids.LIQUID_HYDROGEN.get()) || state.is(NorthstarFluids.LIQUID_HYDROGEN.getSource().getSource())) {
            return -259;
        }
        if (state.is((Fluid)NorthstarFluids.SULFURIC_ACID.get()) || state.is(NorthstarFluids.SULFURIC_ACID.getSource().getSource())) {
            return -200;
        }
        return Integer.MIN_VALUE;
    }

    public static boolean hasInsulation(LivingEntity entity) {
        return entity.getItemBySlot(EquipmentSlot.HEAD).is(NorthstarTags.NorthstarItemTags.INSULATING.tag) && entity.getItemBySlot(EquipmentSlot.CHEST).is(NorthstarTags.NorthstarItemTags.INSULATING.tag) && entity.getItemBySlot(EquipmentSlot.LEGS).is(NorthstarTags.NorthstarItemTags.INSULATING.tag) && entity.getItemBySlot(EquipmentSlot.FEET).is(NorthstarTags.NorthstarItemTags.INSULATING.tag) || NorthstarTags.NorthstarEntityTags.CAN_SURVIVE_COLD.matches((Entity)entity);
    }

    public static boolean hasHeatProtection(LivingEntity entity) {
        return entity.getItemBySlot(EquipmentSlot.HEAD).is(NorthstarTags.NorthstarItemTags.HEAT_RESISTANT.tag) && entity.getItemBySlot(EquipmentSlot.CHEST).is(NorthstarTags.NorthstarItemTags.HEAT_RESISTANT.tag) && entity.getItemBySlot(EquipmentSlot.LEGS).is(NorthstarTags.NorthstarItemTags.HEAT_RESISTANT.tag) && entity.getItemBySlot(EquipmentSlot.FEET).is(NorthstarTags.NorthstarItemTags.HEAT_RESISTANT.tag) || NorthstarTags.NorthstarEntityTags.CAN_SURVIVE_HEAT.matches((Entity)entity);
    }

    public static double getHeatRating(ResourceKey<Level> level) {
        if (level == NorthstarDimensions.MOON_DIM_KEY) {
            return 0.0;
        }
        if (level == NorthstarDimensions.MARS_DIM_KEY) {
            return 0.05;
        }
        if (level == NorthstarDimensions.MERCURY_DIM_KEY) {
            return 0.0;
        }
        if (level == NorthstarDimensions.VENUS_DIM_KEY) {
            return 5.0;
        }
        if (level == Level.OVERWORLD) {
            return 0.4;
        }
        return 1.0;
    }

    public static double getHeatConstant(ResourceKey<Level> level) {
        if (level == NorthstarDimensions.MOON_DIM_KEY) {
            return 0.0;
        }
        if (level == NorthstarDimensions.MARS_DIM_KEY) {
            return 50.0;
        }
        if (level == NorthstarDimensions.MERCURY_DIM_KEY) {
            return 0.0;
        }
        if (level == NorthstarDimensions.VENUS_DIM_KEY) {
            return 1000.0;
        }
        if (level == Level.OVERWORLD) {
            return 100.0;
        }
        return 1.0;
    }

    public static void evaporate(Level level, BlockPos pos) {
        RandomSource random = level.random;
        level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
        level.playSound(null, pos, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 0.5f, 2.6f + (random.nextFloat() - random.nextFloat()) * 0.8f);
        for (int i = 0; i < 8; ++i) {
            level.addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, (double)((float)pos.getX() + random.nextFloat()), (double)((float)pos.getY() + random.nextFloat()), (double)((float)pos.getZ() + random.nextFloat()), 0.0, 0.0, 0.0);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onPostRender(RenderLevelStageEvent event) {
        if (!((Boolean)NorthstarConfigs.client().debugSealerBounds.get()).booleanValue()) {
            return;
        }
        if (event.getStage().equals(RenderLevelStageEvent.Stage.AFTER_SOLID_BLOCKS)) {
            PoseStack pose = event.getPoseStack();
            Vec3 pos = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
            pose.pushPose();
            pose.translate(-pos.x, -pos.y, -pos.z);
            for (Provider provider : Minecraft.getInstance().level.northstar$temperature().providers) {
                if (!(provider instanceof TemperatureRegulatorBlockEntity)) continue;
                TemperatureRegulatorBlockEntity regulator = (TemperatureRegulatorBlockEntity)provider;
                regulator.getSealer().getVisualizer().render(pose, (MultiBufferSource)Minecraft.getInstance().renderBuffers().bufferSource());
            }
            pose.popPose();
        }
    }

    public static interface Provider
    extends SealingProvider {
        public float getTemperature();
    }
}

