/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.world.sealer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.longs.LongLongPair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import software.bernie.geckolib.util.Color;

public interface SealerDebugVisualizer {
    public static final Noop NOOP = new Noop();

    public void addConnection(long var1, long var3);

    public void complete();

    @OnlyIn(value=Dist.CLIENT)
    public void render(PoseStack var1, MultiBufferSource var2);

    public static class Noop
    implements SealerDebugVisualizer {
        private Noop() {
        }

        @Override
        public void addConnection(long pos1, long pos2) {
        }

        @Override
        public void complete() {
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void render(PoseStack pose, MultiBufferSource buffer) {
        }
    }

    public static class Client
    implements SealerDebugVisualizer {
        private final int color = Color.HSBtoARGB((float)((float)Math.random()), (float)0.8f, (float)0.8f);
        private final BlockPos.MutableBlockPos tempPos1 = new BlockPos.MutableBlockPos();
        private final BlockPos.MutableBlockPos tempPos2 = new BlockPos.MutableBlockPos();
        private final List<LongLongPair> debugConnections = new ArrayList<LongLongPair>();
        private final List<LongLongPair> finalDebugConnections = new ArrayList<LongLongPair>();

        @Override
        public void addConnection(long pos1, long pos2) {
            this.debugConnections.add(LongLongPair.of((long)pos1, (long)pos2));
        }

        @Override
        public void complete() {
            this.finalDebugConnections.clear();
            this.finalDebugConnections.addAll(this.debugConnections);
            this.debugConnections.clear();
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void render(PoseStack pose, MultiBufferSource buffer) {
            VertexConsumer vc = buffer.getBuffer(RenderType.lines());
            PoseStack.Pose last = pose.last();
            for (LongLongPair connection : this.finalDebugConnections) {
                this.tempPos1.set(connection.firstLong());
                this.tempPos2.set(connection.secondLong());
                float nx = this.tempPos2.getX() - this.tempPos1.getX();
                float ny = this.tempPos2.getY() - this.tempPos1.getY();
                float nz = this.tempPos2.getZ() - this.tempPos1.getZ();
                vc.addVertex(last, (float)this.tempPos1.getX() + 0.5f, (float)this.tempPos1.getY() + 0.5f, (float)this.tempPos1.getZ() + 0.5f).setColor(this.color).setNormal(last, nx, ny, nz);
                vc.addVertex(last, (float)this.tempPos2.getX() + 0.5f, (float)this.tempPos2.getY() + 0.5f, (float)this.tempPos2.getZ() + 0.5f).setColor(this.color).setNormal(last, nx, ny, nz);
            }
        }
    }
}

