/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.world.sealer;

import com.lightning.northstar.accessor.NorthstarFluidState;
import com.lightning.northstar.world.sealer.SealReactiveBlock;
import com.lightning.northstar.world.sealer.SealingMode;
import it.unimi.dsi.fastutil.longs.LongArrayFIFOQueue;
import it.unimi.dsi.fastutil.longs.LongCollection;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;

public class ProgressiveBlockUpdater {
    private final SealingMode mode;
    private final LongArrayFIFOQueue queue = new LongArrayFIFOQueue();
    private final BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();

    public ProgressiveBlockUpdater(SealingMode mode) {
        this.mode = mode;
    }

    public void queueUpdates(LongCollection positions) {
        positions.forEach(arg_0 -> ((LongArrayFIFOQueue)this.queue).enqueue(arg_0));
    }

    public void processUpdates(Level level) {
        LongArrayFIFOQueue queue = this.queue;
        BlockPos.MutableBlockPos pos = this.pos;
        int j = Math.max(4096, queue.size() / 32);
        for (int i = 0; i < j && !queue.isEmpty(); ++i) {
            FluidState fluidstate;
            BlockState blockstate = level.getBlockState((BlockPos)pos.set(queue.dequeueLong()));
            Block block = blockstate.getBlock();
            if (block instanceof SealReactiveBlock) {
                SealReactiveBlock block2 = (SealReactiveBlock)block;
                block2.northstar$onSealUpdated(level, (BlockPos)pos, blockstate, this.mode);
            }
            if ((fluidstate = level.getFluidState((BlockPos)pos)).isEmpty()) continue;
            ((NorthstarFluidState)fluidstate).northstar$onSealUpdated(level, (BlockPos)pos, this.mode);
        }
    }

    public SealingMode getMode() {
        return this.mode;
    }

    public LongArrayFIFOQueue getQueue() {
        return this.queue;
    }
}

