/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.world.oxygen;

import com.lightning.northstar.block.tech.oxygen_sealer.OxygenSealerBlockEntity;
import com.lightning.northstar.config.NorthstarConfigs;
import com.lightning.northstar.content.NorthstarDataComponents;
import com.lightning.northstar.content.NorthstarTags;
import com.lightning.northstar.world.SealingProvider;
import com.lightning.northstar.world.dimension.NorthstarPlanets;
import com.lightning.northstar.world.sealer.ProgressiveBlockUpdater;
import com.lightning.northstar.world.sealer.SealingMode;
import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.longs.LongCollection;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.event.entity.living.LivingBreatheEvent;
import org.jetbrains.annotations.ApiStatus;

@EventBusSubscriber(modid="northstar")
public class NorthstarOxygen {
    public static final int MAXIMUM_OXYGEN = 1800;
    private final Level level;
    private final Set<Provider> providers;
    private final ProgressiveBlockUpdater updater;

    public NorthstarOxygen(Level level) {
        this.level = level;
        this.providers = new HashSet<Provider>();
        this.updater = new ProgressiveBlockUpdater(SealingMode.OXYGEN);
    }

    public boolean hasOxygen() {
        return NorthstarPlanets.getPlanetOxy((ResourceKey<Level>)this.level.dimension());
    }

    public Provider getSealer(Vec3 pos) {
        for (Provider sealer : this.providers) {
            if (!sealer.isSealed(pos)) continue;
            return sealer;
        }
        return null;
    }

    public Provider getSealer(Vec3i pos) {
        for (Provider sealer : this.providers) {
            if (!sealer.isSealed(pos)) continue;
            return sealer;
        }
        return null;
    }

    public boolean hasOxygen(Vec3 pos) {
        return NorthstarPlanets.getPlanetOxy((ResourceKey<Level>)this.level.dimension()) || this.getSealer(pos) != null;
    }

    public boolean hasOxygen(Vec3i pos) {
        return NorthstarPlanets.getPlanetOxy((ResourceKey<Level>)this.level.dimension()) || this.getSealer(pos) != null;
    }

    public void registerSealer(Provider provider) {
        this.providers.add(provider);
    }

    public void unregisterSealer(Provider provider) {
        this.providers.remove(provider);
    }

    public void enqueueUpdates(LongCollection positions) {
        this.updater.queueUpdates(positions);
    }

    @ApiStatus.Internal
    public void processUpdates(ServerLevel level) {
        this.updater.processUpdates((Level)level);
    }

    public static boolean isOxygen(Fluid fluid) {
        return NorthstarTags.NorthstarFluidTags.C_OXYGEN.matches(fluid) || NorthstarTags.NorthstarFluidTags.BREATHABLE.matches(fluid);
    }

    public static boolean hasOxygen(Level level, Vec3 pos) {
        return level.northstar$oxygen().hasOxygen(pos);
    }

    public static boolean hasOxygen(Level level, Vec3i pos) {
        return level.northstar$oxygen().hasOxygen(pos);
    }

    public static NorthstarOxygen getDimension(Level level) {
        return level.northstar$oxygen();
    }

    public static ItemStack getOxygenTank(LivingEntity entity) {
        for (ItemStack item : entity.getArmorSlots()) {
            if (!item.is(NorthstarTags.NorthstarItemTags.OXYGEN_SOURCES.tag)) continue;
            return item;
        }
        return ItemStack.EMPTY;
    }

    @SubscribeEvent
    public static void onBreathe(LivingBreatheEvent event) {
        Player player;
        LivingEntity entity = event.getEntity();
        Level world = entity.level();
        if (entity instanceof Player && ((player = (Player)entity).isCreative() || player.isSpectator())) {
            return;
        }
        if (NorthstarTags.NorthstarEntityTags.DOESNT_REQUIRE_OXYGEN.matches((Entity)entity)) {
            event.setCanBreathe(true);
            return;
        }
        NorthstarOxygen oxygen = world.northstar$oxygen();
        boolean atmosphereBreathable = oxygen.hasOxygen();
        if (atmosphereBreathable && event.canBreathe()) {
            return;
        }
        Provider sealer = oxygen.getSealer(entity.getEyePosition());
        if (sealer != null) {
            event.setCanBreathe(true);
            sealer.drainOxygen(NorthstarConfigs.server().oxygenSealerEntityActiveDrain.getF());
            return;
        }
        boolean isFullyCovered = true;
        ItemStack oxygenSource = ItemStack.EMPTY;
        for (ItemStack armor : entity.getArmorSlots()) {
            if (armor.isEmpty()) {
                isFullyCovered = false;
                break;
            }
            if (!NorthstarTags.NorthstarItemTags.OXYGEN_SOURCES.matches(armor)) continue;
            oxygenSource = armor;
        }
        if (isFullyCovered && !oxygenSource.isEmpty() && NorthstarOxygen.depleteOxygen(oxygenSource, world.getGameTime() % 20L == 0L)) {
            event.setCanBreathe(true);
        } else if (!atmosphereBreathable && world.getGameTime() % 10L != (long)(entity.getId() % 10)) {
            entity.hurt(world.damageSources().northstar$suffocation(), 1.0f);
        }
    }

    public static boolean depleteOxygen(ItemStack stack, boolean deplete) {
        if (!stack.has(NorthstarDataComponents.OXYGEN)) {
            return false;
        }
        int oxygen = (Integer)stack.get(NorthstarDataComponents.OXYGEN);
        if (oxygen <= 0) {
            return false;
        }
        if (deplete) {
            stack.set(NorthstarDataComponents.OXYGEN, (Object)Math.min(oxygen - 1, 1800));
        }
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onPostRender(RenderLevelStageEvent event) {
        if (!((Boolean)NorthstarConfigs.client().debugSealerBounds.get()).booleanValue()) {
            return;
        }
        if (event.getStage().equals(RenderLevelStageEvent.Stage.AFTER_SOLID_BLOCKS)) {
            PoseStack pose = event.getPoseStack();
            Vec3 pos = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
            pose.pushPose();
            pose.translate(-pos.x, -pos.y, -pos.z);
            for (SealingProvider sealingProvider : NorthstarOxygen.getDimension((Level)Minecraft.getInstance().level).providers) {
                if (!(sealingProvider instanceof OxygenSealerBlockEntity)) continue;
                OxygenSealerBlockEntity sealer = (OxygenSealerBlockEntity)sealingProvider;
                sealer.getSealer().getVisualizer().render(pose, (MultiBufferSource)Minecraft.getInstance().renderBuffers().bufferSource());
            }
            pose.popPose();
        }
    }

    public static interface Provider
    extends SealingProvider {
        public void drainOxygen(float var1);
    }
}

