/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.world.features;

import com.google.common.collect.Lists;
import com.lightning.northstar.world.features.configuration.SphereConfig;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.GeodeBlockSettings;
import net.minecraft.world.level.levelgen.GeodeCrackSettings;
import net.minecraft.world.level.levelgen.GeodeLayerSettings;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import net.minecraft.world.level.material.FluidState;

public class SphereFeature
extends Feature<SphereConfig> {
    private static final Direction[] DIRECTIONS = Direction.values();

    public SphereFeature(Codec<SphereConfig> p_159834_) {
        super(p_159834_);
    }

    public boolean place(FeaturePlaceContext<SphereConfig> context) {
        SphereConfig config = (SphereConfig)context.config();
        RandomSource randomsource = context.random();
        BlockPos blockpos = context.origin();
        WorldGenLevel worldgenlevel = context.level();
        int i = config.minGenOffset();
        int j = config.maxGenOffset();
        LinkedList list = Lists.newLinkedList();
        int k = config.distributionPoints().sample(randomsource);
        WorldgenRandom worldgenrandom = new WorldgenRandom((RandomSource)new LegacyRandomSource(worldgenlevel.getSeed()));
        NormalNoise normalnoise = NormalNoise.create((RandomSource)worldgenrandom, (int)-4, (double[])new double[]{1.0});
        LinkedList list1 = Lists.newLinkedList();
        double d0 = (double)k / (double)config.outerWallDistance().getMaxValue();
        GeodeLayerSettings geodelayersettings = config.geodeLayerSettings();
        GeodeBlockSettings geodeblocksettings = config.geodeBlockSettings();
        GeodeCrackSettings geodecracksettings = config.geodeCrackSettings();
        double d1 = 1.0 / Math.sqrt(geodelayersettings.filling);
        double d2 = 1.0 / Math.sqrt(geodelayersettings.innerLayer + d0);
        double d3 = 1.0 / Math.sqrt(geodelayersettings.middleLayer + d0);
        double d4 = 1.0 / Math.sqrt(geodelayersettings.outerLayer + d0);
        double d5 = 1.0 / Math.sqrt(geodecracksettings.baseCrackSize + randomsource.nextDouble() / 2.0 + (k > 3 ? d0 : 0.0));
        boolean flag = (double)randomsource.nextFloat() < geodecracksettings.generateCrackChance;
        int l = 0;
        for (int i1 = 0; i1 < k; ++i1) {
            int l1;
            int k1;
            int j1 = config.outerWallDistance().sample(randomsource);
            BlockPos blockpos1 = blockpos.offset(j1, k1 = config.outerWallDistance().sample(randomsource), l1 = config.outerWallDistance().sample(randomsource));
            BlockState blockstate = worldgenlevel.getBlockState(blockpos1);
            if ((blockstate.isAir() || blockstate.is(BlockTags.GEODE_INVALID_BLOCKS)) && ++l > config.invalidBlocksThreshold()) {
                return false;
            }
            list.add(Pair.of((Object)blockpos1, (Object)config.pointOffset().sample(randomsource)));
        }
        if (flag) {
            int i2 = randomsource.nextInt(4);
            int j2 = k * 2 + 1;
            if (i2 == 0) {
                list1.add(blockpos.offset(j2, 7, 0));
                list1.add(blockpos.offset(j2, 5, 0));
                list1.add(blockpos.offset(j2, 1, 0));
            } else if (i2 == 1) {
                list1.add(blockpos.offset(0, 7, j2));
                list1.add(blockpos.offset(0, 5, j2));
                list1.add(blockpos.offset(0, 1, j2));
            } else if (i2 == 2) {
                list1.add(blockpos.offset(j2, 7, j2));
                list1.add(blockpos.offset(j2, 5, j2));
                list1.add(blockpos.offset(j2, 1, j2));
            } else {
                list1.add(blockpos.offset(0, 7, 0));
                list1.add(blockpos.offset(0, 5, 0));
                list1.add(blockpos.offset(0, 1, 0));
            }
        }
        ArrayList list2 = Lists.newArrayList();
        Predicate predicate = SphereFeature.isReplaceable((TagKey)config.geodeBlockSettings().cannotReplace);
        for (BlockPos blockpos3 : BlockPos.betweenClosed((BlockPos)blockpos.offset(i, i, i), (BlockPos)blockpos.offset(j, j, j))) {
            double d8 = normalnoise.getValue((double)blockpos3.getX(), (double)blockpos3.getY(), (double)blockpos3.getZ()) * config.noiseMultiplier();
            double d6 = 0.0;
            double d7 = 0.0;
            for (Pair pair : list) {
                d6 += Mth.fastInvSqrt((double)(blockpos3.distSqr((Vec3i)pair.getFirst()) + (double)((Integer)pair.getSecond()).intValue())) + d8;
            }
            for (BlockPos blockpos6 : list1) {
                d7 += Mth.fastInvSqrt((double)(blockpos3.distSqr((Vec3i)blockpos6) + (double)geodecracksettings.crackPointOffset)) + d8;
            }
            if (d6 < d4) continue;
            if (flag && d7 >= d5 && d6 < d1) {
                this.safeSetBlock(worldgenlevel, blockpos3, Blocks.AIR.defaultBlockState(), predicate);
                for (Direction direction1 : DIRECTIONS) {
                    BlockPos blockpos2 = blockpos3.relative(direction1);
                    FluidState fluidstate = worldgenlevel.getFluidState(blockpos2);
                    if (fluidstate.isEmpty()) continue;
                    worldgenlevel.scheduleTick(blockpos2, fluidstate.getType(), 0);
                }
                continue;
            }
            if (d6 >= d1) {
                this.safeSetBlock(worldgenlevel, blockpos3, geodeblocksettings.fillingProvider.getState(randomsource, blockpos3), predicate);
                continue;
            }
            if (d6 >= d2) {
                boolean flag1;
                boolean bl = flag1 = (double)randomsource.nextFloat() < config.useAlternateLayer0Chance();
                if (flag1) {
                    this.safeSetBlock(worldgenlevel, blockpos3, geodeblocksettings.alternateInnerLayerProvider.getState(randomsource, blockpos3), predicate);
                } else {
                    this.safeSetBlock(worldgenlevel, blockpos3, geodeblocksettings.innerLayerProvider.getState(randomsource, blockpos3), predicate);
                }
                if (config.placementsRequireLayer0Alternate() && !flag1 || !((double)randomsource.nextFloat() < config.usePotentialPlacementsChance())) continue;
                list2.add(blockpos3.immutable());
                continue;
            }
            if (d6 >= d3) {
                this.safeSetBlock(worldgenlevel, blockpos3, geodeblocksettings.middleLayerProvider.getState(randomsource, blockpos3), predicate);
                continue;
            }
            if (!(d6 >= d4)) continue;
            this.safeSetBlock(worldgenlevel, blockpos3, geodeblocksettings.outerLayerProvider.getState(randomsource, blockpos3), predicate);
        }
        List list3 = geodeblocksettings.innerPlacements;
        for (BlockPos blockpos4 : list2) {
            BlockState blockstate1 = (BlockState)Util.getRandom((List)list3, (RandomSource)randomsource);
            for (Direction direction : DIRECTIONS) {
                if (blockstate1.hasProperty((Property)BlockStateProperties.FACING)) {
                    blockstate1 = (BlockState)blockstate1.setValue((Property)BlockStateProperties.FACING, (Comparable)direction);
                }
                BlockPos blockpos5 = blockpos4.relative(direction);
                BlockState blockstate2 = worldgenlevel.getBlockState(blockpos5);
                if (!blockstate1.hasProperty((Property)BlockStateProperties.WATERLOGGED)) continue;
                blockstate1 = (BlockState)blockstate1.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(blockstate2.getFluidState().isSource()));
            }
        }
        return true;
    }
}

