/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.network.packet;

import com.lightning.northstar.content.NorthstarPackets;
import io.netty.buffer.ByteBuf;
import net.createmod.catnip.codecs.stream.CatnipStreamCodecs;
import net.createmod.catnip.net.base.BasePacketPayload;
import net.createmod.catnip.net.base.ClientboundPacketPayload;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public record RelativeTeleportPacket(int entityId, Vec3 offset) implements ClientboundPacketPayload
{
    public static final StreamCodec<ByteBuf, RelativeTeleportPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, p -> p.entityId, (StreamCodec)CatnipStreamCodecs.VEC3, p -> p.offset, RelativeTeleportPacket::new);

    @OnlyIn(value=Dist.CLIENT)
    public void handle(LocalPlayer localPlayer) {
        Minecraft minecraft = Minecraft.getInstance();
        Entity other = minecraft.level.getEntity(this.entityId);
        if (other != null) {
            minecraft.player.setPos(other.position().subtract(this.offset));
        }
    }

    public BasePacketPayload.PacketTypeProvider getTypeProvider() {
        return NorthstarPackets.RELATIVE_TELEPORT;
    }
}

