/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.mixin.item;

import com.lightning.northstar.Northstar;
import com.lightning.northstar.world.temperature.NorthstarTemperature;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.common.SoundActions;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BucketItem.class})
public abstract class BucketItemMixin
extends Item {
    @Shadow
    @Final
    private Fluid content;

    public BucketItemMixin(Item.Properties pProperties) {
        super(pProperties);
    }

    @Inject(method={"emptyContents(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/phys/BlockHitResult;Lnet/minecraft/world/item/ItemStack;)Z"}, at={@At(value="HEAD", target="Lnet/minecraft/world/item/BucketItem;emptyContents(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/phys/BlockHitResult;)Z")}, cancellable=true)
    private void emptyContentsReal(@Nullable Player pPlayer, Level pLevel, BlockPos pPos, @Nullable BlockHitResult blockHitResult, ItemStack container, CallbackInfoReturnable<Boolean> info) {
        Northstar.LOGGER.debug("YOooo buckets are real");
        BucketItem item = (BucketItem)this;
        float temp = NorthstarTemperature.getTemperatureAt(pLevel, (Vec3i)pPos);
        BlockState blockstate = pLevel.getBlockState(pPos);
        if (item.content == null) {
            return;
        }
        int boilingpoint = NorthstarTemperature.getBoilingPoint(item.content.defaultFluidState());
        int freezingpoint = NorthstarTemperature.getFreezingPoint(item.content.defaultFluidState());
        Block block = pLevel.getBlockState(pPos).getBlock();
        if (!(item.content instanceof FlowingFluid)) {
            return;
        }
        if (pLevel.dimensionType().ultraWarm() && temp < (float)boilingpoint && temp > (float)freezingpoint) {
            if (pLevel.getBlockState(pPos).is(Blocks.AIR) || pLevel.getBlockState(pPos).canBeReplaced(this.content)) {
                if (!pLevel.setBlock(pPos, item.content.defaultFluidState().createLegacyBlock(), 11) && !blockstate.getFluidState().isSource()) {
                    return;
                }
                this.playEmptySound(pPlayer, (LevelAccessor)pLevel, pPos, item.content);
                info.setReturnValue((Object)true);
            } else if (block instanceof LiquidBlockContainer && ((LiquidBlockContainer)block).canPlaceLiquid(pPlayer, (BlockGetter)pLevel, pPos, blockstate, this.content)) {
                ((LiquidBlockContainer)block).placeLiquid((LevelAccessor)pLevel, pPos, blockstate, ((FlowingFluid)this.content).getSource(false));
                this.playEmptySound(pPlayer, (LevelAccessor)pLevel, pPos, item.content);
                info.setReturnValue((Object)true);
            }
        } else if (temp < (float)freezingpoint && item.content.is(FluidTags.WATER) && pLevel.getBlockState(pPos).is(Blocks.AIR)) {
            if (!pLevel.setBlock(pPos, Blocks.ICE.defaultBlockState(), 11)) {
                return;
            }
            this.playEmptySound(pPlayer, (LevelAccessor)pLevel, pPos, item.content);
            info.setReturnValue((Object)true);
        } else if (temp > (float)boilingpoint) {
            int i = pPos.getX();
            int j = pPos.getY();
            int k = pPos.getZ();
            pLevel.playSound(pPlayer, pPos, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 0.5f, 2.6f + (pLevel.random.nextFloat() - pLevel.random.nextFloat()) * 0.8f);
            for (int l = 0; l < 8; ++l) {
                pLevel.addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, (double)i + Math.random(), (double)j + Math.random(), (double)k + Math.random(), 0.0, 0.0, 0.0);
            }
            info.setReturnValue((Object)true);
        }
    }

    protected void playEmptySound(@Nullable Player pPlayer, LevelAccessor pLevel, BlockPos pPos, Fluid content) {
        SoundEvent soundevent = content.getFluidType().getSound(pPlayer, (BlockGetter)pLevel, pPos, SoundActions.BUCKET_EMPTY);
        if (soundevent == null) {
            soundevent = content.is(FluidTags.LAVA) ? SoundEvents.BUCKET_EMPTY_LAVA : SoundEvents.BUCKET_EMPTY;
        }
        pLevel.playSound(pPlayer, pPos, soundevent, SoundSource.BLOCKS, 1.0f, 1.0f);
        pLevel.gameEvent((Entity)pPlayer, (Holder)GameEvent.FLUID_PLACE, pPos);
    }
}

