/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.mixin.dimensionstuff;

import com.lightning.northstar.world.dimension.NorthstarDimensions;
import com.lightning.northstar.world.oxygen.NorthstarOxygen;
import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.CubicSampler;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.ClientHooks;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={FogRenderer.class})
public abstract class FogRendererMixin {
    @Shadow
    private static float fogRed;
    @Shadow
    private static float fogGreen;
    @Shadow
    private static float fogBlue;
    @Unique
    private static float p;

    @Inject(method={"setupColor(Lnet/minecraft/client/Camera;FLnet/minecraft/client/multiplayer/ClientLevel;IF)V"}, at={@At(value="HEAD")}, cancellable=true)
    private static void setupColor(Camera pActiveRenderInfo, float pPartialTicks, ClientLevel pLevel, int pRenderDistanceChunks, float pBossColorModifier, CallbackInfo info) {
        boolean isSubmerged;
        ResourceKey player_dim = Minecraft.getInstance().level.dimension();
        boolean bl = isSubmerged = !Minecraft.getInstance().gameRenderer.getMainCamera().getBlockAtCamera().getFluidState().isEmpty();
        if (!isSubmerged) {
            Vec3 toad;
            ClientLevel level;
            float playerEyeLevel;
            if (player_dim == NorthstarDimensions.MARS_DIM_KEY) {
                playerEyeLevel = (float)Minecraft.getInstance().player.getEyePosition((float)3.0f).y;
                info.cancel();
                Vector3f fogColor = ClientHooks.getFogColor((Camera)pActiveRenderInfo, (float)pPartialTicks, (ClientLevel)pLevel, (int)pRenderDistanceChunks, (float)pBossColorModifier, (float)fogRed, (float)fogGreen, (float)fogBlue);
                if (playerEyeLevel > 400.0f) {
                    fogRed = fogColor.x() - (playerEyeLevel - 400.0f) / 300.0f;
                    fogGreen = fogColor.y() - (playerEyeLevel - 400.0f) / 300.0f;
                    fogBlue = fogColor.z() - (playerEyeLevel - 400.0f) / 300.0f;
                } else {
                    fogRed = fogColor.x();
                    fogGreen = fogColor.y();
                    fogBlue = fogColor.z();
                }
                if (fogRed < 0.0f) {
                    fogRed = 0.0f;
                }
                if (fogGreen < 0.0f) {
                    fogGreen = 0.0f;
                }
                if (fogBlue < 0.0f) {
                    fogBlue = 0.0f;
                }
                RenderSystem.clearColor((float)fogRed, (float)fogGreen, (float)fogBlue, (float)0.0f);
            }
            if (player_dim == Level.OVERWORLD && (playerEyeLevel = (float)Minecraft.getInstance().player.getEyePosition((float)3.0f).y) > 450.0f) {
                info.cancel();
                level = Minecraft.getInstance().level;
                toad = level.getSkyColor(Minecraft.getInstance().player.getEyePosition(3.0f), pPartialTicks);
                Vector3f fogColor = ClientHooks.getFogColor((Camera)pActiveRenderInfo, (float)pPartialTicks, (ClientLevel)pLevel, (int)pRenderDistanceChunks, (float)pBossColorModifier, (float)fogRed, (float)fogGreen, (float)fogBlue);
                fogRed = (float)(toad.x() - (double)((playerEyeLevel - 500.0f) / 250.0f));
                fogGreen = (float)(toad.y() - (double)((playerEyeLevel - 500.0f) / 250.0f));
                fogBlue = (float)(toad.z() - (double)((playerEyeLevel - 500.0f) / 250.0f));
                if (fogRed < 0.0f) {
                    fogRed = 0.0f;
                }
                if (fogGreen < 0.0f) {
                    fogGreen = 0.0f;
                }
                if (fogBlue < 0.0f) {
                    fogBlue = 0.0f;
                }
                RenderSystem.clearColor((float)fogRed, (float)fogGreen, (float)fogBlue, (float)0.0f);
            }
            if (player_dim == NorthstarDimensions.VENUS_DIM_KEY) {
                playerEyeLevel = (float)Minecraft.getInstance().player.getEyePosition((float)3.0f).y;
                if (playerEyeLevel > 600.0f) {
                    info.cancel();
                    level = Minecraft.getInstance().level;
                    toad = level.getSkyColor(Minecraft.getInstance().player.getEyePosition(3.0f), pPartialTicks);
                    float time = level.getTimeOfDay(pPartialTicks);
                    float skydarken = Mth.cos((float)(time * ((float)Math.PI * 2))) * 2.0f + 0.5f;
                    Vec3 skycolor = new Vec3((double)0.975f, (double)0.914f, (double)0.471f);
                    skydarken = Mth.clamp((float)skydarken, (float)0.125f, (float)1.0f);
                    fogRed = (float)(skycolor.x * (double)skydarken - (double)((playerEyeLevel - 600.0f) / 300.0f));
                    fogGreen = (float)(skycolor.y * (double)skydarken - (double)((playerEyeLevel - 600.0f) / 300.0f));
                    fogBlue = (float)(skycolor.z * (double)skydarken - (double)((playerEyeLevel - 600.0f) / 300.0f));
                    if (fogRed < 0.0f) {
                        fogRed = 0.0f;
                    }
                    if (fogGreen < 0.0f) {
                        fogGreen = 0.0f;
                    }
                    if (fogBlue < 0.0f) {
                        fogBlue = 0.0f;
                    }
                    RenderSystem.clearColor((float)fogRed, (float)fogGreen, (float)fogBlue, (float)0.0f);
                } else {
                    info.cancel();
                    level = Minecraft.getInstance().level;
                    float time = level.getTimeOfDay(pPartialTicks);
                    float skydarken = Mth.cos((float)(time * ((float)Math.PI * 2))) * 2.0f + 0.5f;
                    Vec3 skycolor = new Vec3((double)0.975f, (double)0.914f, (double)0.471f);
                    skydarken = Mth.clamp((float)skydarken, (float)0.125f, (float)1.0f);
                    fogRed = (float)skycolor.x * skydarken;
                    fogGreen = (float)skycolor.y * skydarken;
                    fogBlue = (float)skycolor.z * skydarken;
                    if (fogRed < 0.0f) {
                        fogRed = 0.0f;
                    }
                    if (fogGreen < 0.0f) {
                        fogGreen = 0.0f;
                    }
                    if (fogBlue < 0.0f) {
                        fogBlue = 0.0f;
                    }
                    info.cancel();
                    RenderSystem.clearColor((float)fogRed, (float)fogGreen, (float)fogBlue, (float)0.0f);
                }
            }
        }
    }

    @Inject(method={"setupFog(Lnet/minecraft/client/Camera;Lnet/minecraft/client/renderer/FogRenderer$FogMode;FZF)V"}, at={@At(value="HEAD")}, cancellable=true)
    private static void setupFog(Camera pCamera, FogRenderer.FogMode pFogMode, float pFarPlaneDistance, boolean p_234176_, float p_234177_, CallbackInfo info) {
        Vector3f vector3f;
        Vec3 vec32;
        Vec3 vec31;
        float f11;
        float f10;
        float f8;
        ClientLevel level;
        float playerEyeLevel;
        float pPartialTicks = 3.0f;
        FogType fogtype = pCamera.getFluidInCamera();
        Fluid fluidInCam = pCamera.getBlockAtCamera().getFluidState().getType();
        ResourceKey player_dim = Minecraft.getInstance().level.dimension();
        if (player_dim == NorthstarDimensions.MARS_DIM_KEY) {
            playerEyeLevel = (float)Minecraft.getInstance().player.getEyePosition((float)3.0f).y;
            level = Minecraft.getInstance().level;
            float rain_det = Minecraft.getInstance().level.getRainLevel(pPartialTicks);
            if (p < 2.0f && level.getRawBrightness(pCamera.getBlockPosition(), -7) >= 16) {
                p += 0.01f;
            } else if (p > 0.0f && level.getRawBrightness(pCamera.getBlockPosition(), -7) < 16 && !NorthstarOxygen.hasOxygen((Level)level, (Vec3i)pCamera.getBlockPosition())) {
                p -= 0.01f;
            } else if (p < 0.0f) {
                p = 0.0f;
            }
            if (!(rain_det <= 0.0f) && fogtype == FogType.NONE && playerEyeLevel < 500.0f && p != 0.0f) {
                info.cancel();
                RenderSystem.setShaderFogStart((float)-8.0f);
                RenderSystem.setShaderFogEnd((float)(48.0f / p));
                RenderSystem.setShaderFogShape((FogShape)FogShape.SPHERE);
                ClientHooks.onFogRender((FogRenderer.FogMode)FogRenderer.FogMode.FOG_TERRAIN, (FogType)FogType.WATER, (Camera)pCamera, (float)pPartialTicks, (float)Minecraft.getInstance().options.getEffectiveRenderDistance(), (float)-8.0f, (float)96.0f, (FogShape)FogShape.SPHERE);
            }
            Camera cam = Minecraft.getInstance().gameRenderer.getMainCamera();
            float f4 = 0.25f + 0.75f * pFarPlaneDistance / 32.0f;
            f4 = 1.0f - (float)Math.pow(f4, 0.25);
            Vec3 vec3 = level.getSkyColor(cam.getPosition(), pPartialTicks);
            float f6 = (float)vec3.x;
            float f82 = (float)vec3.y;
            float f102 = (float)vec3.z;
            float f112 = Mth.clamp((float)(Mth.cos((float)(level.getTimeOfDay(pPartialTicks) * ((float)Math.PI * 2))) * 2.0f + 0.5f), (float)0.0f, (float)1.0f);
            BiomeManager biomemanager = level.getBiomeManager();
            Vec3 vec312 = cam.getPosition().subtract(2.0, 2.0, 2.0).scale(0.25);
            Vec3 vec322 = CubicSampler.gaussianSampleVec3((Vec3)vec312, (p_109033_, p_109034_, p_109035_) -> level.effects().getBrightnessDependentFogColor(Vec3.fromRGB24((int)((Biome)biomemanager.getNoiseBiomeAtQuart(p_109033_, p_109034_, p_109035_).value()).getFogColor()), f112));
            fogRed = (float)vec322.x();
            fogGreen = (float)vec322.y();
            fogBlue = (float)vec322.z();
            if (pFarPlaneDistance >= 4.0f) {
                float[] afloat;
                float f12 = Mth.sin((float)level.getSunAngle(pPartialTicks)) > 0.0f ? -1.0f : 1.0f;
                Vector3f vector3f2 = new Vector3f(f12, 0.0f, 0.0f);
                float f16 = cam.getLookVector().dot((Vector3fc)vector3f2);
                if (f16 < 0.0f) {
                    f16 = 0.0f;
                }
                if (f16 > 0.0f && (afloat = level.effects().getSunriseColor(level.getTimeOfDay(pPartialTicks), pPartialTicks)) != null) {
                    fogRed = fogRed * (1.0f - (f16 *= afloat[3])) + afloat[0] * f16;
                    fogGreen = fogGreen * (1.0f - f16) + afloat[1] * f16;
                    fogBlue = fogBlue * (1.0f - f16) + afloat[2] * f16;
                }
            }
            fogRed += (f6 - fogRed) * f4;
            fogGreen += (f82 - fogGreen) * f4;
            fogBlue += (f102 - fogBlue) * f4;
            Vec3 fogColor = Minecraft.getInstance().level.getSkyColor(Minecraft.getInstance().gameRenderer.getMainCamera().getPosition(), 3.0f);
            Biome biome = (Biome)level.getBiome(pCamera.getBlockPosition()).value();
            if (!(rain_det <= 0.0f) && biome.getPrecipitationAt(BlockPos.containing((Position)Minecraft.getInstance().gameRenderer.getMainCamera().getPosition())) == Biome.Precipitation.NONE) {
                fogRed = (float)fogColor.x() * 1.35f;
                fogGreen = (float)fogColor.y() * 1.15f;
                fogBlue = (float)fogColor.z();
            } else {
                fogRed = (float)fogColor.x();
                fogGreen = (float)fogColor.y();
                fogBlue = (float)fogColor.z();
            }
            ClientHooks.onFogRender((FogRenderer.FogMode)FogRenderer.FogMode.FOG_TERRAIN, (FogType)FogType.NONE, (Camera)pCamera, (float)pPartialTicks, (float)Minecraft.getInstance().options.getEffectiveRenderDistance(), (float)-8.0f, (float)96.0f, (FogShape)FogShape.CYLINDER);
            RenderSystem.clearColor((float)fogRed, (float)fogGreen, (float)fogBlue, (float)0.0f);
        }
        if (player_dim == Level.OVERWORLD) {
            playerEyeLevel = (float)Minecraft.getInstance().player.getEyePosition((float)3.0f).y;
            level = Minecraft.getInstance().level;
            if (playerEyeLevel > 450.0f) {
                info.cancel();
                Camera cam = Minecraft.getInstance().gameRenderer.getMainCamera();
                float f4 = 0.25f + 0.75f * pFarPlaneDistance / 32.0f;
                f4 = 1.0f - (float)Math.pow(f4, 0.25);
                Vec3 vec3 = level.getSkyColor(cam.getPosition(), pPartialTicks);
                float f6 = (float)vec3.x;
                f8 = (float)vec3.y;
                f10 = (float)vec3.z;
                f11 = Mth.clamp((float)(Mth.cos((float)(level.getTimeOfDay(pPartialTicks) * ((float)Math.PI * 2))) * 2.0f + 0.5f), (float)0.0f, (float)1.0f);
                BiomeManager biomemanager = level.getBiomeManager();
                vec31 = cam.getPosition().subtract(2.0, 2.0, 2.0).scale(0.25);
                vec32 = CubicSampler.gaussianSampleVec3((Vec3)vec31, (p_109033_, p_109034_, p_109035_) -> level.effects().getBrightnessDependentFogColor(Vec3.fromRGB24((int)((Biome)biomemanager.getNoiseBiomeAtQuart(p_109033_, p_109034_, p_109035_).value()).getFogColor()), f11));
                fogRed = (float)vec32.x();
                fogGreen = (float)vec32.y();
                fogBlue = (float)vec32.z();
                if (pFarPlaneDistance >= 4.0f) {
                    float[] afloat;
                    float f12 = Mth.sin((float)level.getSunAngle(pPartialTicks)) > 0.0f ? -1.0f : 1.0f;
                    vector3f = new Vector3f(f12, 0.0f, 0.0f);
                    float f16 = cam.getLookVector().dot((Vector3fc)vector3f);
                    if (f16 < 0.0f) {
                        f16 = 0.0f;
                    }
                    if (f16 > 0.0f && (afloat = level.effects().getSunriseColor(level.getTimeOfDay(pPartialTicks), pPartialTicks)) != null) {
                        fogRed = fogRed * (1.0f - (f16 *= afloat[3])) + afloat[0] * f16;
                        fogGreen = fogGreen * (1.0f - f16) + afloat[1] * f16;
                        fogBlue = fogBlue * (1.0f - f16) + afloat[2] * f16;
                    }
                }
                fogRed += (f6 - fogRed) * f4;
                fogGreen += (f8 - fogGreen) * f4;
                fogBlue += (f10 - fogBlue) * f4;
                Vec3 fogColor = Minecraft.getInstance().level.getSkyColor(Minecraft.getInstance().gameRenderer.getMainCamera().getPosition(), 3.0f);
                fogRed = (float)fogColor.x();
                fogGreen = (float)fogColor.y();
                fogBlue = (float)fogColor.z();
                RenderSystem.setShaderFogStart((float)-8.0f);
                RenderSystem.setShaderFogShape((FogShape)FogShape.CYLINDER);
                ClientHooks.onFogRender((FogRenderer.FogMode)FogRenderer.FogMode.FOG_TERRAIN, (FogType)FogType.NONE, (Camera)pCamera, (float)pPartialTicks, (float)Minecraft.getInstance().options.getEffectiveRenderDistance(), (float)-8.0f, (float)96.0f, (FogShape)FogShape.CYLINDER);
                RenderSystem.clearColor((float)fogRed, (float)fogGreen, (float)fogBlue, (float)0.0f);
            }
        }
        if (player_dim == NorthstarDimensions.VENUS_DIM_KEY) {
            playerEyeLevel = (float)Minecraft.getInstance().player.getEyePosition((float)3.0f).y;
            level = Minecraft.getInstance().level;
            if (playerEyeLevel > 600.0f) {
                info.cancel();
            }
            Camera cam = Minecraft.getInstance().gameRenderer.getMainCamera();
            float f4 = 0.25f + 0.75f * pFarPlaneDistance / 32.0f;
            f4 = 1.0f - (float)Math.pow(f4, 0.25);
            Vec3 vec3 = level.getSkyColor(cam.getPosition(), pPartialTicks);
            float f6 = (float)vec3.x;
            f8 = (float)vec3.y;
            f10 = (float)vec3.z;
            f11 = Mth.clamp((float)(Mth.cos((float)(level.getTimeOfDay(pPartialTicks) * ((float)Math.PI * 2))) * 2.0f + 0.5f), (float)0.0f, (float)1.0f);
            BiomeManager biomemanager = level.getBiomeManager();
            vec31 = cam.getPosition().subtract(2.0, 2.0, 2.0).scale(0.25);
            vec32 = CubicSampler.gaussianSampleVec3((Vec3)vec31, (p_109033_, p_109034_, p_109035_) -> level.effects().getBrightnessDependentFogColor(Vec3.fromRGB24((int)((Biome)biomemanager.getNoiseBiomeAtQuart(p_109033_, p_109034_, p_109035_).value()).getFogColor()), f11));
            fogRed = (float)vec32.x();
            fogGreen = (float)vec32.y();
            fogBlue = (float)vec32.z();
            if (pFarPlaneDistance >= 4.0f) {
                float[] afloat;
                float f12 = Mth.sin((float)level.getSunAngle(pPartialTicks)) > 0.0f ? -1.0f : 1.0f;
                vector3f = new Vector3f(f12, 0.0f, 0.0f);
                float f16 = cam.getLookVector().dot((Vector3fc)vector3f);
                if (f16 < 0.0f) {
                    f16 = 0.0f;
                }
                if (f16 > 0.0f && (afloat = level.effects().getSunriseColor(level.getTimeOfDay(pPartialTicks), pPartialTicks)) != null) {
                    fogRed = fogRed * (1.0f - (f16 *= afloat[3])) + afloat[0] * f16;
                    fogGreen = fogGreen * (1.0f - f16) + afloat[1] * f16;
                    fogBlue = fogBlue * (1.0f - f16) + afloat[2] * f16;
                }
            }
            fogRed += (f6 - fogRed) * f4;
            fogGreen += (f8 - fogGreen) * f4;
            fogBlue += (f10 - fogBlue) * f4;
            Vec3 fogColor = Minecraft.getInstance().level.getSkyColor(Minecraft.getInstance().gameRenderer.getMainCamera().getPosition(), 3.0f);
            fogRed = (float)fogColor.x();
            fogGreen = (float)fogColor.y();
            fogBlue = (float)fogColor.z();
            ClientHooks.onFogRender((FogRenderer.FogMode)FogRenderer.FogMode.FOG_TERRAIN, (FogType)FogType.NONE, (Camera)pCamera, (float)pPartialTicks, (float)Minecraft.getInstance().options.getEffectiveRenderDistance(), (float)-8.0f, (float)96.0f, (FogShape)FogShape.CYLINDER);
            if (fogtype == FogType.NONE && fluidInCam == Fluids.EMPTY) {
                RenderSystem.setShaderFogStart((float)-8.0f);
                if ((double)pFarPlaneDistance * 1.2 > 300.0) {
                    RenderSystem.setShaderFogEnd((float)300.0f);
                } else {
                    RenderSystem.setShaderFogEnd((float)(pFarPlaneDistance * 1.2f));
                }
                info.cancel();
            }
            RenderSystem.clearColor((float)fogRed, (float)fogGreen, (float)fogBlue, (float)0.0f);
        }
    }

    @Inject(method={"levelFogColor()V"}, at={@At(value="HEAD")}, cancellable=true)
    private static void levelFogColor(CallbackInfo info) {
        boolean isSubmerged;
        Minecraft minecraft = Minecraft.getInstance();
        boolean bl = isSubmerged = !minecraft.gameRenderer.getMainCamera().getBlockAtCamera().getFluidState().isEmpty();
        if (!isSubmerged) {
            ResourceKey dimension = minecraft.level.dimension();
            RenderSystem.setShaderFogColor((float)fogRed, (float)fogGreen, (float)fogBlue);
            if (dimension == NorthstarDimensions.MOON_DIM_KEY || dimension == NorthstarDimensions.MERCURY_DIM_KEY || dimension == NorthstarDimensions.EARTH_ORBIT_DIM_KEY) {
                RenderSystem.setShaderFogColor((float)0.0f, (float)0.0f, (float)0.0f);
                info.cancel();
            }
        }
    }

    static {
        p = 1.0f;
    }
}

