/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.mixin.compat.tfmg;

import com.drmangotea.tfmg.content.machinery.misc.air_intake.AirIntakeBlockEntity;
import com.drmangotea.tfmg.registry.TFMGFluids;
import com.lightning.northstar.accessor.NorthstarOxygenConsumingBlockEntity;
import com.lightning.northstar.api.WhenModLoaded;
import com.lightning.northstar.data.ModCompat;
import com.lightning.northstar.world.oxygen.NorthstarOxygen;
import com.lightning.northstar.world.temperature.NorthstarTemperature;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.tterrag.registrate.util.entry.FluidEntry;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;

@WhenModLoaded(value={ModCompat.TFMG})
@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
@Mixin(value={AirIntakeBlockEntity.class})
public class AirIntakeBlockEntityMixin
extends KineticBlockEntity
implements NorthstarOxygenConsumingBlockEntity {
    @Unique
    private int northstar$lastConsumed;

    public AirIntakeBlockEntityMixin(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @ModifyVariable(method={"tick()V"}, at=@At(value="STORE"), ordinal=0, remap=false)
    private int northstar$addOxygenRequirement(int production) {
        NorthstarOxygen oxygen = this.level.northstar$oxygen();
        this.northstar$lastConsumed = 0;
        if (oxygen.hasOxygen()) {
            return production;
        }
        NorthstarOxygen.Provider sealer = oxygen.getSealer((Vec3i)this.worldPosition);
        if (sealer == null) {
            return 0;
        }
        this.northstar$lastConsumed = production;
        sealer.drainOxygen(production);
        return production;
    }

    @Redirect(method={"tick()V"}, at=@At(value="INVOKE", target="Lcom/tterrag/registrate/util/entry/FluidEntry;get()Ljava/lang/Object;", remap=false), remap=false)
    private Object northstar$convertToHotAir(FluidEntry<?> instance) {
        return NorthstarTemperature.getTemperatureAt(this.level, (Vec3i)this.worldPosition) >= 1000.0f ? TFMGFluids.HOT_AIR.getSource() : TFMGFluids.AIR.getSource();
    }

    @Override
    public float northstar$getOxygenUsage() {
        return this.northstar$lastConsumed;
    }
}

