/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.mixin.block;

import com.lightning.northstar.block.simple.ExtinguishedLanternBlock;
import com.lightning.northstar.content.NorthstarBlocks;
import com.lightning.northstar.world.oxygen.NorthstarOxygen;
import com.lightning.northstar.world.sealer.SealReactiveBlock;
import com.lightning.northstar.world.sealer.SealingMode;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.sugar.Local;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
@Mixin(value={LanternBlock.class})
public class LanternBlockMixin
extends Block
implements SealReactiveBlock {
    @Shadow
    @Final
    public static BooleanProperty HANGING;
    @Shadow
    @Final
    public static BooleanProperty WATERLOGGED;

    public LanternBlockMixin(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @ModifyReturnValue(method={"getStateForPlacement(Lnet/minecraft/world/item/context/BlockPlaceContext;)Lnet/minecraft/world/level/block/state/BlockState;"}, at={@At(value="RETURN")})
    @Nullable
    public BlockState northstar$updatePlacementLit(@Nullable BlockState state, @Local(argsOnly=true) BlockPlaceContext context) {
        if (state != null && state.getBlock() == Blocks.LANTERN && !NorthstarOxygen.hasOxygen(context.getLevel(), (Vec3i)context.getClickedPos())) {
            return this.northstar$copyStateExtinguished(state);
        }
        return state;
    }

    @ModifyReturnValue(method={"updateShape(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/core/Direction;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/LevelAccessor;Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/block/state/BlockState;"}, at={@At(value="RETURN")})
    public BlockState northstar$updateShape(BlockState state, @Local(argsOnly=true) LevelAccessor level, @Local(argsOnly=true, ordinal=0) BlockPos pos) {
        Level l;
        if (state.getBlock() == Blocks.LANTERN && level instanceof Level && !NorthstarOxygen.hasOxygen(l = (Level)level, (Vec3i)pos)) {
            level.playSound(null, pos, SoundEvents.CANDLE_EXTINGUISH, SoundSource.BLOCKS, 1.0f, 1.0f);
            return this.northstar$copyStateExtinguished(state);
        }
        return state;
    }

    @Override
    public void northstar$onSealUpdated(Level level, BlockPos pos, BlockState state, SealingMode mode) {
        if (mode == SealingMode.OXYGEN && state.getBlock() == Blocks.LANTERN && !NorthstarOxygen.hasOxygen(level, (Vec3i)pos)) {
            level.setBlock(pos, this.northstar$copyStateExtinguished(state), 3);
        }
    }

    @Unique
    private BlockState northstar$copyStateExtinguished(BlockState state) {
        return (BlockState)((BlockState)((ExtinguishedLanternBlock)((Object)NorthstarBlocks.EXTINGUISHED_LANTERN.get())).defaultBlockState().setValue((Property)ExtinguishedLanternBlock.HANGING, (Comparable)((Boolean)state.getValue((Property)HANGING)))).setValue((Property)ExtinguishedLanternBlock.WATERLOGGED, (Comparable)((Boolean)state.getValue((Property)WATERLOGGED)));
    }
}

