/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.mixin.block;

import com.lightning.northstar.world.oxygen.NorthstarOxygen;
import com.lightning.northstar.world.sealer.SealReactiveBlock;
import com.lightning.northstar.world.sealer.SealingMode;
import com.lightning.northstar.world.temperature.NorthstarTemperature;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.sugar.Local;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
@Mixin(value={FireBlock.class})
public class FireBlockMixin
implements SealReactiveBlock {
    @ModifyReturnValue(method={"canSurvive(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/LevelReader;Lnet/minecraft/core/BlockPos;)Z"}, at={@At(value="RETURN")})
    public boolean northstar$canSurvive(boolean value, @Local(argsOnly=true) LevelReader level, @Local(argsOnly=true) BlockPos pos) {
        Level l;
        if (value && level instanceof Level && (NorthstarTemperature.getTemperatureAt(l = (Level)level, (Vec3i)pos) < -100.0f || !NorthstarOxygen.hasOxygen(l, (Vec3i)pos))) {
            return false;
        }
        return value;
    }

    @Override
    public void northstar$onSealUpdated(Level level, BlockPos pos, BlockState state, SealingMode mode) {
        if (mode == SealingMode.OXYGEN && !NorthstarOxygen.hasOxygen(level, (Vec3i)pos)) {
            level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
            return;
        }
        if (mode == SealingMode.TEMPERATURE && NorthstarTemperature.getTemperatureAt(level, (Vec3i)pos) < -100.0f) {
            level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
        }
    }
}

