/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.mixin;

import com.lightning.northstar.api.WhenModLoaded;
import com.lightning.northstar.data.ModCompat;
import com.llamalad7.mixinextras.MixinExtrasBootstrap;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.FMLLoader;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.service.MixinService;
import org.spongepowered.asm.util.Annotations;

public class NorthstarMixinPlugin
implements IMixinConfigPlugin {
    public static final Logger LOGGER = LoggerFactory.getLogger(NorthstarMixinPlugin.class);

    public void onLoad(String mixinPackage) {
        MixinExtrasBootstrap.init();
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        try {
            List annotationNodes = MixinService.getService().getBytecodeProvider().getClassNode((String)mixinClassName).visibleAnnotations;
            if (annotationNodes == null) {
                return true;
            }
            for (AnnotationNode node : annotationNodes) {
                if (!node.desc.equals(Type.getDescriptor(WhenModLoaded.class))) continue;
                List mods = Annotations.getValue((AnnotationNode)node, (String)"value", (boolean)false, ModCompat.class);
                for (ModCompat mod : mods) {
                    ModList modlist = ModList.get();
                    boolean loaded = modlist == null ? FMLLoader.getLoadingModList().getMods().stream().anyMatch(m -> m.getModId().equals(mod.modId)) : modlist.isLoaded(mod.modId);
                    if (!loaded) continue;
                    return true;
                }
                return mods.isEmpty();
            }
        }
        catch (IOException | ClassNotFoundException exception) {
            LOGGER.error("", (Throwable)exception);
        }
        return true;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

