/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.entity.goals;

import com.lightning.northstar.Northstar;
import com.lightning.northstar.content.NorthstarSounds;
import com.lightning.northstar.entity.VenusStoneBullEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.phys.Vec3;

public class ChargeAtTargetGoal
extends MoveToBlockGoal {
    private final VenusStoneBullEntity chargingMob;
    private int ticksSinceReachedGoal;

    public ChargeAtTargetGoal(VenusStoneBullEntity mob, double pSpeedModifier, int pSearchRange) {
        super((PathfinderMob)mob, pSpeedModifier, 24, pSearchRange);
        this.chargingMob = mob;
    }

    public double acceptedDistance() {
        return 0.5;
    }

    public boolean canUse() {
        if (this.chargingMob.chargeCooldown > 0) {
            return false;
        }
        if (this.chargingMob.chargeTimer > 0) {
            return true;
        }
        if (this.searchForTarget()) {
            this.nextStartTick = ChargeAtTargetGoal.reducedTickDelay((int)20);
            this.chargingMob.charging = true;
            this.chargingMob.level().broadcastEntityEvent((Entity)this.chargingMob, (byte)-2);
            return true;
        }
        this.nextStartTick = this.nextStartTick(this.mob);
        this.chargingMob.moveDirection = null;
        this.chargingMob.charging = false;
        this.chargingMob.level().broadcastEntityEvent((Entity)this.chargingMob, (byte)-3);
        return false;
    }

    private boolean searchForTarget() {
        if (this.chargingMob.getTarget() == null) {
            return false;
        }
        BlockPos targetPos = this.chargingMob.getTarget().blockPosition();
        BlockPos subPos = targetPos.subtract((Vec3i)this.chargingMob.blockPosition());
        double newX = subPos.getX();
        double newZ = subPos.getZ();
        targetPos = this.chargingMob.blockPosition();
        if (this.chargingMob.moveDirection == null || this.chargingMob.moveDirection == Vec3.ZERO) {
            this.chargingMob.moveDirection = new Vec3(newX, 0.0, newZ);
            this.chargingMob.ticksSpentCharging = 0;
            this.chargingMob.playSound((SoundEvent)NorthstarSounds.VENUS_STONE_BULL_CHARGE.get(), 1.0f, 1.0f);
            this.chargingMob.chargeTimer = 150;
            this.chargingMob.targetPos = this.chargingMob.getTarget().blockPosition();
        }
        return true;
    }

    public void stop() {
        super.stop();
    }

    public void start() {
        super.start();
        this.ticksSinceReachedGoal = 0;
    }

    public void playDestroyProgressSound(LevelAccessor pLevel, BlockPos pPos) {
    }

    public void playBreakSound(Level pLevel, BlockPos pPos) {
    }

    public void tick() {
        if (this.chargingMob.ticksSpentCharging > 60) {
            this.chargingMob.moveDirection = Vec3.ZERO;
            this.chargingMob.targetPos = null;
            this.chargingMob.chargeTimer = 0;
            this.chargingMob.stopChargeTimer = 0;
            this.chargingMob.charging = false;
            this.chargingMob.level().broadcastEntityEvent((Entity)this.chargingMob, (byte)-5);
            this.chargingMob.passedTarget = false;
            this.chargingMob.chargeCooldown = 200;
            this.chargingMob.ticksSpentCharging = 0;
            this.stop();
            return;
        }
        this.chargingMob.getNavigation().stop();
        super.tick();
        if (this.chargingMob.chargeTimer != 0) {
            this.stop();
        }
        Northstar.LOGGER.debug("targetPos: {}", (Object)this.chargingMob.targetPos);
        Northstar.LOGGER.debug("blockPos: {}", (Object)this.chargingMob.blockPosition());
        Northstar.LOGGER.debug("moveDirection: {}", (Object)this.chargingMob.moveDirection);
        Northstar.LOGGER.debug("target: {}", (Object)this.chargingMob.getTarget());
        if (this.chargingMob.targetPos != null && this.chargingMob.blockPosition() != null && this.chargingMob.moveDirection != null) {
            LivingEntity livingentity;
            Vec3 targetVec = this.blockPosToVec3(this.chargingMob.targetPos);
            Vec3 chargerVec = this.blockPosToVec3(this.chargingMob.blockPosition());
            Vec3 subVec = targetVec.subtract(chargerVec);
            Northstar.LOGGER.debug("SUBVEC: {}", (Object)subVec);
            for (Entity colliders : this.chargingMob.level().getEntities((Entity)this.chargingMob, this.chargingMob.getBoundingBox())) {
                if (!(colliders instanceof LivingEntity)) continue;
                LivingEntity lc = (LivingEntity)colliders;
                Vec3 vec = lc.getDeltaMovement();
                lc.hurt(lc.level().damageSources().cramming(), 5.0f);
                this.chargingMob.playSound((SoundEvent)NorthstarSounds.VENUS_STONE_BULL_ATTACK.get(), 1.0f, 1.0f);
                if (this.chargingMob.moveDirection == null) continue;
                lc.setDeltaMovement(vec.x + this.chargingMob.moveDirection.x / 50.0, vec.y + 0.3, vec.z + this.chargingMob.moveDirection.z / 50.0);
            }
            boolean xFlag = false;
            boolean zFlag = false;
            if (this.chargingMob.moveDirection.x > 0.0) {
                boolean bl = xFlag = subVec.x < 0.0;
            }
            if (this.chargingMob.moveDirection.x < 0.0) {
                boolean bl = xFlag = subVec.x > 0.0;
            }
            if (this.chargingMob.moveDirection.z > 0.0) {
                boolean bl = zFlag = subVec.z < 0.0;
            }
            if (this.chargingMob.moveDirection.z < 0.0) {
                boolean bl = zFlag = subVec.z > 0.0;
            }
            if (xFlag && zFlag && !this.chargingMob.passedTarget && !this.chargingMob.passedTarget) {
                this.chargingMob.passedTarget = true;
                this.chargingMob.level().broadcastEntityEvent((Entity)this.chargingMob, (byte)-4);
            }
            if (this.blockPosToVec3(this.chargingMob.blockPosition()).distanceTo(this.blockPosToVec3(this.chargingMob.targetPos)) > 15.0) {
                this.stop();
                this.chargingMob.moveDirection = Vec3.ZERO;
                this.chargingMob.targetPos = null;
                this.chargingMob.chargeTimer = 0;
                this.chargingMob.stopChargeTimer = 0;
                this.chargingMob.charging = false;
                this.chargingMob.passedTarget = false;
                this.chargingMob.level().broadcastEntityEvent((Entity)this.chargingMob, (byte)-5);
                this.chargingMob.chargeCooldown = 200;
                this.chargingMob.ticksSpentCharging = 0;
                this.stop();
                return;
            }
            if (!this.chargingMob.passedTarget && this.chargingMob.getTarget() != null && (livingentity = this.chargingMob.getTarget()).distanceToSqr((Entity)this.chargingMob) < 4096.0) {
                double d1 = livingentity.getX() - this.chargingMob.getX();
                double d2 = livingentity.getZ() - this.chargingMob.getZ();
                this.chargingMob.setYRot(-((float)Mth.atan2((double)d1, (double)d2)) * 57.295776f);
                this.chargingMob.yBodyRot = this.chargingMob.getYRot();
            }
            Vec3 vec = this.chargingMob.getDeltaMovement();
            vec = vec.add(this.chargingMob.moveDirection.x, 0.0, this.chargingMob.moveDirection.z);
            this.chargingMob.yBodyRot = this.chargingMob.getYRot();
            ++this.chargingMob.ticksSpentCharging;
            Vec3 delta = this.chargingMob.getDeltaMovement();
            if (!this.chargingMob.passedTarget) {
                this.chargingMob.setDeltaMovement(delta.x + this.chargingMob.moveDirection.x / 50.0, delta.y + this.chargingMob.moveDirection.y / 50.0, delta.z + this.chargingMob.moveDirection.z / 50.0);
            } else {
                this.chargingMob.setDeltaMovement(delta.x + this.chargingMob.moveDirection.x / 50.0 * 0.7, delta.y + this.chargingMob.moveDirection.y / 50.0 * 0.7, delta.z + this.chargingMob.moveDirection.z / 50.0 * 0.7);
                ++this.ticksSinceReachedGoal;
            }
        }
    }

    public Vec3 blockPosToVec3(BlockPos pos) {
        return new Vec3((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
    }

    public boolean canContinueToUse() {
        return this.chargingMob.moveDirection != null && this.chargingMob.targetPos != null;
    }

    protected void moveMobToBlock() {
    }

    protected boolean isValidTarget(LevelReader pLevel, BlockPos pPos) {
        ChunkAccess chunkaccess = pLevel.getChunk(SectionPos.blockToSectionCoord((int)pPos.getX()), SectionPos.blockToSectionCoord((int)pPos.getZ()), ChunkStatus.FULL, false);
        return chunkaccess != null;
    }
}

