/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.data.util;

import com.lightning.northstar.Northstar;
import com.lightning.northstar.block.simple.GrateBlock;
import com.lightning.northstar.block.simple.VerticalSlabBlock;
import com.lightning.northstar.content.NorthstarItems;
import com.lightning.northstar.data.Tags;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import com.simibubi.create.content.processing.recipe.StandardProcessingRecipe;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateRecipeProvider;
import com.tterrag.registrate.util.DataIngredient;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.entry.ItemEntry;
import com.tterrag.registrate.util.nullness.NonNullBiConsumer;
import java.util.function.Supplier;
import net.createmod.catnip.registry.RegisteredObjectsHelper;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;

public class NorthstarDataGenRecipes {
    public static NonNullBiConsumer<DataGenContext<Block, Block>, RegistrateRecipeProvider> plank(Tags.Tag<Item> log) {
        return NorthstarDataGenRecipes.plank(log.tag());
    }

    public static NonNullBiConsumer<DataGenContext<Block, Block>, RegistrateRecipeProvider> plank(TagKey<Item> log) {
        return (c, p) -> RegistrateRecipeProvider.planksFromLog((RecipeOutput)p, (ItemLike)((ItemLike)c.get()), (TagKey)log, (int)4);
    }

    public static NonNullBiConsumer<DataGenContext<Block, SlabBlock>, RegistrateRecipeProvider> slab(BlockEntry<Block> source) {
        return (c, p) -> {
            RegistrateRecipeProvider.slab((RecipeOutput)p, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, () -> ((SlabBlock)c.get()).asItem(), () -> ((Block)source.get()).asItem());
            p.stonecutting(DataIngredient.items((ItemLike)((Block)source.get()), (ItemLike[])new Block[0]), RecipeCategory.BUILDING_BLOCKS, (Supplier)c, 2);
        };
    }

    public static NonNullBiConsumer<DataGenContext<Block, VerticalSlabBlock>, RegistrateRecipeProvider> verticalSlab(BlockEntry<Block> source) {
        return (c, p) -> {
            Item material = ((Block)source.get()).asItem();
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)c.get()), (int)6).define(Character.valueOf('#'), (ItemLike)material).pattern("#").pattern("#").pattern("#").unlockedBy(RegistrateRecipeProvider.getHasName((ItemLike)material), RegistrateRecipeProvider.has((ItemLike)material)).save((RecipeOutput)p);
            p.stonecutting(DataIngredient.items((ItemLike)((Block)source.get()), (ItemLike[])new Block[0]), RecipeCategory.BUILDING_BLOCKS, (Supplier)c, 2);
        };
    }

    public static NonNullBiConsumer<DataGenContext<Block, StairBlock>, RegistrateRecipeProvider> stair(BlockEntry<Block> source) {
        return (c, p) -> {
            Item material = ((Block)source.get()).asItem();
            RegistrateRecipeProvider.stairBuilder(() -> ((StairBlock)c.get()).asItem(), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{material})).unlockedBy(RegistrateRecipeProvider.getHasName((ItemLike)material), RegistrateRecipeProvider.has((ItemLike)material)).save((RecipeOutput)p);
            p.stonecutting(DataIngredient.items((ItemLike)((Block)source.get()), (ItemLike[])new Block[0]), RecipeCategory.BUILDING_BLOCKS, (Supplier)c, 1);
        };
    }

    public static NonNullBiConsumer<DataGenContext<Block, WallBlock>, RegistrateRecipeProvider> wall(BlockEntry<Block> source) {
        return (c, p) -> {
            RegistrateRecipeProvider.wall((RecipeOutput)p, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, () -> ((WallBlock)c.get()).asItem(), () -> ((Block)source.get()).asItem());
            p.stonecutting(DataIngredient.items((ItemLike)((Block)source.get()), (ItemLike[])new Block[0]), RecipeCategory.BUILDING_BLOCKS, (Supplier)c, 1);
        };
    }

    public static NonNullBiConsumer<DataGenContext<Block, Block>, RegistrateRecipeProvider> sheetmetal(Tags.Tag<Item> sheet) {
        return NorthstarDataGenRecipes.sheetmetal(sheet.tag());
    }

    public static NonNullBiConsumer<DataGenContext<Block, Block>, RegistrateRecipeProvider> sheetmetal(TagKey<Item> sheet) {
        return NorthstarDataGenRecipes.commonFourToFour(sheet);
    }

    public static NonNullBiConsumer<DataGenContext<Block, Block>, RegistrateRecipeProvider> plating(Tags.Tag<Item> ingot) {
        return NorthstarDataGenRecipes.plating(ingot.tag());
    }

    public static NonNullBiConsumer<DataGenContext<Block, Block>, RegistrateRecipeProvider> plating(TagKey<Item> sheet) {
        return NorthstarDataGenRecipes.commonFourToFour(sheet);
    }

    public static <B extends Block> NonNullBiConsumer<DataGenContext<Block, B>, RegistrateRecipeProvider> commonFourToFour(TagKey<Item> tag) {
        return (c, p) -> {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)c.get()), (int)4).unlockedBy("has_item", RegistrateRecipeProvider.has((TagKey)tag)).define(Character.valueOf('#'), tag).pattern("##").pattern("##").save((RecipeOutput)p);
            p.stonecutting(DataIngredient.tag((TagKey)tag), RecipeCategory.BUILDING_BLOCKS, (Supplier)c, 1);
        };
    }

    public static NonNullBiConsumer<DataGenContext<Block, RotatedPillarBlock>, RegistrateRecipeProvider> pillar(Tags.Tag<Item> material) {
        return NorthstarDataGenRecipes.pillar(material.tag());
    }

    public static NonNullBiConsumer<DataGenContext<Block, RotatedPillarBlock>, RegistrateRecipeProvider> pillar(TagKey<Item> material) {
        return (c, p) -> {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)c.get()), (int)2).unlockedBy("has_item", RegistrateRecipeProvider.has((TagKey)material)).define(Character.valueOf('#'), material).pattern("#").pattern("#").save((RecipeOutput)p);
            p.stonecutting(DataIngredient.tag((TagKey)material), RecipeCategory.BUILDING_BLOCKS, (Supplier)c, 1);
        };
    }

    public static NonNullBiConsumer<DataGenContext<Block, RotatedPillarBlock>, RegistrateRecipeProvider> pillar(ItemLike material) {
        return (c, p) -> {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)c.get()), (int)2).unlockedBy("has_item", RegistrateRecipeProvider.has((ItemLike)material)).define(Character.valueOf('#'), material).pattern("#").pattern("#").save((RecipeOutput)p);
            p.stonecutting(DataIngredient.items((ItemLike)material, (ItemLike[])new ItemLike[0]), RecipeCategory.BUILDING_BLOCKS, (Supplier)c, 1);
        };
    }

    public static NonNullBiConsumer<DataGenContext<Block, Block>, RegistrateRecipeProvider> chiseled(ItemLike slab) {
        return (c, p) -> ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)c.get()), (int)1).unlockedBy("has_item", RegistrateRecipeProvider.has((ItemLike)slab)).define(Character.valueOf('#'), slab).pattern("#").pattern("#").save((RecipeOutput)p);
    }

    public static NonNullBiConsumer<DataGenContext<Block, GrateBlock>, RegistrateRecipeProvider> grate(Tags.Tag<Item> material) {
        return (c, p) -> ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)c.get()), (int)4).unlockedBy("has_item", RegistrateRecipeProvider.has(material.tag())).define(Character.valueOf('#'), material.tag()).pattern("###").pattern("# #").pattern("###").save((RecipeOutput)p);
    }

    public static <T extends Block> NonNullBiConsumer<DataGenContext<Block, T>, RegistrateRecipeProvider> ore(ItemLike stone, OreType type) {
        return (c, p) -> {
            String oreName = RegisteredObjectsHelper.getKeyOrThrow((Item)((Block)c.get()).asItem()).getPath();
            if (type.crushedItem != null) {
                ProcessingRecipeBuilder builder = ((StandardProcessingRecipe.Builder)((StandardProcessingRecipe.Builder)new StandardProcessingRecipe.Builder(((StandardProcessingRecipe.Serializer)AllRecipeTypes.CRUSHING.getSerializer()).factory(), Northstar.asResource(oreName)).require((ItemLike)c.get())).duration(type.crushingDuration)).output(type.crushedItem.get(), Mth.floor((float)type.expectedAmount));
                float extra = type.expectedAmount - (float)Mth.floor((float)type.expectedAmount);
                if (extra > 0.0f) {
                    builder.output(extra, type.crushedItem.get(), 1);
                }
                builder.output(0.75f, (ItemLike)AllItems.EXP_NUGGET.get(), type.crushedItem.get() == AllItems.CRUSHED_GOLD.get() ? 2 : 1).output(0.125f, stone).build((RecipeOutput)p);
            }
            if (type.smeltedItem != null) {
                SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)c.get()}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)type.smeltedItem.get(), (float)type.smeltingXp, (int)type.smeltingDuration).unlockedBy("has_item", RegistrateRecipeProvider.has((ItemLike)((ItemLike)c.get()))).save((RecipeOutput)p, Northstar.asResource("smelting/" + oreName));
                SimpleCookingRecipeBuilder.blasting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)c.get()}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)type.smeltedItem.get(), (float)type.smeltingXp, (int)(type.smeltingDuration / 2)).unlockedBy("has_item", RegistrateRecipeProvider.has((ItemLike)((ItemLike)c.get()))).save((RecipeOutput)p, Northstar.asResource("blasting/" + oreName));
            }
        };
    }

    public record OreType(Supplier<ItemLike> crushedItem, float expectedAmount, int crushingDuration, Supplier<ItemLike> smeltedItem, float smeltingXp, int smeltingDuration) {
        public static final OreType COAL = new OreType(() -> Items.COAL, 1.75f, 150, () -> Items.COAL, 0.1f, 200);
        public static final OreType COPPER = new OreType(() -> ((ItemEntry)AllItems.CRUSHED_COPPER).get(), 5.25f, 250, () -> Items.COPPER_INGOT, 0.7f, 200);
        public static final OreType DIAMOND = new OreType(() -> Items.DIAMOND, 1.75f, 350, () -> Items.DIAMOND, 1.0f, 200);
        public static final OreType EMERALD = new OreType(() -> Items.EMERALD, 1.75f, 350, () -> Items.EMERALD, 1.0f, 200);
        public static final OreType GLOWSTONE = new OreType(() -> NorthstarItems.RAW_GLOWSTONE_ORE.get(), 1.75f, 250, () -> Items.GLOWSTONE_DUST, 1.0f, 200);
        public static final OreType GOLD = new OreType(() -> ((ItemEntry)AllItems.CRUSHED_GOLD).get(), 1.75f, 250, () -> Items.GOLD_INGOT, 1.0f, 200);
        public static final OreType IRON = new OreType(() -> ((ItemEntry)AllItems.CRUSHED_IRON).get(), 1.75f, 250, () -> Items.IRON_INGOT, 0.7f, 200);
        public static final OreType LAPIS = new OreType(() -> Items.LAPIS_LAZULI, 10.5f, 250, () -> Items.LAPIS_LAZULI, 0.2f, 200);
        public static final OreType MARTIAN_IRON = new OreType(() -> NorthstarItems.RAW_MARTIAN_IRON_ORE.get(), 1.75f, 250, () -> Items.IRON_INGOT, 0.7f, 200);
        public static final OreType QUARTZ = new OreType(() -> Items.QUARTZ, 2.25f, 350, () -> Items.QUARTZ, 0.2f, 200);
        public static final OreType REDSTONE = new OreType(() -> Items.REDSTONE, 6.5f, 250, () -> Items.REDSTONE, 0.7f, 200);
        public static final OreType TITANIUM = new OreType(() -> NorthstarItems.RAW_TITANIUM_ORE.get(), 1.75f, 350, () -> NorthstarItems.TITANIUM_INGOT.get(), 1.0f, 200);
        public static final OreType TUNGSTEN = new OreType(() -> NorthstarItems.CRUSHED_RAW_TUNGSTEN.get(), 1.75f, 450, () -> NorthstarItems.TUNGSTEN_INGOT.get(), 1.0f, 200);
        public static final OreType ZINC = new OreType(() -> Items.IRON_INGOT, 1.75f, 250);
        public static final OreType DEEP_COAL = COAL.with(2.25f, 300);
        public static final OreType DEEP_COPPER = COPPER.with(7.25f, 350);
        public static final OreType DEEP_DIAMOND = DIAMOND.with(2.25f, 450);
        public static final OreType DEEP_EMERALD = EMERALD.with(2.25f, 450);
        public static final OreType DEEP_GLOWSTONE = GLOWSTONE.with(2.25f, 350);
        public static final OreType DEEP_GOLD = GOLD.with(2.25f, 350);
        public static final OreType DEEP_IRON = IRON.with(2.25f, 350);
        public static final OreType DEEP_LAPIS = LAPIS.with(12.5f, 350);
        public static final OreType DEEP_MARTIAN_IRON = MARTIAN_IRON.with(2.25f, 350);
        public static final OreType DEEP_QUARTZ = QUARTZ.with(2.75f, 350);
        public static final OreType DEEP_REDSTONE = REDSTONE.with(7.5f, 350);
        public static final OreType DEEP_TITANIUM = TITANIUM.with(2.25f, 450);
        public static final OreType DEEP_TUNGSTEN = TUNGSTEN.with(2.25f, 550);
        public static final OreType DEEP_ZINC = ZINC.with(2.25f, 350);

        public OreType(Supplier<ItemLike> crushedItem, float expectedAmount, int crushingDuration) {
            this(crushedItem, expectedAmount, crushingDuration, null, 0.0f, 0);
        }

        public OreType with(float expectedAmount, int crushingDuration) {
            return new OreType(this.crushedItem, expectedAmount, crushingDuration, this.smeltedItem, this.smeltingXp, this.smeltingDuration);
        }
    }
}

