/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.data;

import com.google.gson.JsonElement;
import com.lightning.northstar.Northstar;
import com.lightning.northstar.advancements.NorthstarAdvancements;
import com.lightning.northstar.content.NorthstarDamageTypes;
import com.lightning.northstar.content.NorthstarRegistries;
import com.lightning.northstar.data.NorthstarFuelTypeGen;
import com.lightning.northstar.data.NorthstarPotatoCannonProjectiles;
import com.lightning.northstar.data.NorthstarTagGen;
import com.lightning.northstar.data.NorthstarWashingRecipeGen;
import com.lightning.northstar.data.recipe.NorthstarCompactingRecipeGen;
import com.lightning.northstar.data.recipe.NorthstarCreateAdditionLiquidBurningRecipeGen;
import com.lightning.northstar.data.recipe.NorthstarCrushingRecipeGen;
import com.lightning.northstar.data.recipe.NorthstarElectrolysisRecipeGen;
import com.lightning.northstar.data.recipe.NorthstarEngravingRecipeGen;
import com.lightning.northstar.data.recipe.NorthstarFillingRecipeGen;
import com.lightning.northstar.data.recipe.NorthstarFreezingRecipeGen;
import com.lightning.northstar.data.recipe.NorthstarMechanicalCraftingGen;
import com.lightning.northstar.data.recipe.NorthstarMixingRecipeGen;
import com.lightning.northstar.data.recipe.NorthstarPolishingRecipeGen;
import com.lightning.northstar.data.recipe.NorthstarPressingRecipeGen;
import com.lightning.northstar.data.recipe.NorthstarSequencedAssemblyRecipeGen;
import com.lightning.northstar.data.recipe.NorthstarStandardRecipeGen;
import com.lightning.northstar.item.NorthstarEnchantments;
import com.simibubi.create.api.registry.CreateRegistries;
import com.simibubi.create.foundation.utility.FilesHelper;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.providers.RegistrateLangProvider;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="northstar")
public class NorthstarDataGen {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onGatherDataHighPriority(GatherDataEvent event) {
        if (!event.getMods().contains("northstar")) {
            return;
        }
        NorthstarTagGen.register();
        Northstar.REGISTRATE.addDataGenerator(ProviderType.LANG, provider -> {
            NorthstarDataGen.provideDefaultLang("base", (arg_0, arg_1) -> ((RegistrateLangProvider)provider).add(arg_0, arg_1));
            NorthstarDataGen.provideDefaultLang("tooltips", (arg_0, arg_1) -> ((RegistrateLangProvider)provider).add(arg_0, arg_1));
            NorthstarDataGen.provideDefaultLang("tags", (arg_0, arg_1) -> ((RegistrateLangProvider)provider).add(arg_0, arg_1));
        });
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onGatherData(GatherDataEvent event) {
        if (!event.getMods().contains("northstar")) {
            return;
        }
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        RegistrySetBuilder builder = new RegistrySetBuilder().add(Registries.DAMAGE_TYPE, NorthstarDamageTypes::bootstrap).add(Registries.ENCHANTMENT, NorthstarEnchantments::bootstrap).add(NorthstarRegistries.FUEL, NorthstarFuelTypeGen::bootstrap).add(CreateRegistries.POTATO_PROJECTILE_TYPE, NorthstarPotatoCannonProjectiles::boostrap);
        DatapackBuiltinEntriesProvider provider = new DatapackBuiltinEntriesProvider(output, lookupProvider, builder, Set.of("northstar"));
        generator.addProvider(event.includeServer(), (DataProvider)provider);
        lookupProvider = provider.getRegistryProvider();
        generator.addProvider(event.includeServer(), (DataProvider)new NorthstarAdvancements(output, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new NorthstarTagGen.Damage(output, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new NorthstarCompactingRecipeGen(output, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new NorthstarCreateAdditionLiquidBurningRecipeGen(output, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new NorthstarCrushingRecipeGen(output, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new NorthstarElectrolysisRecipeGen(output, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new NorthstarEngravingRecipeGen(output, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new NorthstarFillingRecipeGen(output, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new NorthstarFreezingRecipeGen(output, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new NorthstarMechanicalCraftingGen(output, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new NorthstarMixingRecipeGen(output, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new NorthstarPolishingRecipeGen(output, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new NorthstarPressingRecipeGen(output, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new NorthstarSequencedAssemblyRecipeGen(output, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new NorthstarStandardRecipeGen(output, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new NorthstarWashingRecipeGen(output, lookupProvider));
    }

    private static void provideDefaultLang(String name, BiConsumer<String, String> consumer) {
        String path = "assets/northstar/lang/default/" + name + ".json";
        JsonElement json = FilesHelper.loadJsonResource((String)path);
        if (json == null) {
            throw new IllegalStateException(String.format("Could not find default lang file: %s", path));
        }
        for (Map.Entry entry : json.getAsJsonObject().entrySet()) {
            consumer.accept((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
        }
    }
}

