/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.contraption;

import com.lightning.northstar.Northstar;
import com.lightning.northstar.content.NorthstarRegistries;
import com.lightning.northstar.data.Mod;
import com.lightning.northstar.data.Tags;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.tterrag.registrate.util.entry.FluidEntry;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.createmod.catnip.registry.RegisteredObjectsHelper;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.material.Fluid;
import org.apache.logging.log4j.util.TriConsumer;
import org.jetbrains.annotations.ApiStatus;

public record FuelType(List<String> fluids, float gjPerMb, float combustionEngineUse, float combustionEngineRpm) {
    public static final Codec<FuelType> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.STRING.listOf().optionalFieldOf("fluids", List.of()).forGetter(FuelType::fluids), (App)Codec.FLOAT.optionalFieldOf("gj_per_mb", (Object)Float.valueOf(0.0f)).forGetter(FuelType::gjPerMb), (App)Codec.FLOAT.optionalFieldOf("combustion_engine_use", (Object)Float.valueOf(0.0f)).forGetter(FuelType::combustionEngineUse), (App)Codec.FLOAT.optionalFieldOf("combustion_engine_rpm", (Object)Float.valueOf(0.0f)).forGetter(FuelType::combustionEngineRpm)).apply((Applicative)i, FuelType::new));
    private static final Map<Fluid, FuelType> FUEL_CACHE = new ConcurrentHashMap<Fluid, FuelType>();

    public static Builder builder() {
        return new Builder();
    }

    @ApiStatus.Internal
    public static void recacheFuels(RegistryAccess registryAccess) {
        FUEL_CACHE.clear();
        Registry fluids = registryAccess.registryOrThrow(Registries.FLUID);
        Registry fuels = registryAccess.registryOrThrow(NorthstarRegistries.FUEL);
        Object2IntOpenHashMap scores = new Object2IntOpenHashMap();
        TriConsumer cache = (arg_0, arg_1, arg_2) -> FuelType.lambda$recacheFuels$1((Object2IntMap)scores, fuels, fluids, arg_0, arg_1, arg_2);
        for (Map.Entry entry : fuels.entrySet()) {
            ResourceLocation key = ((ResourceKey)entry.getKey()).location();
            FuelType fuel = (FuelType)entry.getValue();
            if (fuel.fluids.isEmpty()) {
                fluids.getOptional(key).ifPresentOrElse(fluid -> cache.accept((Object)fuel, fluid, (Object)3), () -> Northstar.LOGGER.warn("Fuel '{}' has no fluids declared and no fluid named '{}' could be found.", (Object)key, (Object)key));
                continue;
            }
            for (String rawFluid : fuel.fluids) {
                if (rawFluid.startsWith("#")) {
                    ResourceLocation loc = ResourceLocation.parse((String)rawFluid.substring(1));
                    TagKey tag = fluids.getTagNames().filter(t -> t.location().equals((Object)loc)).findFirst().orElse(null);
                    if (tag == null) {
                        Northstar.LOGGER.warn("Fuel '{}' tried to reference tag '{}' which doesn't exist.", (Object)key, (Object)loc);
                        continue;
                    }
                    fluids.getTag(tag).ifPresent(holders -> holders.forEach(holder -> cache.accept((Object)fuel, (Object)((Fluid)holder.value()), (Object)1)));
                    continue;
                }
                ResourceLocation fluidLoc = ResourceLocation.parse((String)rawFluid);
                fluids.getOptional(fluidLoc).ifPresentOrElse(fluid -> cache.accept((Object)fuel, fluid, (Object)2), () -> Northstar.LOGGER.warn("Fuel '{}' tried to reference fluid '{}' which could not be found.", (Object)key, (Object)fluidLoc));
            }
        }
    }

    public static FuelType getFuelType(Fluid fluid) {
        return FUEL_CACHE.get(fluid);
    }

    public boolean supports(Fluid fluid) {
        return this.equals(FUEL_CACHE.get(fluid));
    }

    private static /* synthetic */ void lambda$recacheFuels$1(Object2IntMap scores, Registry fuels, Registry fluids, FuelType fuel, Fluid fluid, Integer score) {
        if (scores.getInt((Object)fluid) >= score) {
            return;
        }
        scores.put((Object)fluid, score);
        FuelType previous = FUEL_CACHE.put(fluid, fuel);
        if (previous == null) {
            return;
        }
        ResourceLocation oldKey = fuels.getKey((Object)previous);
        ResourceLocation newKey = fuels.getKey((Object)fuel);
        ResourceLocation fluidKey = fluids.getKey((Object)fluid);
        Northstar.LOGGER.warn("Fuels '{}' and '{}' both use fluid '{}', '{}' will be used.", new Object[]{oldKey, newKey, fluidKey, newKey});
    }

    public static class Builder {
        private List<String> fluids = new ArrayList<String>();
        private float gjPerMb;
        private float combustionEngineUse;
        private float combustionEngineRpm;

        public Builder tag(Tags.Tag<Fluid> tag) {
            return this.tag(tag.tag());
        }

        public Builder tag(TagKey<Fluid> tag) {
            return this.tag(tag.location());
        }

        public Builder tag(Mod mod, String tag) {
            return this.tag(mod.loc(tag));
        }

        public Builder tag(ResourceLocation tag) {
            this.fluids.add("#" + tag.toString());
            return this;
        }

        public Builder fluid(FluidEntry<?> fluid) {
            return this.rawFluid(fluid.getKey().location());
        }

        public Builder fluid(Fluid fluid) {
            return this.rawFluid(RegisteredObjectsHelper.getKeyOrThrow((Fluid)fluid));
        }

        public Builder fluid(Mod mod, String tag) {
            return this.rawFluid(mod.loc(tag));
        }

        public Builder rawFluid(ResourceLocation fluid) {
            this.fluids.add(fluid.toString());
            return this;
        }

        public Builder gjPerMb(float gjPerMb) {
            this.gjPerMb = gjPerMb;
            return this;
        }

        public Builder combustionEngine(float usePerTick, float rpm) {
            this.combustionEngineUse = usePerTick;
            this.combustionEngineRpm = rpm;
            return this;
        }

        public FuelType build() {
            return new FuelType(this.fluids, this.gjPerMb, this.combustionEngineUse, this.combustionEngineRpm);
        }
    }
}

