/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.content;

import com.lightning.northstar.data.Tags;
import com.lightning.northstar.data.util.NorthstarDataGenTags;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.util.nullness.NonNullFunction;
import net.createmod.catnip.lang.Lang;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public class NorthstarTags {
    public static void register() {
        NorthstarFluidTags.init();
        NorthstarBlockTags.init();
        NorthstarItemTags.init();
        NorthstarEntityTags.init();
        NorthstarBiomeTags.init();
    }

    public static enum NorthstarFluidTags implements Tags.Tag<Fluid>
    {
        BREATHABLE,
        COMPAT_CBC_MOLTEN_CAST_IRON,
        COMPAT_CDG_BIODIESEL,
        C_BIOFUEL(Namespace.COMMON, "biofuel"),
        C_BRINE(Namespace.COMMON, "brine"),
        C_CARBON(Namespace.COMMON, "carbon"),
        C_CHLORINE(Namespace.COMMON, "chlorine"),
        C_CHOCOLATE_ICE_CREAM(Namespace.COMMON, "chocolate_ice_cream"),
        C_GASEOUS(Namespace.COMMON, "gaseous"),
        C_HYDROCARBON(Namespace.COMMON, "hydrocarbon"),
        C_HYDROGEN(Namespace.COMMON, "hydrogen"),
        C_LIQUID_HYDROGEN(Namespace.COMMON, "liquid_hydrogen"),
        C_LIQUID_OXYGEN(Namespace.COMMON, "liquid_oxygen"),
        C_METHANE(Namespace.COMMON, "methane"),
        C_OXYGEN(Namespace.COMMON, "oxygen"),
        C_SODIUM(Namespace.COMMON, "sodium"),
        C_STRAWBERRY_ICE_CREAM(Namespace.COMMON, "strawberry_ice_cream"),
        C_SULFURIC_ACID(Namespace.COMMON, "sulfuric_acid"),
        C_TITANIUM_TETRACHLORIDE(Namespace.COMMON, "titanium_tetrachloride"),
        C_VANILLA_ICE_CREAM(Namespace.COMMON, "vanilla_ice_cream"),
        IS_OXY;

        public final TagKey<Fluid> tag;

        private NorthstarFluidTags() {
            this(Namespace.MOD);
        }

        private NorthstarFluidTags(Namespace namespace) {
            this(namespace, null);
        }

        private NorthstarFluidTags(Namespace namespace, String path) {
            this.tag = namespace.tag(Registries.FLUID, this, path);
        }

        @Override
        public TagKey<Fluid> tag() {
            return this.tag;
        }

        public boolean matches(FluidStack fluid) {
            return fluid.getFluid().defaultFluidState().is(this.tag);
        }

        public boolean matches(Fluid fluid) {
            return fluid.defaultFluidState().is(this.tag);
        }

        public boolean matches(FluidState state) {
            return state.is(this.tag);
        }

        private static void init() {
        }
    }

    public static enum NorthstarBlockTags implements Tags.Tag<Block>
    {
        AIR_PASSES_THROUGH,
        ARGYRE_REPLACEABLE,
        BASE_STONE_MARS,
        BASE_STONE_MERCURY,
        BASE_STONE_MOON,
        BASE_STONE_VENUS,
        BASE_SURFACE_BLOCKS_MARS,
        BLOCKS_AIR,
        C_STORAGE_BLOCKS_MARTIAN_STEEL(Namespace.COMMON, "storage_blocks/martian_steel"),
        C_STORAGE_BLOCKS_TITANIUM(Namespace.COMMON, "storage_blocks/titanium"),
        C_STORAGE_BLOCKS_TUNGSTEN(Namespace.COMMON, "storage_blocks/tungsten"),
        C_ORES_GLOWSTONE(Namespace.COMMON, "ores/glowstone"),
        C_ORES_TITANIUM(Namespace.COMMON, "ores/titanium"),
        C_ORES_TUNGSTEN(Namespace.COMMON, "ores/tungsten"),
        C_ORES_ZINC(Namespace.COMMON, "ores/zinc"),
        HEAVY_BLOCKS,
        MARS_BLOCKS,
        MARS_DEEP_STONE_REPLACEABLE,
        MARS_STONE_REPLACEABLE,
        MERCURY_DEEP_STONE_REPLACEABLE,
        MERCURY_STONE_REPLACEABLE,
        MOON_BLOCKS,
        MOON_DEEP_STONE_REPLACEABLE,
        MOON_STONE_REPLACEABLE,
        MOON_SURFACE_REPLACEABLE,
        NATURAL_MARS_BLOCKS,
        NATURAL_MERCURY_BLOCKS,
        NATURAL_MOON_BLOCKS,
        NATURAL_VENUS_BLOCKS,
        SUPER_HEAVY_BLOCKS,
        TIER_1_HEAT_RESISTANCE,
        TIER_2_HEAT_RESISTANCE,
        TIER_3_HEAT_RESISTANCE,
        VENUS_DEEP_STONE_REPLACEABLE,
        VENUS_STONE,
        VENUS_STONE_REPLACEABLE;

        public final TagKey<Block> tag;

        private NorthstarBlockTags() {
            this(Namespace.MOD);
        }

        private NorthstarBlockTags(Namespace namespace) {
            this(namespace, null);
        }

        private NorthstarBlockTags(Namespace namespace, String path) {
            this.tag = namespace.tag(Registries.BLOCK, this, path);
        }

        @Override
        public TagKey<Block> tag() {
            return this.tag;
        }

        public TagKey<Item> item() {
            return ItemTags.create((ResourceLocation)this.tag.location());
        }

        public <T extends Block, P> NonNullFunction<BlockBuilder<T, P>, BlockBuilder<T, P>> tagBlockAndItem() {
            return NorthstarDataGenTags.apply(this.tag, this.item());
        }

        public boolean matches(Block block) {
            return block.builtInRegistryHolder().is(this.tag);
        }

        public boolean matches(ItemStack stack) {
            BlockItem blockItem;
            Item item;
            return stack != null && (item = stack.getItem()) instanceof BlockItem && this.matches((blockItem = (BlockItem)item).getBlock());
        }

        public boolean matches(BlockState state) {
            return state.is(this.tag);
        }

        private static void init() {
        }
    }

    public static enum NorthstarItemTags implements Tags.Tag<Item>
    {
        ARGYRE_LOGS,
        CALORIAN_LOGS,
        COILER_LOGS,
        C_BUCKETS_BIOFUEL(Namespace.COMMON, "buckets/biofuel"),
        C_BUCKETS_BRINE(Namespace.COMMON, "buckets/brine"),
        C_BUCKETS_HYDROCARBON(Namespace.COMMON, "buckets/hydrocarbon"),
        C_BUCKETS_LIQUID_HYDROGEN(Namespace.COMMON, "buckets/liquid_hydrogen"),
        C_BUCKETS_LIQUID_OXYGEN(Namespace.COMMON, "buckets/"),
        C_BUCKETS_METHANE(Namespace.COMMON, "buckets/methane"),
        C_BUCKETS_SULFURIC_ACID(Namespace.COMMON, "buckets/sulfuric_acid"),
        C_DUSTS(Namespace.COMMON, "dusts"),
        C_DUSTS_SALT(Namespace.COMMON, "dusts/salt"),
        C_DUSTS_VOLCANIC_ASH(Namespace.COMMON, "dusts/volcanic_ash"),
        C_FABRICS(Namespace.COMMON, "fabrics"),
        C_FIBERS(Namespace.COMMON, "fibers"),
        C_FOODS_ICE_CREAM(Namespace.COMMON, "foods/ice_cream"),
        C_GEMS_SAPPHIRE(Namespace.COMMON, "gems/sapphire"),
        C_INGOTS(Namespace.COMMON, "ingots"),
        C_INGOTS_BRASS(Namespace.COMMON, "ingots/brass"),
        C_INGOTS_MARTIAN_STEEL(Namespace.COMMON, "ingots/martian_steel"),
        C_INGOTS_TITANIUM(Namespace.COMMON, "ingots/titanium"),
        C_INGOTS_TUNGSTEN(Namespace.COMMON, "ingots/tungsten"),
        C_NUGGETS_TITANIUM(Namespace.COMMON, "nuggets/titanium"),
        C_NUGGETS_TUNGSTEN(Namespace.COMMON, "nuggets/tungsten"),
        C_RAW_MATERIALS_MARTIAN_IRON_ORE(Namespace.COMMON, "raw_materials/martian_iron_ore"),
        C_RAW_MATERIALS_TITANIUM(Namespace.COMMON, "raw_materials/titanium"),
        C_RAW_MATERIALS_TUNGSTEN(Namespace.COMMON, "raw_materials/tungsten"),
        C_SHEETS(Namespace.COMMON, "plates"),
        C_SHEETS_BRASS(Namespace.COMMON, "plates/brass"),
        C_SHEETS_COPPER(Namespace.COMMON, "plates/copper"),
        C_SHEETS_GOLD(Namespace.COMMON, "plates/gold"),
        C_SHEETS_IRON(Namespace.COMMON, "plates/iron"),
        C_SHEETS_MARTIAN_STEEL(Namespace.COMMON, "plates/martian_steel"),
        C_SHEETS_TITANIUM(Namespace.COMMON, "plates/titanium"),
        C_SHEETS_TUNGSTEN(Namespace.COMMON, "plates/tungsten"),
        C_STRIPPED_LOGS(Namespace.COMMON, "stripped_logs"),
        HEAT_RESISTANT,
        IGNITION_SOURCE,
        INSULATING,
        OXYGEN_SEALING,
        OXYGEN_SOURCES,
        WILTER_LOGS;

        public final TagKey<Item> tag;

        private NorthstarItemTags() {
            this(Namespace.MOD);
        }

        private NorthstarItemTags(String path) {
            this(Namespace.MOD, path);
        }

        private NorthstarItemTags(Namespace namespace) {
            this(namespace, null);
        }

        private NorthstarItemTags(Namespace namespace, String path) {
            this.tag = namespace.tag(Registries.ITEM, this, path);
        }

        @Override
        public TagKey<Item> tag() {
            return this.tag;
        }

        public boolean matches(Item item) {
            return item.builtInRegistryHolder().is(this.tag);
        }

        public boolean matches(ItemStack stack) {
            return stack.is(this.tag);
        }

        private static void init() {
        }
    }

    public static enum NorthstarEntityTags implements Tags.Tag<EntityType<?>>
    {
        CAN_SURVIVE_COLD,
        CAN_SURVIVE_HEAT,
        DOESNT_REQUIRE_OXYGEN;

        public final TagKey<EntityType<?>> tag;

        private NorthstarEntityTags() {
            this(Namespace.MOD);
        }

        private NorthstarEntityTags(Namespace namespace) {
            this(namespace, null);
        }

        private NorthstarEntityTags(Namespace namespace, String path) {
            this.tag = namespace.tag(Registries.ENTITY_TYPE, this, path);
        }

        @Override
        public TagKey<EntityType<?>> tag() {
            return this.tag;
        }

        public boolean matches(Entity entity) {
            return entity.getType().is(this.tag);
        }

        private static void init() {
        }
    }

    public static enum NorthstarBiomeTags {
        IS_DUSTY,
        HAS_AMBIENT_GLOWSTONE_PARTICLE;

        public final TagKey<Biome> tag;

        private NorthstarBiomeTags() {
            this(Namespace.MOD);
        }

        private NorthstarBiomeTags(Namespace namespace) {
            this(namespace, null);
        }

        private NorthstarBiomeTags(Namespace namespace, String path) {
            this.tag = namespace.tag(Registries.BIOME, this, path);
        }

        private static void init() {
        }
    }

    static enum Namespace {
        MOD("northstar"),
        COMMON("c");

        public final String id;

        private Namespace(String id) {
            this.id = id;
        }

        private <T> TagKey<T> tag(ResourceKey<Registry<T>> registry, Enum<?> entry, @Nullable String path) {
            return TagKey.create(registry, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)this.id, (String)(path == null ? Lang.asId((String)entry.name()) : path)));
        }
    }
}

