/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.compat.kubejs.recipe;

import com.lightning.northstar.Northstar;
import com.lightning.northstar.compat.kubejs.recipe.NorthstarComponents;
import com.mojang.datafixers.util.Either;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import dev.latvian.mods.kubejs.recipe.KubeRecipe;
import dev.latvian.mods.kubejs.recipe.RecipeKey;
import dev.latvian.mods.kubejs.recipe.component.NumberComponent;
import dev.latvian.mods.kubejs.recipe.component.TimeComponent;
import dev.latvian.mods.kubejs.recipe.schema.KubeRecipeFactory;
import dev.latvian.mods.kubejs.recipe.schema.RecipeSchema;
import dev.latvian.mods.kubejs.util.TickDuration;
import java.util.List;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;

public interface FreezingRecipeSchema {
    public static final RecipeKey<List<Either<SizedFluidIngredient, Ingredient>>> INGREDIENTS = NorthstarComponents.SIZED_FLUID_OR_ITEM_LIST.inputKey("ingredients");
    public static final RecipeKey<List<Either<FluidStack, ProcessingOutput>>> RESULTS = NorthstarComponents.FLUID_OR_PROCESSING_OUTPUT_LIST.outputKey("results");
    public static final RecipeKey<Integer> MIN_TEMPERATURE = NumberComponent.INT.inputKey("minTemperature").optional((Object)Integer.MIN_VALUE);
    public static final RecipeKey<Integer> MAX_TEMPERATURE = NumberComponent.INT.inputKey("maxTemperature").optional((Object)Integer.MAX_VALUE);
    public static final RecipeKey<TickDuration> TIME = TimeComponent.TICKS.inputKey("processingTime").optional((Object)TickDuration.of((long)100L));
    public static final RecipeSchema SCHEMA = new RecipeSchema(new RecipeKey[]{RESULTS, INGREDIENTS, MIN_TEMPERATURE, MAX_TEMPERATURE, TIME}).constructor(new RecipeKey[]{RESULTS, INGREDIENTS, TIME}).factory(FreezingRecipeJS.RECIPE_FACTORY);

    public static class FreezingRecipeJS
    extends KubeRecipe {
        public static final KubeRecipeFactory RECIPE_FACTORY = new KubeRecipeFactory(Northstar.asResource("freezing"), FreezingRecipeJS.class, FreezingRecipeJS::new);

        public KubeRecipe duration(TickDuration ticks) {
            return this.setValue(TIME, ticks);
        }

        public KubeRecipe colderThan(int temp) {
            return this.withinTemperature(Integer.MIN_VALUE, temp);
        }

        public KubeRecipe hotterThan(int temp) {
            return this.withinTemperature(temp, Integer.MAX_VALUE);
        }

        public KubeRecipe withTemperature(int temp) {
            return this.withinTemperature(temp, temp);
        }

        public KubeRecipe withinTemperature(int min, int max) {
            return this.setValue(MIN_TEMPERATURE, min).setValue(MAX_TEMPERATURE, (Object)max);
        }
    }
}

