/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.compat.jei.category;

import com.lightning.northstar.block.tech.combustion_engine.CombustionEngineBlock;
import com.lightning.northstar.block.tech.jet_engine.JetEngineBlock;
import com.lightning.northstar.content.NorthstarBlocks;
import com.lightning.northstar.contraption.FuelType;
import com.lightning.northstar.util.NorthstarLang;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.neoforge.NeoForgeTypes;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.AbstractRecipeCategory;
import mezz.jei.common.util.RegistryUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.neoforged.neoforge.fluids.FluidStack;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class FuelTypeCategory
extends AbstractRecipeCategory<FuelType> {
    public static final RecipeType<FuelType> RECIPE_TYPE = RecipeType.create((String)"northstar", (String)"fuel_type", FuelType.class);
    public static final int WIDTH = 142;
    public static final int HEIGHT = 60;

    public FuelTypeCategory(IGuiHelper guiHelper) {
        super(RECIPE_TYPE, (Component)Component.translatable((String)"northstar.recipe.fuel_type"), guiHelper.createDrawableItemLike(NorthstarBlocks.JET_ENGINE), 142, 60);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, FuelType recipe, IFocusGroup focuses) {
        List<FluidStack> fluids = RegistryUtil.getRegistryAccess().registryOrThrow(Registries.FLUID).stream().filter(recipe::supports).map(fluid -> new FluidStack(fluid, 1)).toList();
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 5, 5).setBackground(CreateRecipeCategory.getRenderedSlot(), -1, -1).addIngredients((IIngredientType)NeoForgeTypes.FLUID_STACK, fluids)).setFluidRenderer(1L, false, 16, 16);
    }

    public void draw(FuelType recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        super.draw((Object)recipe, recipeSlotsView, graphics, mouseX, mouseY);
        Font font = Minecraft.getInstance().font;
        ArrayList tooltip = new ArrayList();
        int baseIndents = -4;
        NorthstarLang.builder().add(((CombustionEngineBlock)NorthstarBlocks.COMBUSTION_ENGINE.get()).getName()).text(":").forGoggles(tooltip, baseIndents);
        NorthstarLang.translate("recipe.fuel_type.consumption", new Object[0]).add(NorthstarLang.number(recipe.combustionEngineUse()).add(NorthstarLang.MB_PER_TICK).style(ChatFormatting.GOLD)).forGoggles(tooltip, baseIndents + 1);
        NorthstarLang.translate("recipe.fuel_type.speed", new Object[0]).add(NorthstarLang.number(recipe.combustionEngineRpm()).text(" ").add(CreateLang.translate((String)"generic.unit.rpm", (Object[])new Object[0])).style(ChatFormatting.AQUA)).forGoggles(tooltip, baseIndents + 1);
        NorthstarLang.builder().add(((JetEngineBlock)((Object)NorthstarBlocks.JET_ENGINE.get())).getName()).text(":").forGoggles(tooltip, baseIndents);
        NorthstarLang.translate("recipe.fuel_type.energy", new Object[0]).add(NorthstarLang.number(recipe.gjPerMb()).add(NorthstarLang.GJ_PER_MB).style(ChatFormatting.AQUA)).forGoggles(tooltip, baseIndents + 1);
        int y = 5;
        for (Component line : tooltip) {
            graphics.drawString(font, line, 25, y, -1);
            y += 10;
        }
    }
}

