/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.compat.copycats;

import com.copycatsplus.copycats.foundation.copycat.multistate.IMultiStateCopycatBlockEntity;
import com.copycatsplus.copycats.foundation.copycat.multistate.MaterialItemStorage;
import com.lightning.northstar.content.NorthstarTags;
import com.lightning.northstar.mixin.accessor.NorthstarContraptionWorld;
import com.simibubi.create.AllBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class CopycatSealHelper {
    public static boolean isMaterialSealed(BlockState state) {
        return !NorthstarTags.NorthstarBlockTags.AIR_PASSES_THROUGH.matches(state);
    }

    public static CompoundTag getBlockNbt(NorthstarContraptionWorld cw, BlockPos pos) {
        StructureTemplate.StructureBlockInfo block = (StructureTemplate.StructureBlockInfo)cw.northstar$getContraption().getBlocks().get(pos);
        return block == null ? null : block.nbt();
    }

    public static BlockState getMultistateMaterial(CompoundTag tag, Property<?> property) {
        return CopycatSealHelper.getMultistateMaterial(tag, property.getName());
    }

    public static BlockState getMultistateMaterial(CompoundTag tag, String property) {
        if (tag == null) {
            return AllBlocks.COPYCAT_BASE.getDefaultState();
        }
        return NbtUtils.readBlockState((HolderGetter)BuiltInRegistries.BLOCK.asLookup(), (CompoundTag)tag.getCompound("material_data").getCompound(property).getCompound("material"));
    }

    public static BlockState getMultistateMaterial(MaterialItemStorage storage, Property<?> property) {
        MaterialItemStorage.MaterialItem item = storage.getMaterialItem(property.getName());
        return item == null ? AllBlocks.COPYCAT_BASE.getDefaultState() : item.material();
    }

    public static BlockState getMultistateMaterial(MaterialItemStorage storage, String property) {
        MaterialItemStorage.MaterialItem item = storage.getMaterialItem(property);
        return item == null ? AllBlocks.COPYCAT_BASE.getDefaultState() : item.material();
    }

    public static boolean isSlabSealed(BlockGetter level, BlockPos pos, SlabType testType, String negativeProperty, String positiveProperty) {
        if (level instanceof NorthstarContraptionWorld) {
            NorthstarContraptionWorld cw = (NorthstarContraptionWorld)level;
            CompoundTag compound = CopycatSealHelper.getBlockNbt(cw, pos);
            if (compound == null) {
                return true;
            }
            if (testType != SlabType.DOUBLE) {
                String property = testType == SlabType.BOTTOM ? negativeProperty : positiveProperty;
                return CopycatSealHelper.isMaterialSealed(CopycatSealHelper.getMultistateMaterial(compound, property));
            }
            return CopycatSealHelper.isMaterialSealed(CopycatSealHelper.getMultistateMaterial(compound, negativeProperty)) && CopycatSealHelper.isMaterialSealed(CopycatSealHelper.getMultistateMaterial(compound, positiveProperty));
        }
        BlockEntity compound = level.getBlockEntity(pos);
        if (compound instanceof IMultiStateCopycatBlockEntity) {
            IMultiStateCopycatBlockEntity be = (IMultiStateCopycatBlockEntity)compound;
            MaterialItemStorage storage = be.getMaterialItemStorage();
            if (testType != SlabType.DOUBLE) {
                String property = testType == SlabType.BOTTOM ? negativeProperty : positiveProperty;
                return CopycatSealHelper.isMaterialSealed(CopycatSealHelper.getMultistateMaterial(storage, property));
            }
            return CopycatSealHelper.isMaterialSealed(CopycatSealHelper.getMultistateMaterial(storage, negativeProperty)) && CopycatSealHelper.isMaterialSealed(CopycatSealHelper.getMultistateMaterial(storage, positiveProperty));
        }
        return false;
    }
}

