/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.client.renderer;

import com.lightning.northstar.content.NorthstarDataComponents;
import com.lightning.northstar.world.oxygen.NorthstarOxygen;
import com.mojang.blaze3d.vertex.PoseStack;
import net.createmod.catnip.gui.element.GuiGameElement;
import net.createmod.catnip.theme.Color;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.util.StringUtil;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class RemainingOxygenOverlay
implements LayeredDraw.Layer {
    public static final RemainingOxygenOverlay INSTANCE = new RemainingOxygenOverlay();

    public void render(GuiGraphics graphics, DeltaTracker delta) {
        PoseStack pose = graphics.pose();
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (mc.options.hideGui || player == null || player.isSpectator() || player.isCreative() || NorthstarOxygen.hasOxygen(player.level(), player.getEyePosition()) && !player.canDrownInFluidType(player.getEyeInFluidType())) {
            return;
        }
        ItemStack tank = NorthstarOxygen.getOxygenTank((LivingEntity)player);
        if (tank.isEmpty()) {
            return;
        }
        int remainingTime = tank.has(NorthstarDataComponents.OXYGEN) ? (Integer)tank.get(NorthstarDataComponents.OXYGEN) : 0;
        pose.pushPose();
        pose.translate((float)graphics.guiWidth() / 2.0f + 95.0f, (float)(graphics.guiHeight() - 40), 0.0f);
        int color = -1;
        if (remainingTime <= 60 && remainingTime % 2 == 0) {
            color = Color.mixColors((int)-65536, (int)color, (float)Math.max((float)remainingTime / 60.0f, 0.25f));
        }
        GuiGameElement.of((ItemStack)tank).at(0.0f, 0.0f).render(graphics);
        graphics.drawString(mc.font, StringUtil.formatTickDuration((int)(Math.max(0, remainingTime - 1) * 20), (float)20.0f), 18, 5, color);
        pose.popPose();
    }
}

