/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.tech.temperature_regulator;

import com.lightning.northstar.block.tech.temperature_regulator.TemperatureRegulatorBlockEntity;
import com.lightning.northstar.content.NorthstarPartialModels;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.RotatingInstance;
import com.simibubi.create.content.kinetics.base.SingleAxisRotatingVisual;
import com.simibubi.create.foundation.render.AllInstanceTypes;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.visual.TickableVisual;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.FlatLit;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import java.util.function.Consumer;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;

public class TemperatureRegulatorVisual
extends SingleAxisRotatingVisual<TemperatureRegulatorBlockEntity> {
    private final RotatingInstance warmSpinner = ((RotatingInstance)this.instancerProvider().instancer(AllInstanceTypes.ROTATING, Models.partial((PartialModel)NorthstarPartialModels.WARM_SPINNER)).createInstance()).setRotationAxis(Direction.Axis.Y);
    private final RotatingInstance coldSpinner;

    public TemperatureRegulatorVisual(VisualizationContext context, TemperatureRegulatorBlockEntity entity, float partialTick) {
        super(context, (KineticBlockEntity)entity, partialTick, Models.partial((PartialModel)AllPartialModels.SHAFT_HALF, (Direction)Direction.DOWN));
        this.warmSpinner.setChanged();
        this.coldSpinner = ((RotatingInstance)this.instancerProvider().instancer(AllInstanceTypes.ROTATING, Models.partial((PartialModel)NorthstarPartialModels.COLD_SPINNER)).createInstance()).setRotationAxis(Direction.Axis.Y);
        this.coldSpinner.setChanged();
    }

    public void tick(TickableVisual.Context context) {
        super.tick(context);
        float speed = ((TemperatureRegulatorBlockEntity)this.blockEntity).getSpeed();
        boolean warm = ((TemperatureRegulatorBlockEntity)this.blockEntity).isCurrentlyWarm();
        this.warmSpinner.setVisible(warm);
        this.warmSpinner.setPosition((Vec3i)this.getVisualPosition()).setRotationalSpeed(speed / 2.0f).setChanged();
        this.coldSpinner.setVisible(!warm);
        this.coldSpinner.setPosition((Vec3i)this.getVisualPosition()).setRotationalSpeed(speed / 2.0f).setChanged();
    }

    public void updateLight(float partialTick) {
        super.updateLight(partialTick);
        this.relight(new FlatLit[]{this.warmSpinner, this.coldSpinner});
    }

    protected void _delete() {
        super._delete();
        this.warmSpinner.delete();
        this.coldSpinner.delete();
    }

    public void collectCrumblingInstances(Consumer<Instance> consumer) {
        super.collectCrumblingInstances(consumer);
        consumer.accept((Instance)this.warmSpinner);
        consumer.accept((Instance)this.coldSpinner);
    }
}

