/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.tech.telescope;

import com.lightning.northstar.block.tech.telescope.TelescopeBlockEntity;
import com.lightning.northstar.content.NorthstarBlockEntityTypes;
import com.lightning.northstar.content.NorthstarStats;
import com.lightning.northstar.world.dimension.NorthstarPlanets;
import com.mojang.serialization.MapCodec;
import com.simibubi.create.foundation.block.IBE;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Vector3f;

public class TelescopeBlock
extends BaseEntityBlock
implements IBE<TelescopeBlockEntity> {
    private static final MapCodec<TelescopeBlock> CODEC = TelescopeBlock.simpleCodec(TelescopeBlock::new);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    protected static final VoxelShape SHAPE = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)24.0, (double)12.0);

    public TelescopeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    public RenderShape getRenderShape(BlockState p_49232_) {
        return RenderShape.MODEL;
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        Direction player_looking = pContext.getNearestLookingDirection();
        if (player_looking == Direction.UP || player_looking == Direction.DOWN) {
            return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH);
        }
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)pContext.getNearestLookingDirection());
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (!level.isClientSide()) {
            BlockEntity entity = level.getBlockEntity(pos);
            if (entity instanceof TelescopeBlockEntity && this.canSeeSky(pos.above(), level, (Direction)state.getValue((Property)FACING)) && (level.isNight() || NorthstarPlanets.canSeeSkyAtDay((ResourceKey<Level>)level.dimension())) && (!level.isRaining() || !NorthstarPlanets.hasWeather((ResourceKey<Level>)level.dimension())) && NorthstarPlanets.planetHasSky((ResourceKey<Level>)level.dimension())) {
                player.openMenu((MenuProvider)((TelescopeBlockEntity)entity), pos);
                player.awardStat(NorthstarStats.INTERACT_WITH_TELESCOPE);
            } else {
                player.displayClientMessage((Component)Component.translatable((String)"northstar.gui.telescope_fail"), true);
            }
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide());
    }

    private boolean canSeeSky(BlockPos pos, Level level, Direction dir) {
        boolean flag = false;
        int clearSpots = 0;
        for (int x = 0; x <= 3; ++x) {
            Vector3f vec = dir.step();
            vec.mul((float)x);
            if (!level.canSeeSky(pos.offset(Mth.floor((float)vec.x), Mth.floor((float)vec.y), Mth.floor((float)vec.z))) || ++clearSpots < 2) continue;
            flag = true;
        }
        return flag;
    }

    public Class<TelescopeBlockEntity> getBlockEntityClass() {
        return TelescopeBlockEntity.class;
    }

    public BlockEntityType<? extends TelescopeBlockEntity> getBlockEntityType() {
        return (BlockEntityType)NorthstarBlockEntityTypes.TELESCOPE.get();
    }
}

