/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.tech.solar_panel;

import com.lightning.northstar.world.dimension.NorthstarPlanets;
import com.simibubi.create.content.kinetics.base.GeneratingKineticBlockEntity;
import net.createmod.catnip.animation.LerpedFloat;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class SolarPanelBlockEntity
extends GeneratingKineticBlockEntity {
    public static final int MAXIMUM_SPEED = 16;
    public final LerpedFloat targetAngle = LerpedFloat.angular();
    private int lastLight = -1;
    private float generatedSpeed;

    public SolarPanelBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void tick() {
        super.tick();
        if (this.level.isClientSide()) {
            this.targetAngle.tickChaser();
        } else {
            int light = Math.max(0, this.level.getBrightness(LightLayer.SKY, this.worldPosition) - this.level.getSkyDarken());
            if (light != this.lastLight && this.getFlickerScore() <= 64) {
                this.lastLight = light;
                this.generatedSpeed = (float)(16 * light) / 15.0f * NorthstarPlanets.getSunMultiplier((ResourceKey<Level>)this.level.dimension());
                this.updateGeneratedRotation();
            }
        }
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(compound, registries, clientPacket);
        this.generatedSpeed = compound.getFloat("GeneratorSpeed");
        this.lastLight = -1;
    }

    protected void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(compound, registries, clientPacket);
        compound.putFloat("GeneratorSpeed", this.generatedSpeed);
    }

    public float getGeneratedSpeed() {
        return this.generatedSpeed;
    }

    protected AABB createRenderBoundingBox() {
        return new AABB(this.worldPosition).inflate(1.0);
    }
}

