/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.tech.rocket_controls;

import com.lightning.northstar.block.tech.rocket_controls.RocketControlsServerHandler;
import com.lightning.northstar.content.NorthstarPackets;
import com.lightning.northstar.contraption.rocket.RocketContraptionEntity;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.UUID;
import net.createmod.catnip.codecs.stream.CatnipStreamCodecBuilders;
import net.createmod.catnip.net.base.BasePacketPayload;
import net.createmod.catnip.net.base.ServerboundPacketPayload;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;

public class RocketControlsInputPacket
implements ServerboundPacketPayload {
    public static final StreamCodec<ByteBuf, RocketControlsInputPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)CatnipStreamCodecBuilders.list((StreamCodec)ByteBufCodecs.VAR_INT), packet -> packet.activatedButtons, (StreamCodec)ByteBufCodecs.BOOL, packet -> packet.press, (StreamCodec)ByteBufCodecs.VAR_INT, packet -> packet.contraptionEntityId, (StreamCodec)BlockPos.STREAM_CODEC, packet -> packet.controlsPos, (StreamCodec)ByteBufCodecs.BOOL, packet -> packet.stopControlling, RocketControlsInputPacket::new);
    private List<Integer> activatedButtons;
    private boolean press;
    private int contraptionEntityId;
    private BlockPos controlsPos;
    private boolean stopControlling;

    public RocketControlsInputPacket(List<Integer> activatedButtons, boolean press, int contraptionEntityId, BlockPos controlsPos, boolean stopControlling) {
        this.contraptionEntityId = contraptionEntityId;
        this.activatedButtons = activatedButtons;
        this.press = press;
        this.contraptionEntityId = contraptionEntityId;
        this.controlsPos = controlsPos;
        this.stopControlling = stopControlling;
    }

    public void handle(ServerPlayer player) {
        Level world = player.getCommandSenderWorld();
        UUID uniqueID = player.getUUID();
        if (player.isSpectator() && this.press) {
            return;
        }
        Entity entity = world.getEntity(this.contraptionEntityId);
        if (!(entity instanceof RocketContraptionEntity)) {
            return;
        }
        RocketContraptionEntity rce = (RocketContraptionEntity)entity;
        if (this.stopControlling) {
            rce.stopControlling(this.controlsPos);
            rce.cancelLaunch();
            return;
        }
        if (rce.toGlobalVector(Vec3.atCenterOf((Vec3i)this.controlsPos), 0.0f).closerThan((Position)player.position(), 16.0)) {
            RocketControlsServerHandler.receivePressed((LevelAccessor)world, rce, this.controlsPos, uniqueID, this.activatedButtons, this.press);
        }
    }

    public BasePacketPayload.PacketTypeProvider getTypeProvider() {
        return NorthstarPackets.ROCKET_CONTROLS_INPUT;
    }
}

