/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.tech.oxygen_filler;

import com.lightning.northstar.block.tech.oxygen_filler.OxygenFillerBlockEntity;
import com.lightning.northstar.content.NorthstarBlockEntityTypes;
import com.lightning.northstar.content.NorthstarStats;
import com.simibubi.create.content.kinetics.base.HorizontalKineticBlock;
import com.simibubi.create.foundation.block.IBE;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class OxygenFillerBlock
extends HorizontalKineticBlock
implements IBE<OxygenFillerBlockEntity> {
    public static final Map<Direction, VoxelShape> SHAPES;

    public OxygenFillerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(HORIZONTAL_FACING, (Comparable)Direction.NORTH));
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPES.get(state.getValue(HORIZONTAL_FACING));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        if (context.getPlayer() != null && context.getPlayer().isCrouching()) {
            return (BlockState)this.defaultBlockState().setValue(HORIZONTAL_FACING, (Comparable)context.getHorizontalDirection());
        }
        return (BlockState)this.defaultBlockState().setValue(HORIZONTAL_FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        return this.use(state, level, pos, player, InteractionHand.MAIN_HAND, hitResult).result();
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        return this.use(state, level, pos, player, hand, hitResult);
    }

    public ItemInteractionResult use(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        return this.onBlockEntityUseItemOn((BlockGetter)world, pos, be -> {
            if (hand != InteractionHand.MAIN_HAND || hit.getDirection() != state.getValue(HORIZONTAL_FACING)) {
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            ItemStack held = player.getItemInHand(hand);
            ItemStack item = be.container.getItem(0);
            if (!world.isClientSide()) {
                player.awardStat(NorthstarStats.INTERACT_WITH_OXYGEN_FILLER);
            }
            if (held.getCount() == 1) {
                be.container.setItem(0, held);
                player.setItemInHand(hand, item);
            } else {
                be.container.setItem(0, held.copyWithCount(1));
                player.setItemInHand(hand, held.copyWithCount(held.getCount() - 1));
                if (!item.isEmpty()) {
                    player.getInventory().placeItemBackInInventory(item);
                }
            }
            if (!item.isEmpty()) {
                world.playSound(null, pos, SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.2f, 1.0f + world.random.nextFloat());
            }
            be.notifyUpdate();
            return ItemInteractionResult.SUCCESS;
        });
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return Direction.Axis.Y;
    }

    public Class<OxygenFillerBlockEntity> getBlockEntityClass() {
        return OxygenFillerBlockEntity.class;
    }

    public BlockEntityType<? extends OxygenFillerBlockEntity> getBlockEntityType() {
        return (BlockEntityType)NorthstarBlockEntityTypes.OXYGEN_FILLER.get();
    }

    static {
        VoxelShape base = Shapes.or((VoxelShape)OxygenFillerBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape)OxygenFillerBlock.box((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0));
        SHAPES = new EnumMap<Direction, VoxelShape>(Direction.class);
        SHAPES.put(Direction.NORTH, Shapes.or((VoxelShape)base, (VoxelShape)OxygenFillerBlock.box((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0)));
        SHAPES.put(Direction.SOUTH, Shapes.or((VoxelShape)base, (VoxelShape)OxygenFillerBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0)));
        SHAPES.put(Direction.EAST, Shapes.or((VoxelShape)base, (VoxelShape)OxygenFillerBlock.box((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0)));
        SHAPES.put(Direction.WEST, Shapes.or((VoxelShape)base, (VoxelShape)OxygenFillerBlock.box((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)));
        SHAPES.put(Direction.UP, Shapes.block());
        SHAPES.put(Direction.DOWN, Shapes.block());
    }
}

