/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.tech.large_fan;

import com.lightning.northstar.api.create.ReceivingKineticBlockEntity;
import com.lightning.northstar.block.tech.large_fan.LargeFanBlock;
import com.lightning.northstar.block.tech.large_fan.TenPatch;
import com.lightning.northstar.config.NorthstarConfigs;
import com.lightning.northstar.content.NorthstarItems;
import com.lightning.northstar.util.NorthstarLang;
import com.lightning.northstar.world.oxygen.NorthstarOxygen;
import com.simibubi.create.api.connectivity.ConnectivityHandler;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.chainDrive.ChainDriveBlock;
import com.simibubi.create.foundation.blockEntity.IMultiBlockEntityContainer;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class LargeFanBlockEntity
extends KineticBlockEntity
implements IMultiBlockEntityContainer,
ReceivingKineticBlockEntity {
    public static final int MINIMUM_BLADES = 2;
    public static final int MAXIMUM_BLADES = 8;
    protected BlockPos controllerPos;
    protected BlockPos lastKnownPos;
    protected boolean updateConnectivity;
    protected int width = 1;
    protected int height = 1;
    protected boolean updateNeighbors;
    protected BlockPos chain;
    protected boolean flipChain;
    protected int blades;
    protected LerpedFloat effectiveSpeed = LerpedFloat.linear();
    protected float angle;

    public LargeFanBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.setLazyTickRate(20);
    }

    public void destroy() {
        super.destroy();
        this.dropBlades();
    }

    public void tick() {
        super.tick();
        if (this.lastKnownPos == null) {
            this.lastKnownPos = this.worldPosition;
        } else if (!this.lastKnownPos.equals((Object)this.worldPosition)) {
            this.removeController(true);
            this.lastKnownPos = this.worldPosition;
        }
        if (this.updateConnectivity) {
            this.updateConnectivity();
        }
        if (this.updateNeighbors) {
            this.updateNeighbors = false;
            LargeFanBlockEntity.getEdges(this.getAxis(), this.getWidth(), this.getHeight()).forEach(pos -> this.onNeighborChange(this.worldPosition.offset(pos), true));
        }
        if (this.blades >= 2) {
            float targetSpeed;
            float speed = this.getSpeed();
            if (speed == 0.0f) {
                NorthstarOxygen oxygenLevel = this.level.northstar$oxygen();
                if (this.chain == null && !oxygenLevel.hasOxygen() && oxygenLevel.hasOxygen((Vec3i)this.worldPosition)) {
                    float f = speed = this.flipChain ? -64.0f : 64.0f;
                }
            }
            if (Math.abs(targetSpeed = speed * 0.25f) >= Math.abs(this.effectiveSpeed.getValue())) {
                this.effectiveSpeed.chase((double)targetSpeed, (double)0.05f, LerpedFloat.Chaser.EXP);
            } else {
                this.effectiveSpeed.chase((double)targetSpeed, (double)0.2f, LerpedFloat.Chaser.LINEAR);
            }
            this.effectiveSpeed.tickChaser();
            this.angle = (this.angle + this.effectiveSpeed.getValue() / 1200.0f) % 1.0f;
        } else {
            this.effectiveSpeed.setValue(0.0);
        }
    }

    protected AABB createRenderBoundingBox() {
        if (this.isController()) {
            return super.createRenderBoundingBox().expandTowards((double)(this.getVolumeX() - 1), (double)(this.getVolumeY() - 1), (double)(this.getVolumeZ() - 1));
        }
        return super.createRenderBoundingBox();
    }

    public void onNeighborChange(BlockPos neighbor, boolean manual) {
        BlockEntity blockEntity;
        BlockState neighborState = this.level.getBlockState(neighbor);
        BlockPos structurePos = this.getBlockAttachedTo(neighbor);
        if (neighbor.equals((Object)this.chain) && !(neighborState.getBlock() instanceof ChainDriveBlock)) {
            BlockEntity blockEntity2;
            this.chain = null;
            if (structurePos != null && (blockEntity2 = this.level.getBlockEntity(structurePos)) instanceof KineticBlockEntity) {
                KineticBlockEntity be = (KineticBlockEntity)blockEntity2;
                be.detachKinetics();
                be.attachKinetics();
            }
            this.updateNeighbors = true;
            this.sendData();
        } else if (manual && this.chain == null && structurePos != null && neighborState.getBlock() instanceof ChainDriveBlock && neighborState.getValue((Property)ChainDriveBlock.AXIS) == this.getAxis() && LargeFanBlockEntity.getFirstAxisBetween(neighbor, structurePos) != this.getAxis() && (blockEntity = this.level.getBlockEntity(neighbor)) instanceof KineticBlockEntity) {
            KineticBlockEntity be = (KineticBlockEntity)blockEntity;
            be.detachKinetics();
            be.attachKinetics();
        }
    }

    private BlockPos getBlockAttachedTo(BlockPos pos) {
        BlockPos.MutableBlockPos testPos = new BlockPos.MutableBlockPos();
        for (Direction direction : Iterate.directions) {
            testPos.setWithOffset((Vec3i)pos, direction);
            if (!this.isMultiBlockPart((BlockPos)testPos)) continue;
            return testPos;
        }
        return null;
    }

    @Override
    public float propagateRotationFrom(KineticBlockEntity target, BlockState stateFrom, BlockState stateTo, BlockPos diff, boolean connectedViaAxes, boolean connectedViaCogs) {
        return this.propagateRotationOf(target, stateFrom, stateTo, diff);
    }

    public float propagateRotationTo(KineticBlockEntity target, BlockState stateFrom, BlockState stateTo, BlockPos diff, boolean connectedViaAxes, boolean connectedViaCogs) {
        float ratio = this.propagateRotationOf(target, stateFrom, stateTo, diff);
        return ratio != 0.0f ? ratio : super.propagateRotationTo(target, stateFrom, stateTo, diff, connectedViaAxes, connectedViaCogs);
    }

    private float propagateRotationOf(KineticBlockEntity target, BlockState stateFrom, BlockState stateTo, BlockPos diff) {
        BlockPos pos = target.getBlockPos();
        if (this.isMultiBlockPart(target.getBlockPos())) {
            return 1.0f;
        }
        LargeFanBlockEntity controller = this.getControllerBE();
        if (controller == null) {
            return 0.0f;
        }
        BlockPos chain = controller.chain;
        if (chain != null && !(this.level.getBlockState(controller.chain).getBlock() instanceof ChainDriveBlock)) {
            chain = null;
        }
        if (chain == null && stateTo.getBlock() instanceof ChainDriveBlock && stateTo.getValue((Property)ChainDriveBlock.AXIS) == stateFrom.getValue(LargeFanBlock.AXIS) && LargeFanBlockEntity.getFirstAxisBetween(BlockPos.ZERO, diff) != stateTo.getValue((Property)ChainDriveBlock.AXIS)) {
            chain = pos;
        }
        if (!Objects.equals(chain, controller.chain)) {
            controller.chain = chain;
            controller.sendData();
        }
        if (pos.equals((Object)chain)) {
            return 1.0f;
        }
        return 0.0f;
    }

    public int getExtraSealedVolume() {
        if (this.getSpeed() == 0.0f || !this.isController()) {
            return 0;
        }
        return (int)Math.round((Math.log(this.blades) / Math.log(2.0) + 1.0) * Math.pow(this.width, (Double)NorthstarConfigs.server().largeFanSizeExponent.get()) * (double)Math.abs(this.effectiveSpeed.getValue()) * (Double)NorthstarConfigs.server().largeFanMultiplier.get());
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        if (!this.isController()) {
            LargeFanBlockEntity controller = this.getControllerBE();
            if (controller != null) {
                return controller.addToGoggleTooltip(tooltip, isPlayerSneaking);
            }
            return false;
        }
        CreateLang.translate((String)"gui.goggles.kinetic_stats", (Object[])new Object[0]).forGoggles(tooltip);
        this.addStressImpactStats(tooltip, this.calculateStressApplied() * (float)this.width * (float)this.width);
        if (this.blades < 2) {
            NorthstarLang.translate("gui.goggles.large_fan.not_enough_blades", new Object[0]).style(ChatFormatting.RED).forGoggles(tooltip);
        } else {
            NorthstarLang.translate("gui.goggles.large_fan.added_volume", new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
            CreateLang.number((double)this.getExtraSealedVolume()).style(ChatFormatting.BLUE).text(" ").add(NorthstarLang.blocks(this.getExtraSealedVolume()).style(ChatFormatting.GRAY)).forGoggles(tooltip, 1);
        }
        return true;
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(compound, registries, clientPacket);
        this.updateConnectivity = compound.contains("Uninitialized");
        this.controllerPos = null;
        if (compound.contains("Controller")) {
            this.controllerPos = NBTHelper.readBlockPos((CompoundTag)compound, (String)"Controller");
        }
        this.lastKnownPos = null;
        if (compound.contains("LastKnownPos")) {
            this.lastKnownPos = NBTHelper.readBlockPos((CompoundTag)compound, (String)"LastKnownPos");
        }
        this.width = compound.getInt("Width");
        this.height = compound.getInt("Height");
        if (this.width > this.getMaxWidth() || compound.contains("MaxWidth") && compound.getInt("MaxWidth") != this.getMaxWidth()) {
            this.updateConnectivity = true;
        }
        this.chain = compound.contains("Chain") ? NBTHelper.readBlockPos((CompoundTag)compound, (String)"Chain") : null;
        this.flipChain = compound.getBoolean("FlipChain");
        this.blades = compound.getInt("Blades");
        this.effectiveSpeed.readNBT(compound.getCompound("EffectiveSpeed"), clientPacket);
        this.updateNeighbors = true;
        this.invalidateRenderBoundingBox();
    }

    protected void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(compound, registries, clientPacket);
        if (this.updateConnectivity) {
            compound.putBoolean("Uninitialized", true);
        }
        if (this.controllerPos != null) {
            compound.put("Controller", NbtUtils.writeBlockPos((BlockPos)this.controllerPos));
        }
        if (this.lastKnownPos != null) {
            compound.put("LastKnownPos", NbtUtils.writeBlockPos((BlockPos)this.lastKnownPos));
        }
        if (!clientPacket) {
            compound.putInt("MaxWidth", this.getMaxWidth());
        }
        compound.putInt("Width", this.width);
        compound.putInt("Height", this.height);
        if (this.chain != null) {
            compound.put("Chain", NbtUtils.writeBlockPos((BlockPos)this.chain));
        }
        compound.putBoolean("FlipChain", this.flipChain);
        compound.putInt("Blades", this.blades);
        compound.put("EffectiveSpeed", (Tag)this.effectiveSpeed.writeNBT());
    }

    protected void updateConnectivity() {
        this.updateConnectivity = false;
        if (this.level.isClientSide) {
            return;
        }
        if (!this.isController()) {
            return;
        }
        if (this.width > this.getMaxWidth()) {
            ConnectivityHandler.splitMulti((BlockEntity)this);
        }
        ConnectivityHandler.formMulti((BlockEntity)this);
    }

    public BlockPos getController() {
        return this.isController() ? this.worldPosition : this.controllerPos;
    }

    public LargeFanBlockEntity getControllerBE() {
        if (this.isController() || !this.hasLevel()) {
            return this;
        }
        BlockEntity blockEntity = this.level.getBlockEntity(this.controllerPos);
        if (blockEntity instanceof LargeFanBlockEntity) {
            LargeFanBlockEntity fan = (LargeFanBlockEntity)blockEntity;
            return fan;
        }
        return null;
    }

    public boolean isController() {
        return this.controllerPos == null || this.controllerPos.equals((Object)this.worldPosition);
    }

    public void setController(BlockPos pos) {
        this.controllerPos = pos;
    }

    public void removeController(boolean keepContents) {
        if (this.level.isClientSide) {
            return;
        }
        this.controllerPos = null;
        this.updateConnectivity = true;
        this.width = 1;
        this.height = 1;
        this.invalidateRenderBoundingBox();
        this.updateBlockState(22);
        this.setChanged();
        this.sendData();
    }

    public BlockPos getLastKnownPos() {
        return this.lastKnownPos;
    }

    public void preventConnectivityUpdate() {
        this.updateConnectivity = false;
    }

    public void notifyMultiUpdated() {
        this.updateBlockState(6);
        this.invalidateRenderBoundingBox();
        if (!this.isController()) {
            LargeFanBlockEntity controller = this.getControllerBE();
            if (controller != null) {
                int transferred = Math.min(8 - controller.blades, this.blades);
                controller.blades += transferred;
                this.blades -= transferred;
            }
            this.dropBlades();
        }
        this.chain = null;
        this.detachKinetics();
        this.attachKinetics();
        this.setChanged();
    }

    private void dropBlades() {
        if (this.blades != 0) {
            Block.popResource((Level)this.level, (BlockPos)this.worldPosition, (ItemStack)NorthstarItems.FAN_BLADE.asStack(this.blades));
            this.blades = 0;
        }
    }

    public Direction.Axis getMainConnectionAxis() {
        return this.getAxis();
    }

    public int getMaxLength(Direction.Axis longAxis, int width) {
        if (longAxis == this.getAxis()) {
            return 1;
        }
        return this.getMaxWidth();
    }

    public int getMaxWidth() {
        return (Integer)NorthstarConfigs.server().largeFanMaxSize.get();
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public Direction.Axis getAxis() {
        return (Direction.Axis)this.getBlockState().getValue(LargeFanBlock.AXIS);
    }

    public int getVolumeX() {
        return this.getAxis() == Direction.Axis.X ? this.height : this.width;
    }

    public int getVolumeY() {
        return this.getAxis() == Direction.Axis.Y ? this.height : this.width;
    }

    public int getVolumeZ() {
        return this.getAxis() == Direction.Axis.Z ? this.height : this.width;
    }

    private void updateBlockState(int update) {
        Direction.Axis axis = this.getAxis();
        Predicate<Direction> connected = dir -> this.isMultiBlockPart(this.worldPosition.relative(dir));
        TenPatch patch = TenPatch.pickPatch(axis, connected);
        this.level.setBlock(this.worldPosition, (BlockState)this.getBlockState().setValue(LargeFanBlock.PATCH, (Comparable)((Object)patch)), update);
    }

    private boolean isMultiBlockPart(BlockPos pos) {
        BlockPos controller = this.getController();
        return pos.getX() >= controller.getX() && pos.getX() < controller.getX() + this.getVolumeX() && pos.getY() >= controller.getY() && pos.getY() < controller.getY() + this.getVolumeY() && pos.getZ() >= controller.getZ() && pos.getZ() < controller.getZ() + this.getVolumeZ();
    }

    private static List<Vec3i> getEdges(Direction.Axis axis, int width, int height) {
        Vec3i step1 = axis == Direction.Axis.X ? new Vec3i(0, 1, 0) : new Vec3i(1, 0, 0);
        Vec3i step2 = axis == Direction.Axis.Z ? new Vec3i(0, 1, 0) : new Vec3i(0, 0, 1);
        Vec3i axisDir = Direction.get((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis).getNormal();
        ArrayList<Vec3i> corners = new ArrayList<Vec3i>();
        for (int i = 0; i < height; ++i) {
            Vec3i step = axisDir.multiply(i);
            Vec3i corner1 = step2.multiply(-1).offset(step);
            Vec3i corner2 = step1.multiply(-1).offset(step);
            Vec3i corner3 = step2.multiply(width).offset(step);
            Vec3i corner4 = step1.multiply(width).offset(step);
            for (int j = 0; j < width; ++j) {
                corners.add(corner1);
                corners.add(corner2);
                corners.add(corner3);
                corners.add(corner4);
                corner1 = corner1.offset(step1);
                corner2 = corner2.offset(step2);
                corner3 = corner3.offset(step1);
                corner4 = corner4.offset(step2);
            }
        }
        return corners;
    }

    private static Direction.Axis getFirstAxisBetween(BlockPos pos1, BlockPos pos2) {
        if (pos1.getX() != pos2.getX()) {
            return Direction.Axis.X;
        }
        if (pos1.getY() != pos2.getY()) {
            return Direction.Axis.Y;
        }
        if (pos1.getZ() != pos2.getZ()) {
            return Direction.Axis.Z;
        }
        return null;
    }
}

