/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.tech.large_fan;

import com.lightning.northstar.block.tech.large_fan.LargeFanBlockEntity;
import com.lightning.northstar.block.tech.large_fan.TenPatch;
import com.lightning.northstar.content.NorthstarBlockEntityTypes;
import com.lightning.northstar.content.NorthstarItems;
import com.lightning.northstar.world.sealer.SealableBlock;
import com.lightning.northstar.world.sealer.SealerExtensionSource;
import com.lightning.northstar.world.sealer.SealingMode;
import com.simibubi.create.api.connectivity.ConnectivityHandler;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.kinetics.base.KineticBlock;
import com.simibubi.create.foundation.block.IBE;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class LargeFanBlock
extends KineticBlock
implements IBE<LargeFanBlockEntity>,
IWrenchable,
SealerExtensionSource,
SealableBlock {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.AXIS;
    public static final EnumProperty<TenPatch> PATCH = TenPatch.PROPERTY;

    public LargeFanBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue(AXIS, (Comparable)Direction.Axis.Z)).setValue(PATCH, (Comparable)((Object)TenPatch.SINGLE)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder.add(new Property[]{AXIS, PATCH}));
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = super.getStateForPlacement(context);
        return (BlockState)(state == null ? this.defaultBlockState() : state).setValue(AXIS, (Comparable)context.getNearestLookingDirection().getAxis());
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getOcclusionShape(BlockState state, BlockGetter level, BlockPos pos) {
        return Shapes.empty();
    }

    public float getShadeBrightness(BlockState state, BlockGetter level, BlockPos pos) {
        return 1.0f;
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter level, BlockPos pos) {
        return true;
    }

    protected ItemInteractionResult useItemOn(ItemStack heldItem, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        LargeFanBlockEntity be = (LargeFanBlockEntity)this.getBlockEntity((BlockGetter)level, pos);
        if (be != null && !be.isController()) {
            be = be.getControllerBE();
        }
        if (be == null) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (!heldItem.isEmpty() && heldItem.getItem() == NorthstarItems.FAN_BLADE.asItem() && hitResult.getDirection().getAxis() == state.getValue(AXIS)) {
            if (be.blades < 8) {
                ++be.blades;
                be.sendData();
                if (!player.isCreative()) {
                    heldItem.setCount(heldItem.getCount() - 1);
                }
                player.setItemInHand(hand, heldItem);
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return super.useItemOn(heldItem, state, level, pos, player, hand, hitResult);
    }

    public void onPlace(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.onPlace(state, world, pos, oldState, isMoving);
        if (oldState.getBlock() == state.getBlock()) {
            return;
        }
        if (isMoving) {
            return;
        }
        this.withBlockEntityDo((BlockGetter)world, pos, LargeFanBlockEntity::updateConnectivity);
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.is(newState.getBlock()) && newState.hasBlockEntity()) {
            return;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof LargeFanBlockEntity) {
            LargeFanBlockEntity be = (LargeFanBlockEntity)blockEntity;
            be.destroy();
            level.removeBlockEntity(pos);
            ConnectivityHandler.splitMulti((BlockEntity)be);
        }
    }

    public void onNeighborChange(BlockState state, LevelReader level, BlockPos pos, BlockPos neighbor) {
        super.onNeighborChange(state, level, pos, neighbor);
        Direction modifiedDirection = Direction.fromDelta((int)(neighbor.getX() - pos.getX()), (int)(neighbor.getY() - pos.getY()), (int)(neighbor.getZ() - pos.getZ()));
        if (modifiedDirection == null || modifiedDirection.getAxis() == state.getValue(AXIS)) {
            return;
        }
        this.withBlockEntityDo((BlockGetter)level, pos, be -> {
            LargeFanBlockEntity controller = be.getControllerBE();
            if (controller == null) {
                return;
            }
            controller.onNeighborChange(neighbor, false);
        });
    }

    @Override
    public int getMaximumSealedBlocks(Level level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof LargeFanBlockEntity) {
            LargeFanBlockEntity be = (LargeFanBlockEntity)blockEntity;
            return be.isController() ? be.getExtraSealedVolume() : 0;
        }
        return 0;
    }

    @Override
    public boolean northstar$isFaceSealed(BlockGetter level, BlockPos pos, BlockState state, Direction direction, boolean source, SealingMode mode) {
        Direction.Axis axis = (Direction.Axis)state.getValue(AXIS);
        if (axis == direction.getAxis()) {
            return false;
        }
        TenPatch patch = (TenPatch)((Object)state.getValue(PATCH));
        return switch (patch.type) {
            case TenPatch.PatchType.CENTER -> false;
            case TenPatch.PatchType.SIDE -> {
                if (direction == patch.getDirection(axis)) {
                    yield true;
                }
                yield false;
            }
            case TenPatch.PatchType.CORNER -> {
                Direction dir = patch.getDirection(axis);
                if (direction != dir && direction != dir.getCounterClockWise(axis)) {
                    yield true;
                }
                yield false;
            }
            default -> true;
        };
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        return this.onBlockEntityUse((BlockGetter)context.getLevel(), context.getClickedPos(), be -> {
            if (!be.isController()) {
                be = be.getControllerBE();
            }
            if (be == null) {
                return InteractionResult.PASS;
            }
            be.flipChain = !be.flipChain;
            be.sendData();
            return InteractionResult.SUCCESS;
        });
    }

    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Player player = context.getPlayer();
        return this.onBlockEntityUse((BlockGetter)context.getLevel(), context.getClickedPos(), be -> {
            if (!be.isController()) {
                be = be.getControllerBE();
            }
            if (be == null || be.blades == 0) {
                return super.onSneakWrenched(state, context);
            }
            IWrenchable.playRemoveSound((Level)world, (BlockPos)pos);
            --be.blades;
            be.sendData();
            if (player == null) {
                LargeFanBlock.popResource((Level)world, (BlockPos)pos, (ItemStack)NorthstarItems.FAN_BLADE.asStack());
            } else {
                player.getInventory().placeItemBackInInventory(NorthstarItems.FAN_BLADE.asStack());
            }
            return InteractionResult.SUCCESS;
        });
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return (Direction.Axis)state.getValue(AXIS);
    }

    public Class<LargeFanBlockEntity> getBlockEntityClass() {
        return LargeFanBlockEntity.class;
    }

    public BlockEntityType<? extends LargeFanBlockEntity> getBlockEntityType() {
        return (BlockEntityType)NorthstarBlockEntityTypes.LARGE_FAN.get();
    }
}

