/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.tech.jet_engine;

import com.lightning.northstar.block.tech.jet_engine.JetEngineBlock;
import com.lightning.northstar.contraption.rocket.RocketContraption;
import com.lightning.northstar.contraption.rocket.RocketContraptionEntity;
import com.lightning.northstar.particle.NorthstarParticles;
import com.simibubi.create.api.behaviour.movement.MovementBehaviour;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import net.minecraft.client.Minecraft;
import net.minecraft.client.ParticleStatus;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class JetEngineMovementBehaviour
implements MovementBehaviour {
    public ItemStack canBeDisabledVia(MovementContext context) {
        return null;
    }

    public void tick(MovementContext context) {
        if (!context.world.isClientSide() || ((Boolean)context.state.getValue((Property)JetEngineBlock.BOTTOM)).booleanValue()) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        ParticleStatus status = (ParticleStatus)mc.options.particles().get();
        if (status == ParticleStatus.MINIMAL) {
            return;
        }
        RandomSource r = context.world.getRandom();
        Contraption contraption = context.contraption;
        if (contraption instanceof RocketContraption) {
            RocketContraption rc = (RocketContraption)contraption;
            RocketContraptionEntity rce = (RocketContraptionEntity)context.contraption.entity;
            if (rce.lift_vel > 0.0f) {
                Vec3 v = context.position;
                if (rce.blasting) {
                    if (status == ParticleStatus.ALL && r.nextInt(8) == 0) {
                        context.world.addAlwaysVisibleParticle((ParticleOptions)NorthstarParticles.ROCKET_SMOKE.get(), v.x, v.y, v.z, 0.0, 0.0, 0.0);
                    } else if (r.nextInt(5) == 0) {
                        context.world.addAlwaysVisibleParticle((ParticleOptions)NorthstarParticles.ROCKET_FLAME.get(), v.x, v.y, v.z, 0.0, 0.0, 0.0);
                    }
                } else if (status == ParticleStatus.ALL && r.nextInt(8) == 0) {
                    context.world.addParticle((ParticleOptions)NorthstarParticles.COLD_AIR.get(), v.x, v.y, v.z, 0.0, 0.0, 0.0);
                }
            } else if (rce.landingMode && rce.lift_vel < 0.0f && context.contraption.entity.getY() < rce.getSlowdownHeightThreshold()) {
                Vec3 v = context.position;
                if (rce.slowing) {
                    if (status == ParticleStatus.ALL && r.nextInt(3) == 0) {
                        context.world.addAlwaysVisibleParticle((ParticleOptions)NorthstarParticles.ROCKET_SMOKE_LANDING.get(), v.x, v.y - 2.0, v.z, 0.0, 0.0, 0.0);
                    } else if ((double)r.nextFloat() < 0.6) {
                        context.world.addAlwaysVisibleParticle((ParticleOptions)NorthstarParticles.ROCKET_FLAME_LANDING.get(), v.x, v.y - 2.0, v.z, 0.0, 0.0, 0.0);
                    }
                }
            }
        } else if (status == ParticleStatus.ALL) {
            Vec3 v = context.position;
            if (r.nextInt(8) == 0) {
                context.world.addParticle((ParticleOptions)NorthstarParticles.COLD_AIR.get(), v.x, v.y, v.z, 0.0, 0.0, 0.0);
            }
        }
    }
}

