/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.tech.ice_box;

import com.lightning.northstar.block.tech.ice_box.FreezingRecipe;
import com.lightning.northstar.block.tech.ice_box.IceBoxBlock;
import com.lightning.northstar.content.NorthstarBlockEntityTypes;
import com.lightning.northstar.content.NorthstarRecipeTypes;
import com.lightning.northstar.util.NorthstarLang;
import com.lightning.northstar.world.temperature.NorthstarTemperature;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.SyncedBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.inventory.InvManipulationBehaviour;
import com.simibubi.create.foundation.fluid.CombinedTankWrapper;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.item.SmartInventory;
import com.simibubi.create.foundation.recipe.RecipeFinder;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.createmod.catnip.data.IntAttached;
import net.createmod.catnip.lang.LangBuilder;
import net.createmod.catnip.math.VecHelper;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.wrapper.CombinedInvWrapper;

public class IceBoxBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation {
    private static final Object FREEZING_RECIPES_KEY = new Object();
    public static final int OUTPUT_ANIMATION_TIME = 10;
    protected SmartInventory inputInventory = new SmartInventory(9, (SyncedBlockEntity)this, 16, true);
    protected SmartInventory outputInventory;
    protected SmartFluidTankBehaviour inputTank;
    protected SmartFluidTankBehaviour outputTank;
    protected FilteringBehaviour filtering;
    protected IItemHandlerModifiable itemCapability;
    protected IFluidHandler fluidCapability;
    protected boolean contentsChanged;
    protected Recipe<?> currentRecipe;
    protected int processingTicks;
    protected List<IntAttached<ItemStack>> visualizedOutputItems;
    protected List<IntAttached<FluidStack>> visualizedOutputFluids;

    public IceBoxBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.inputInventory.whenContentsChanged($ -> {
            this.contentsChanged = true;
        });
        this.outputInventory = new SmartInventory(9, (SyncedBlockEntity)this, 16, true).forbidInsertion().withMaxStackSize(64);
        this.contentsChanged = true;
        this.itemCapability = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inputInventory, this.outputInventory});
        this.visualizedOutputFluids = Collections.synchronizedList(new ArrayList());
        this.visualizedOutputItems = Collections.synchronizedList(new ArrayList());
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)NorthstarBlockEntityTypes.ICE_BOX.get(), (be, face) -> be.itemCapability);
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)NorthstarBlockEntityTypes.ICE_BOX.get(), (be, face) -> be.fluidCapability);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        behaviours.add((BlockEntityBehaviour)new DirectBeltInputBehaviour((SmartBlockEntity)this));
        this.filtering = new FilteringBehaviour((SmartBlockEntity)this, (ValueBoxTransform)new IceBoxValueBox()).withCallback($ -> {
            this.contentsChanged = true;
        }).forRecipes();
        behaviours.add((BlockEntityBehaviour)this.filtering);
        this.inputTank = new SmartFluidTankBehaviour(SmartFluidTankBehaviour.INPUT, (SmartBlockEntity)this, 2, 1000, true).whenFluidUpdates(() -> {
            this.contentsChanged = true;
        });
        behaviours.add((BlockEntityBehaviour)this.inputTank);
        this.outputTank = new SmartFluidTankBehaviour(SmartFluidTankBehaviour.OUTPUT, (SmartBlockEntity)this, 2, 1000, true).whenFluidUpdates(() -> {
            this.contentsChanged = true;
        }).forbidInsertion();
        behaviours.add((BlockEntityBehaviour)this.outputTank);
        this.fluidCapability = new CombinedTankWrapper(new IFluidHandler[]{this.outputTank.getCapability(), this.inputTank.getCapability()});
    }

    public void destroy() {
        super.destroy();
        ItemHelper.dropContents((Level)this.level, (BlockPos)this.worldPosition, (IItemHandler)this.inputInventory);
        ItemHelper.dropContents((Level)this.level, (BlockPos)this.worldPosition, (IItemHandler)this.outputInventory);
    }

    public void tick() {
        Recipe<?> recipe;
        super.tick();
        if (this.level.isClientSide) {
            return;
        }
        if (this.contentsChanged) {
            this.currentRecipe = this.getMatchingRecipe();
            this.contentsChanged = false;
        }
        if (!((recipe = this.currentRecipe) instanceof FreezingRecipe)) {
            return;
        }
        FreezingRecipe r = (FreezingRecipe)recipe;
        float currentTemperature = NorthstarTemperature.getTemperatureAt(this.level, (Vec3i)this.worldPosition);
        if (!r.isTemperatureWithinRange(currentTemperature)) {
            this.processingTicks = Math.max(0, this.processingTicks - 1);
            return;
        }
        if (++this.processingTicks >= r.getProcessingDuration() && FreezingRecipe.apply(this, r)) {
            this.processingTicks = 0;
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 2);
        }
    }

    public boolean acceptOutputs(List<ItemStack> outputItems, List<FluidStack> outputFluids, boolean simulate) {
        this.outputInventory.allowInsertion();
        this.outputTank.allowInsertion();
        boolean acceptOutputsInner = this.acceptOutputsInner(outputItems, outputFluids, simulate);
        this.outputInventory.forbidInsertion();
        this.outputTank.forbidInsertion();
        return acceptOutputsInner;
    }

    private boolean acceptOutputsInner(List<ItemStack> outputItems, List<FluidStack> outputFluids, boolean simulate) {
        BlockState blockState = this.getBlockState();
        if (!(blockState.getBlock() instanceof IceBoxBlock)) {
            return false;
        }
        Direction direction = (Direction)blockState.getValue((Property)IceBoxBlock.FACING);
        if (direction != Direction.DOWN) {
            boolean externalTankNotPresent;
            IItemHandler targetInv;
            BlockEntity be = this.level.getBlockEntity(this.worldPosition.below().relative(direction));
            InvManipulationBehaviour inserter = be == null ? null : (InvManipulationBehaviour)BlockEntityBehaviour.get((BlockGetter)this.level, (BlockPos)be.getBlockPos(), (BehaviourType)InvManipulationBehaviour.TYPE);
            IItemHandler iItemHandler = targetInv = be == null ? null : (IItemHandler)this.level.getCapability(Capabilities.ItemHandler.BLOCK, be.getBlockPos(), be.getBlockState(), be, (Object)direction.getOpposite());
            if (targetInv == null && inserter != null) {
                targetInv = (IItemHandler)inserter.getInventory();
            }
            IFluidHandler targetTank = be == null ? null : (IFluidHandler)this.level.getCapability(Capabilities.FluidHandler.BLOCK, be.getBlockPos(), be.getBlockState(), be, (Object)direction.getOpposite());
            boolean bl = externalTankNotPresent = targetTank == null;
            if (!outputItems.isEmpty() && targetInv == null) {
                return false;
            }
            if (!outputFluids.isEmpty() && externalTankNotPresent) {
                targetTank = this.outputTank.getCapability();
                if (targetTank == null) {
                    return false;
                }
                if (!this.acceptFluidOutputsIntoIceBox(outputFluids, simulate, targetTank)) {
                    return false;
                }
            }
            if (simulate) {
                return true;
            }
        }
        SmartInventory targetInv = this.outputInventory;
        IFluidHandler targetTank = this.outputTank.getCapability();
        if (targetInv == null && !outputItems.isEmpty()) {
            return false;
        }
        if (!this.acceptItemOutputsIntoIceBox(outputItems, simulate, (IItemHandler)targetInv)) {
            return false;
        }
        if (outputFluids.isEmpty()) {
            return true;
        }
        if (targetTank == null) {
            return false;
        }
        return this.acceptFluidOutputsIntoIceBox(outputFluids, simulate, targetTank);
    }

    private boolean acceptFluidOutputsIntoIceBox(List<FluidStack> outputFluids, boolean simulate, IFluidHandler targetTank) {
        for (FluidStack fluidStack : outputFluids) {
            IFluidHandler.FluidAction action = simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE;
            int fill = targetTank instanceof SmartFluidTankBehaviour.InternalFluidHandler ? ((SmartFluidTankBehaviour.InternalFluidHandler)targetTank).forceFill(fluidStack.copy(), action) : targetTank.fill(fluidStack.copy(), action);
            if (fill == fluidStack.getAmount()) continue;
            return false;
        }
        return true;
    }

    private boolean acceptItemOutputsIntoIceBox(List<ItemStack> outputItems, boolean simulate, IItemHandler targetInv) {
        for (ItemStack itemStack : outputItems) {
            if (ItemHandlerHelper.insertItemStacked((IItemHandler)targetInv, (ItemStack)itemStack.copy(), (boolean)simulate).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public float getTotalFluidUnits(float partialTicks) {
        float units;
        int renderedFluids = 0;
        float totalUnits = 0.0f;
        for (SmartFluidTankBehaviour.TankSegment tankSegment : this.inputTank.getTanks()) {
            if (tankSegment.getRenderedFluid().isEmpty() || (units = tankSegment.getTotalUnits(partialTicks)) < 1.0f) continue;
            totalUnits += units;
            ++renderedFluids;
        }
        for (SmartFluidTankBehaviour.TankSegment tankSegment : this.outputTank.getTanks()) {
            if (tankSegment.getRenderedFluid().isEmpty() || (units = tankSegment.getTotalUnits(partialTicks)) < 1.0f) continue;
            totalUnits += units;
            ++renderedFluids;
        }
        if (renderedFluids == 0) {
            return 0.0f;
        }
        if (totalUnits < 1.0f) {
            return 0.0f;
        }
        return totalUnits;
    }

    public boolean isEmpty() {
        return this.inputInventory.isEmpty() && this.inputTank.isEmpty() && this.outputInventory.isEmpty() && this.outputTank.isEmpty();
    }

    public SmartInventory getInputInventory() {
        return this.inputInventory;
    }

    protected Recipe<?> getMatchingRecipe() {
        if (this.isEmpty()) {
            return null;
        }
        return RecipeFinder.get((Object)FREEZING_RECIPES_KEY, (Level)this.level, this::matchStaticFilters).stream().filter(this::matchFreezingRecipe).map(RecipeHolder::value).min((r1, r2) -> r2.getIngredients().size() - r1.getIngredients().size()).orElse(null);
    }

    protected boolean matchStaticFilters(RecipeHolder<? extends Recipe<?>> recipe) {
        return recipe.value().getType() == NorthstarRecipeTypes.FREEZING.getType();
    }

    protected boolean matchFreezingRecipe(RecipeHolder<? extends Recipe<?>> recipe) {
        if (recipe == null) {
            return false;
        }
        return FreezingRecipe.match(this, recipe.value());
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(compound, registries, clientPacket);
        this.inputInventory.deserializeNBT(registries, compound.getCompound("InputItems"));
        this.outputInventory.deserializeNBT(registries, compound.getCompound("OutputItems"));
        if (!clientPacket) {
            return;
        }
        NBTHelper.iterateCompoundList((ListTag)compound.getList("VisualizedItems", 10), c -> this.visualizedOutputItems.add((IntAttached<ItemStack>)IntAttached.with((int)10, (Object)ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)c))));
        NBTHelper.iterateCompoundList((ListTag)compound.getList("VisualizedFluids", 10), c -> this.visualizedOutputFluids.add((IntAttached<FluidStack>)IntAttached.with((int)10, (Object)FluidStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)c))));
    }

    protected void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(compound, registries, clientPacket);
        compound.put("InputItems", (Tag)this.inputInventory.serializeNBT(registries));
        compound.put("OutputItems", (Tag)this.outputInventory.serializeNBT(registries));
        if (!clientPacket) {
            return;
        }
        compound.put("VisualizedItems", (Tag)NBTHelper.writeCompoundList(this.visualizedOutputItems, ia -> (CompoundTag)((ItemStack)ia.getValue()).save(registries)));
        compound.put("VisualizedFluids", (Tag)NBTHelper.writeCompoundList(this.visualizedOutputFluids, ia -> (CompoundTag)((FluidStack)ia.getValue()).save(registries, (Tag)new CompoundTag())));
        this.visualizedOutputItems.clear();
        this.visualizedOutputFluids.clear();
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        NorthstarLang.translate("gui.goggles.ice_box_contents", new Object[0]).forGoggles(tooltip);
        NorthstarLang.translate("gui.goggles.generic.temperature", new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        NorthstarLang.temperature(NorthstarTemperature.getTemperatureAt(this.level, (Vec3i)this.worldPosition)).forGoggles(tooltip, 1);
        IItemHandlerModifiable items = this.itemCapability;
        IFluidHandler fluids = this.fluidCapability;
        for (int i = 0; i < items.getSlots(); ++i) {
            ItemStack stackInSlot = items.getStackInSlot(i);
            if (stackInSlot.isEmpty()) continue;
            CreateLang.text((String)"").add(Component.translatable((String)stackInSlot.getDescriptionId()).withStyle(ChatFormatting.GRAY)).add(CreateLang.text((String)(" x" + stackInSlot.getCount())).style(ChatFormatting.GREEN)).forGoggles(tooltip, 1);
        }
        LangBuilder mb = CreateLang.translate((String)"generic.unit.millibuckets", (Object[])new Object[0]);
        for (int b = 0; b < fluids.getTanks(); ++b) {
            FluidStack stackInSlot = fluids.getFluidInTank(b);
            if (stackInSlot.isEmpty() || stackInSlot.getFluid().getFluidType().isAir()) continue;
            CreateLang.fluidName((FluidStack)stackInSlot).style(ChatFormatting.GRAY).forGoggles(tooltip);
            CreateLang.builder().add(CreateLang.number((double)stackInSlot.getAmount()).add(mb).style(ChatFormatting.GOLD)).text(ChatFormatting.GRAY, " / ").add(CreateLang.number((double)fluids.getTankCapacity(b)).add(mb).style(ChatFormatting.DARK_GRAY)).forGoggles(tooltip, 1);
        }
        return true;
    }

    private static class IceBoxValueBox
    extends ValueBoxTransform.Sided {
        private IceBoxValueBox() {
        }

        protected Vec3 getSouthLocation() {
            return VecHelper.voxelSpace((double)8.0, (double)12.0, (double)16.05);
        }

        protected boolean isSideActive(BlockState state, Direction direction) {
            return direction.getAxis().isHorizontal();
        }
    }
}

