/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.tech.computer_rack;

import com.lightning.northstar.block.tech.computer_rack.TargetingComputerRackBlockEntity;
import com.lightning.northstar.content.NorthstarBlockEntityTypes;
import com.lightning.northstar.content.NorthstarItems;
import com.lightning.northstar.content.NorthstarStats;
import com.simibubi.create.content.kinetics.base.HorizontalKineticBlock;
import com.simibubi.create.foundation.block.IBE;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class TargetingComputerRackBlock
extends HorizontalKineticBlock
implements IBE<TargetingComputerRackBlockEntity> {
    public TargetingComputerRackBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(HORIZONTAL_FACING, (Comparable)Direction.NORTH));
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        return this.use(state, level, pos, player, InteractionHand.MAIN_HAND, hitResult).result();
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        return this.use(state, level, pos, player, hand, hitResult);
    }

    private ItemInteractionResult use(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        Direction dir = (Direction)state.getValue(HORIZONTAL_FACING);
        if (hit.getDirection().getAxis() != dir.getAxis()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        Vec3 localPos = hit.getLocation().subtract(Vec3.atLowerCornerOf((Vec3i)pos));
        float x = switch (dir) {
            case Direction.NORTH -> (float)localPos.x;
            case Direction.SOUTH -> (float)(1.0 - localPos.x);
            case Direction.EAST -> (float)localPos.z;
            case Direction.WEST -> (float)(1.0 - localPos.z);
            default -> 0.0f;
        };
        float y = (float)localPos.y;
        int slot = (x < 0.33333334f ? 0 : (x < 0.6666667f ? 1 : 2)) + (y > 0.5f ? 3 : 0);
        return this.onBlockEntityUseItemOn((BlockGetter)level, pos, be -> {
            ItemStack computer = be.container.getItem(slot);
            if (computer.isEmpty()) {
                ItemStack held = player.getItemInHand(hand);
                if (!level.isClientSide && held.is((Item)NorthstarItems.TARGETING_COMPUTER.get())) {
                    be.container.setItem(slot, held.copyWithCount(1));
                    player.setItemInHand(hand, held.copyWithCount(held.getCount() - 1));
                    be.notifyUpdate();
                }
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if (!level.isClientSide) {
                player.awardStat(NorthstarStats.INTERACT_WITH_COMPUTER_RACK);
                if (!player.addItem(computer)) {
                    TargetingComputerRackBlock.popResourceFromFace((Level)level, (BlockPos)pos, (Direction)dir, (ItemStack)computer);
                }
                be.container.setItem(slot, ItemStack.EMPTY);
                be.notifyUpdate();
            }
            level.playSound(null, pos, SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.2f, 1.0f + level.random.nextFloat());
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        });
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return Direction.Axis.Y;
    }

    public Class<TargetingComputerRackBlockEntity> getBlockEntityClass() {
        return TargetingComputerRackBlockEntity.class;
    }

    public BlockEntityType<? extends TargetingComputerRackBlockEntity> getBlockEntityType() {
        return (BlockEntityType)NorthstarBlockEntityTypes.COMPUTER_RACK.get();
    }
}

