/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.tech.combustion_engine;

import com.lightning.northstar.block.tech.combustion_engine.CombustionEngineBlockEntity;
import com.lightning.northstar.content.NorthstarBlockEntityTypes;
import com.lightning.northstar.world.oxygen.OxygenConsumer;
import com.simibubi.create.content.kinetics.base.HorizontalKineticBlock;
import com.simibubi.create.foundation.block.IBE;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class CombustionEngineBlock
extends HorizontalKineticBlock
implements IBE<CombustionEngineBlockEntity>,
OxygenConsumer {
    protected static final VoxelShape SHAPE_AXIS_X = Block.box((double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)13.0, (double)14.0);
    protected static final VoxelShape SHAPE_AXIS_Z = Block.box((double)2.0, (double)0.0, (double)0.0, (double)14.0, (double)13.0, (double)16.0);

    public CombustionEngineBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return ((Direction)state.getValue(HORIZONTAL_FACING)).getAxis() == Direction.Axis.X ? SHAPE_AXIS_X : SHAPE_AXIS_Z;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction direction = context.getHorizontalDirection();
        Player player = context.getPlayer();
        return (BlockState)this.defaultBlockState().setValue(HORIZONTAL_FACING, (Comparable)(player != null && player.isCrouching() ? direction : direction.getOpposite()));
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return ((Direction)state.getValue(HORIZONTAL_FACING)).getAxis();
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return ((Direction)state.getValue(HORIZONTAL_FACING)).getOpposite() == face;
    }

    @Override
    public boolean northstar$isOxygenConsumptionDynamic(BlockGetter level, BlockPos pos) {
        return true;
    }

    @Override
    public float northstar$getOxygenConsumption(BlockGetter level, BlockPos pos, float base) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof CombustionEngineBlockEntity) {
            CombustionEngineBlockEntity be = (CombustionEngineBlockEntity)blockEntity;
            if (be.generatorSpeed != 0.0f && !be.isOverStressed()) {
                return base * 20.0f;
            }
        }
        return 0.0f;
    }

    public Class<CombustionEngineBlockEntity> getBlockEntityClass() {
        return CombustionEngineBlockEntity.class;
    }

    public BlockEntityType<? extends CombustionEngineBlockEntity> getBlockEntityType() {
        return (BlockEntityType)NorthstarBlockEntityTypes.COMBUSTION_ENGINE.get();
    }
}

