/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.tech.atmospheric_concentrator;

import com.lightning.northstar.block.tech.atmospheric_concentrator.AtmosphericConcentratorBlock;
import com.lightning.northstar.content.NorthstarBlockEntityTypes;
import com.lightning.northstar.content.NorthstarFluids;
import com.lightning.northstar.util.NorthstarLang;
import com.lightning.northstar.world.dimension.NorthstarDimensions;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class AtmosphericConcentratorBlockEntity
extends KineticBlockEntity
implements IHaveGoggleInformation {
    protected SmartFluidTankBehaviour tank;
    protected float buffer;

    public AtmosphericConcentratorBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.tank = SmartFluidTankBehaviour.single((SmartBlockEntity)this, (int)1000).forbidInsertion();
        behaviours.add((BlockEntityBehaviour)this.tank);
    }

    public void tick() {
        super.tick();
        Fluid fluid = this.getCollectedFluid();
        float speed = this.getCollectionSpeed();
        if (fluid == Fluids.EMPTY || Mth.equal((float)speed, (float)0.0f)) {
            return;
        }
        float newBuffer = this.buffer + speed;
        int filled = Mth.floor((float)newBuffer);
        this.buffer = newBuffer - (float)filled;
        this.tank.getPrimaryHandler().fill(new FluidStack(fluid, filled), IFluidHandler.FluidAction.EXECUTE);
    }

    public Fluid getCollectedFluid() {
        ResourceKey dimension = this.level.dimension();
        if (dimension.equals(Level.OVERWORLD)) {
            return NorthstarFluids.OXYGEN.getSource();
        }
        if (dimension.equals(NorthstarDimensions.MARS_DIM_KEY) || dimension.equals(NorthstarDimensions.VENUS_DIM_KEY)) {
            return NorthstarFluids.CARBON.getSource();
        }
        return Fluids.EMPTY;
    }

    public float getCollectionSpeed() {
        return Math.abs(this.speed) / 25.6f;
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        Fluid fluid;
        NorthstarLang.translate("gui.goggles.atmospheric_concentrator", new Object[0]).forGoggles(tooltip);
        if (IRotate.StressImpact.isEnabled()) {
            this.addStressImpactStats(tooltip, this.calculateStressApplied());
        }
        if ((fluid = this.getCollectedFluid()) == Fluids.EMPTY) {
            NorthstarLang.translate("gui.goggles.atmospheric_concentrator.no_atmosphere", new Object[0]).style(ChatFormatting.RED).forGoggles(tooltip);
        } else {
            NorthstarLang.translate("gui.goggles.atmospheric_concentrator.collected_fluid", new Object[0]).style(ChatFormatting.GRAY).add(CreateLang.fluidName((FluidStack)new FluidStack(fluid, 1))).forGoggles(tooltip);
            CreateLang.builder().add(CreateLang.number((double)this.tank.getPrimaryHandler().getFluidAmount()).add(NorthstarLang.MB).style(ChatFormatting.GOLD)).text(ChatFormatting.GRAY, " / ").add(CreateLang.number((double)this.tank.getPrimaryHandler().getCapacity()).add(NorthstarLang.MB).style(ChatFormatting.DARK_GRAY)).forGoggles(tooltip, 1);
            NorthstarLang.translate("gui.goggles.atmospheric_concentrator.collection_rate", new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
            CreateLang.number((double)this.getCollectionSpeed()).add(NorthstarLang.MB_PER_TICK).style(ChatFormatting.GOLD).forGoggles(tooltip, 1);
        }
        return true;
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)NorthstarBlockEntityTypes.ATMOSPHERIC_CONCENTRATOR.get(), (be, face) -> {
            if (face == null || face == ((Direction)be.getBlockState().getValue(AtmosphericConcentratorBlock.HORIZONTAL_FACING)).getOpposite()) {
                return be.tank.getCapability();
            }
            return null;
        });
    }
}

