/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.tech.astronomy_table;

import com.lightning.northstar.block.tech.astronomy_table.AstronomyTableBlockEntity;
import com.lightning.northstar.content.NorthstarDataComponents;
import com.lightning.northstar.content.NorthstarItems;
import com.lightning.northstar.content.NorthstarMenuTypes;
import com.simibubi.create.foundation.gui.menu.MenuBase;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;

public class AstronomyTableMenu
extends MenuBase<AstronomyTableBlockEntity> {
    public Component errorMessage;
    protected SimpleContainer inputSlots;
    protected ResultContainer resultSlots;

    public AstronomyTableMenu(MenuType<AstronomyTableMenu> type, int id, Inventory inv, RegistryFriendlyByteBuf extraData) {
        super(type, id, inv, extraData);
    }

    public AstronomyTableMenu(MenuType<?> type, int id, Inventory inv, AstronomyTableBlockEntity contentHolder) {
        super(type, id, inv, (Object)contentHolder);
    }

    public static AstronomyTableMenu create(int id, Inventory inv, AstronomyTableBlockEntity be) {
        return new AstronomyTableMenu((MenuType)NorthstarMenuTypes.ASTRONOMY_TABLE_MENU.get(), id, inv, be);
    }

    protected AstronomyTableBlockEntity createOnClient(RegistryFriendlyByteBuf extraData) {
        BlockEntity blockEntity = Minecraft.getInstance().level.getBlockEntity(extraData.readBlockPos());
        if (blockEntity instanceof AstronomyTableBlockEntity) {
            AstronomyTableBlockEntity be = (AstronomyTableBlockEntity)blockEntity;
            return be;
        }
        return null;
    }

    protected void initAndReadInventory(AstronomyTableBlockEntity contentHolder) {
        this.inputSlots = new SimpleContainer(3);
        this.resultSlots = new ResultContainer();
        this.inputSlots.addListener(container -> this.updateResult());
    }

    protected void addSlots() {
        class InputSlot
        extends Slot {
            public InputSlot(AstronomyTableMenu this$0, Container container, int slot, int x, int y) {
                super(container, slot, x, y);
            }

            public boolean mayPlace(ItemStack stack) {
                return stack.is((Item)NorthstarItems.ASTRONOMICAL_READING.get());
            }
        }
        this.addSlot(new InputSlot(this, (Container)this.inputSlots, 0, 24, 47));
        this.addSlot(new InputSlot(this, (Container)this.inputSlots, 1, 80, 47));
        this.addSlot(new InputSlot(this, (Container)this.inputSlots, 2, 52, 27));
        this.addSlot(new Slot((Container)this.resultSlots, 3, 134, 47){

            public boolean mayPlace(ItemStack stack) {
                return false;
            }

            public void onTake(Player player, ItemStack stack) {
                for (int i = 0; i < 3; ++i) {
                    AstronomyTableMenu.this.inputSlots.getItem(i).setCount(AstronomyTableMenu.this.inputSlots.getItem(i).getCount() - 1);
                }
                player.level().playSound(player, ((AstronomyTableBlockEntity)((Object)AstronomyTableMenu.this.contentHolder)).getBlockPos(), SoundEvents.UI_CARTOGRAPHY_TABLE_TAKE_RESULT, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        });
        this.addPlayerSlots(8, 84);
    }

    protected void saveData(AstronomyTableBlockEntity contentHolder) {
    }

    public void removed(Player player) {
        super.removed(player);
        this.clearContainer(player, (Container)this.inputSlots);
        this.resultSlots.clearContent();
    }

    public void updateResult() {
        this.errorMessage = null;
        this.resultSlots.clearContent();
        ItemStack item1 = this.inputSlots.getItem(0);
        ItemStack item2 = this.inputSlots.getItem(1);
        ItemStack item3 = this.inputSlots.getItem(2);
        String planet1 = (String)item1.get(NorthstarDataComponents.PLANET);
        String planet2 = (String)item2.get(NorthstarDataComponents.PLANET);
        String planet3 = (String)item3.get(NorthstarDataComponents.PLANET);
        if (planet1 == null || planet2 == null || planet3 == null) {
            return;
        }
        if (!planet1.equals(planet2) || !planet1.equals(planet3)) {
            this.errorMessage = Component.translatable((String)"northstar.gui.astronomy_table.different_planets");
            return;
        }
        if (!this.arePlanetsFarEnough(item1, item2, item3)) {
            this.errorMessage = Component.translatable((String)"northstar.gui.astronomy_table.close_data");
            return;
        }
        ItemStack result = new ItemStack((ItemLike)NorthstarItems.STAR_MAP.get());
        result.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)("item.northstar.star_map_" + planet1)).setStyle(Style.EMPTY.withColor(ChatFormatting.AQUA).withItalic(Boolean.valueOf(false))));
        result.set(NorthstarDataComponents.PLANET, (Object)planet1);
        this.resultSlots.setItem(0, result);
    }

    private boolean arePlanetsFarEnough(ItemStack item1, ItemStack item2, ItemStack item3) {
        double r3;
        double r2;
        int x1 = (Integer)item1.get(NorthstarDataComponents.PLANET_X);
        int y1 = (Integer)item1.get(NorthstarDataComponents.PLANET_Y);
        int x2 = (Integer)item2.get(NorthstarDataComponents.PLANET_X);
        int y2 = (Integer)item2.get(NorthstarDataComponents.PLANET_Y);
        int x3 = (Integer)item3.get(NorthstarDataComponents.PLANET_X);
        int y3 = (Integer)item3.get(NorthstarDataComponents.PLANET_Y);
        double r1 = Math.sqrt(Math.pow(x2 - x1, 2.0) + Math.pow(y2 - y1, 2.0));
        double averageDistance = (r1 + (r2 = Math.sqrt(Math.pow(x3 - x2, 2.0) + Math.pow(y3 - y2, 2.0))) + (r3 = Math.sqrt(Math.pow(x1 - x3, 2.0) + Math.pow(y1 - y3, 2.0)))) / 3.0;
        return Math.abs(averageDistance) > 30.0;
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (index == 3) {
                if (!this.moveItemStackTo(itemstack1, 4, 40, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(itemstack1, itemstack);
            } else if (index != 0 && index != 1 && index != 2) {
                if (index >= 4 && index < 40) {
                    int i = -1;
                    if (((Slot)this.slots.get(0)).getItem() == ItemStack.EMPTY && i == -1) {
                        i = 0;
                    }
                    if (((Slot)this.slots.get(2)).getItem() == ItemStack.EMPTY && i == -1) {
                        i = 2;
                    }
                    if (((Slot)this.slots.get(1)).getItem() == ItemStack.EMPTY && i == -1) {
                        i = 1;
                    }
                    if (i != -1 && !this.moveItemStackTo(itemstack1, i, 3, false)) {
                        return ItemStack.EMPTY;
                    }
                }
            } else if (!this.moveItemStackTo(itemstack1, 4, 40, false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, itemstack1);
        }
        return itemstack;
    }
}

