/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.simple;

import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import org.jetbrains.annotations.NotNull;

public enum VerticalSlabType implements StringRepresentable
{
    NORTH("north"),
    WEST("west"),
    EAST("east"),
    SOUTH("south"),
    DOUBLE("double");

    public static final VerticalSlabType[] ALL;
    private final String name;

    private VerticalSlabType(String name) {
        this.name = name;
    }

    public static Direction toDir(VerticalSlabType type) {
        return switch (type.ordinal()) {
            case 3 -> Direction.SOUTH;
            case 2 -> Direction.EAST;
            case 1 -> Direction.WEST;
            default -> Direction.NORTH;
        };
    }

    public static VerticalSlabType fromDir(Direction dir) {
        return switch (dir) {
            case Direction.SOUTH -> SOUTH;
            case Direction.EAST -> EAST;
            case Direction.WEST -> WEST;
            default -> NORTH;
        };
    }

    @NotNull
    public String getSerializedName() {
        return this.name;
    }

    static {
        ALL = VerticalSlabType.values();
    }
}

