/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.simple;

import com.lightning.northstar.block.simple.VerticalSlabType;
import com.mojang.serialization.MapCodec;
import com.simibubi.create.foundation.block.ProperWaterloggedBlock;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class VerticalSlabBlock
extends Block
implements ProperWaterloggedBlock {
    public static final MapCodec<VerticalSlabBlock> CODEC = VerticalSlabBlock.simpleCodec(VerticalSlabBlock::new);
    public static final EnumProperty<VerticalSlabType> TYPE = EnumProperty.create((String)"type", VerticalSlabType.class);
    protected static final VoxelShape NORTH_SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
    protected static final VoxelShape SOUTH_SHAPE = Block.box((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape EAST_SHAPE = Block.box((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape WEST_SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0);

    public VerticalSlabBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue(TYPE, (Comparable)((Object)VerticalSlabType.NORTH))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends Block> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder.add(new Property[]{TYPE, WATERLOGGED}));
    }

    public boolean useShapeForLightOcclusion(BlockState state) {
        return state.getValue(TYPE) != VerticalSlabType.DOUBLE;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((VerticalSlabType)((Object)state.getValue(TYPE))) {
            case VerticalSlabType.DOUBLE -> Shapes.block();
            case VerticalSlabType.EAST -> EAST_SHAPE;
            case VerticalSlabType.WEST -> WEST_SHAPE;
            case VerticalSlabType.SOUTH -> SOUTH_SHAPE;
            default -> NORTH_SHAPE;
        };
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos blockpos = context.getClickedPos();
        BlockState blockstate = context.getLevel().getBlockState(blockpos);
        if (blockstate.is((Block)this)) {
            return (BlockState)((BlockState)blockstate.setValue(TYPE, (Comparable)((Object)VerticalSlabType.DOUBLE))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false));
        }
        VerticalSlabType bob = switch (context.getHorizontalDirection()) {
            case Direction.SOUTH -> VerticalSlabType.SOUTH;
            case Direction.EAST -> VerticalSlabType.EAST;
            case Direction.WEST -> VerticalSlabType.WEST;
            default -> VerticalSlabType.NORTH;
        };
        return (BlockState)this.withWater(this.defaultBlockState(), context).setValue(TYPE, (Comparable)((Object)bob));
    }

    public boolean canBeReplaced(BlockState state, BlockPlaceContext pUseContext) {
        ItemStack itemstack = pUseContext.getItemInHand();
        VerticalSlabType type = (VerticalSlabType)((Object)state.getValue(TYPE));
        if (type != VerticalSlabType.DOUBLE && itemstack.is(this.asItem())) {
            if (pUseContext.replacingClickedOnBlock()) {
                boolean flag = pUseContext.getClickLocation().y - (double)pUseContext.getClickedPos().getY() > 0.5;
                Direction direction = pUseContext.getClickedFace();
                if (type == VerticalSlabType.NORTH) {
                    return direction == Direction.EAST || flag && direction.getAxis().isHorizontal();
                }
                return direction == Direction.WEST || !flag && direction.getAxis().isHorizontal();
            }
            return true;
        }
        return false;
    }

    public FluidState getFluidState(BlockState state) {
        return this.fluidState(state);
    }

    public boolean placeLiquid(LevelAccessor level, BlockPos pos, BlockState state, FluidState pFluidState) {
        return state.getValue(TYPE) != VerticalSlabType.DOUBLE && super.placeLiquid(level, pos, state, pFluidState);
    }

    public boolean canPlaceLiquid(@Nullable Player player, BlockGetter level, BlockPos pos, BlockState state, Fluid fluid) {
        return state.getValue(TYPE) != VerticalSlabType.DOUBLE && super.canPlaceLiquid(player, level, pos, state, fluid);
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        this.updateWater(level, state, pos);
        return super.updateShape(state, direction, neighborState, level, pos, neighborPos);
    }

    public BlockState rotate(BlockState blockState, Rotation rotation) {
        return (BlockState)blockState.setValue(TYPE, (Comparable)((Object)VerticalSlabType.fromDir(rotation.rotate(VerticalSlabType.toDir((VerticalSlabType)((Object)blockState.getValue(TYPE)))))));
    }

    public BlockState mirror(BlockState blockState, Mirror mirror) {
        return blockState.rotate(mirror.getRotation(VerticalSlabType.toDir((VerticalSlabType)((Object)blockState.getValue(TYPE)))));
    }

    protected boolean isPathfindable(BlockState state, PathComputationType type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case PathComputationType.AIR, PathComputationType.LAND -> false;
            case PathComputationType.WATER -> (Boolean)state.getValue((Property)WATERLOGGED);
        };
    }
}

