/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.simple;

import com.lightning.northstar.content.NorthstarEntityTypes;
import com.lightning.northstar.entity.MarsWormEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MarsWormNestBlock
extends Block {
    public static final VoxelShape NEST_SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)6.0, (double)14.0);
    public static final VoxelShape EGG_SHAPE = Shapes.or((VoxelShape)NEST_SHAPE, (VoxelShape)Block.box((double)3.5, (double)0.0, (double)3.5, (double)12.5, (double)16.0, (double)12.5));
    public static final BooleanProperty HAS_EGG = BooleanProperty.create((String)"has_egg");

    public MarsWormNestBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)HAS_EGG, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{HAS_EGG});
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (((Boolean)state.getValue((Property)HAS_EGG)).booleanValue()) {
            return EGG_SHAPE;
        }
        return NEST_SHAPE;
    }

    public int getLightEmission(BlockState state, BlockGetter world, BlockPos pos) {
        return (Boolean)state.getValue((Property)HAS_EGG) != false ? 9 : 0;
    }

    public boolean canBeEgged(BlockState block) {
        return (Boolean)block.getValue((Property)HAS_EGG);
    }

    public void fallOn(Level level, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        if (!level.isClientSide && ((Boolean)state.getValue((Property)HAS_EGG)).booleanValue() && !(entity instanceof MarsWormEntity)) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)HAS_EGG, (Comparable)Boolean.valueOf(false)));
            if (entity instanceof Player) {
                Player player = (Player)entity;
                level.playSound(null, pos, SoundEvents.TURTLE_EGG_BREAK, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.playSound(player, pos, SoundEvents.TURTLE_EGG_BREAK, SoundSource.BLOCKS, 1.0f, 1.0f);
            } else {
                level.playSound(null, pos, SoundEvents.TURTLE_EGG_BREAK, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            level.gameEvent((Holder)GameEvent.BLOCK_DESTROY, pos, GameEvent.Context.of((BlockState)state));
            level.levelEvent(2001, pos, Block.getId((BlockState)state));
        }
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource pRandom) {
        if (((Boolean)state.getValue((Property)HAS_EGG)).booleanValue() && pRandom.nextInt(9) == 0) {
            MarsWormEntity baby = (MarsWormEntity)((EntityType)NorthstarEntityTypes.MARS_WORM.get()).create((Level)level);
            baby.setBaby(true);
            baby.eggTimer = 12000;
            baby.moveTo(pos, 0.0f, 0.0f);
            level.addFreshEntity((Entity)baby);
            level.setBlockAndUpdate(pos, this.defaultBlockState());
            level.playSound(null, pos, SoundEvents.TURTLE_EGG_BREAK, SoundSource.BLOCKS, 1.0f, this.explosionResistance);
        }
    }

    public boolean canSurvive(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        return MarsWormNestBlock.canSupportCenter((LevelReader)pLevel, (BlockPos)pPos.below(), (Direction)Direction.UP);
    }

    protected boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }
}

