/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.simple;

import com.lightning.northstar.block.simple.MarsSoilBlock;
import com.lightning.northstar.content.NorthstarBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AttachedStemBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.FarmlandWaterManager;
import net.neoforged.neoforge.common.util.TriState;

public class MarsFarmlandBlock
extends FarmBlock {
    public MarsFarmlandBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public static void turntoMarsSoil(BlockState state, Level level, BlockPos pos) {
        level.setBlockAndUpdate(pos, MarsFarmlandBlock.pushEntitiesUp((BlockState)state, (BlockState)((MarsSoilBlock)((Object)NorthstarBlocks.MARS_SOIL.get())).defaultBlockState(), (LevelAccessor)level, (BlockPos)pos));
    }

    private static boolean isNearWater(LevelReader level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        for (BlockPos blockpos : BlockPos.betweenClosed((BlockPos)pos.offset(-4, 0, -4), (BlockPos)pos.offset(4, 1, 4))) {
            if (!state.canBeHydrated((BlockGetter)level, pos, level.getFluidState(blockpos), blockpos)) continue;
            return true;
        }
        return FarmlandWaterManager.hasBlockWaterTicket((LevelReader)level, (BlockPos)pos);
    }

    private static TriState isUnderCrops(BlockGetter level, BlockPos pos) {
        BlockState plant = level.getBlockState(pos.above());
        BlockState state = level.getBlockState(pos);
        return state.canSustainPlant(level, pos, Direction.UP, plant);
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockState aboveState = level.getBlockState(pos.above());
        return super.canSurvive(state, level, pos) || aboveState.getBlock() instanceof AttachedStemBlock;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return !this.defaultBlockState().canSurvive((LevelReader)context.getLevel(), context.getClickedPos()) ? ((MarsSoilBlock)((Object)NorthstarBlocks.MARS_SOIL.get())).defaultBlockState() : super.getStateForPlacement(context);
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        if (!state.canSurvive((LevelReader)level, pos)) {
            MarsFarmlandBlock.turntoMarsSoil(state, (Level)level, pos);
        }
    }

    public void fallOn(Level level, BlockState blockState, BlockPos pos, Entity entity, float p_153231_) {
        if (!level.isClientSide && CommonHooks.onFarmlandTrample((Level)level, (BlockPos)pos, (BlockState)Blocks.DIRT.defaultBlockState(), (float)p_153231_, (Entity)entity)) {
            MarsFarmlandBlock.turntoMarsSoil(blockState, level, pos);
        }
    }

    public void randomTick(BlockState blockState, ServerLevel level, BlockPos pos, RandomSource p_221142_) {
        int i = (Integer)blockState.getValue((Property)MOISTURE);
        if (!MarsFarmlandBlock.isNearWater((LevelReader)level, pos) && !level.isRainingAt(pos.above())) {
            if (i > 0) {
                level.setBlock(pos, (BlockState)blockState.setValue((Property)MOISTURE, (Comparable)Integer.valueOf(i - 1)), 2);
            } else if (MarsFarmlandBlock.isUnderCrops((BlockGetter)level, pos).isFalse()) {
                MarsFarmlandBlock.turntoMarsSoil(blockState, (Level)level, pos);
            }
        } else if (i < 7) {
            level.setBlock(pos, (BlockState)blockState.setValue((Property)MOISTURE, (Comparable)Integer.valueOf(7)), 2);
        }
    }

    public TriState canSustainPlant(BlockState state, BlockGetter level, BlockPos soilPosition, Direction facing, BlockState plant) {
        if (plant.getBlock() instanceof CropBlock || plant.is(BlockTags.CROPS)) {
            return TriState.TRUE;
        }
        return super.canSustainPlant(state, level, soilPosition, facing, plant);
    }
}

