/*
 * Decompiled with CFR 0.152.
 */
package net.dakotapride.mechanical_botany.kinetics.insolator;

import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.kinetics.base.KineticBlock;
import com.simibubi.create.content.kinetics.simpleRelays.ICogWheel;
import com.simibubi.create.foundation.block.IBE;
import net.createmod.catnip.data.Iterate;
import net.dakotapride.mechanical_botany.ModBlockEntityTypes;
import net.dakotapride.mechanical_botany.kinetics.insolator.MechanicalInsolatorBlockEntity;
import net.dakotapride.mechanical_botany.kinetics.insolator.MechanicalInsolatorInventory;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;

public class MechanicalInsolatorBlock
extends KineticBlock
implements IBE<MechanicalInsolatorBlockEntity>,
ICogWheel,
IWrenchable {
    public MechanicalInsolatorBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (!stack.isEmpty()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (level.isClientSide) {
            return ItemInteractionResult.SUCCESS;
        }
        this.withBlockEntityDo((BlockGetter)level, pos, insolator -> {
            int slot;
            boolean emptyOutput = true;
            MechanicalInsolatorInventory inv = insolator.outputInv;
            for (slot = 0; slot < inv.getSlots(); ++slot) {
                ItemStack stackInSlot = inv.getStackInSlot(slot);
                if (!stackInSlot.isEmpty()) {
                    emptyOutput = false;
                }
                player.getInventory().placeItemBackInInventory(stackInSlot);
                inv.setStackInSlot(slot, ItemStack.EMPTY);
            }
            if (emptyOutput) {
                inv = insolator.inputInv;
                for (slot = 0; slot < inv.getSlots(); ++slot) {
                    player.getInventory().placeItemBackInInventory(inv.getStackInSlot(slot));
                    inv.setStackInSlot(slot, ItemStack.EMPTY);
                }
            }
            insolator.setChanged();
            insolator.sendData();
        });
        return ItemInteractionResult.SUCCESS;
    }

    public static boolean hasPipeTowards(Direction face) {
        return face == Direction.DOWN;
    }

    public void updateEntityAfterFallOn(BlockGetter worldIn, Entity entityIn) {
        super.updateEntityAfterFallOn(worldIn, entityIn);
        if (entityIn.level().isClientSide) {
            return;
        }
        if (!(entityIn instanceof ItemEntity)) {
            return;
        }
        ItemEntity itemEntity = (ItemEntity)entityIn;
        if (!entityIn.isAlive()) {
            return;
        }
        MechanicalInsolatorBlockEntity insolator = null;
        for (BlockPos pos : Iterate.hereAndBelow((BlockPos)entityIn.blockPosition())) {
            if (insolator != null) continue;
            insolator = (MechanicalInsolatorBlockEntity)this.getBlockEntity(worldIn, pos);
        }
        if (insolator == null) {
            return;
        }
        IItemHandler capability = (IItemHandler)insolator.getLevel().getCapability(Capabilities.ItemHandler.BLOCK, insolator.getBlockPos(), null);
        if (capability == null) {
            return;
        }
        ItemStack remainder = capability.insertItem(0, itemEntity.getItem(), false);
        if (remainder.isEmpty()) {
            itemEntity.discard();
        }
        if (remainder.getCount() < itemEntity.getItem().getCount()) {
            itemEntity.setItem(remainder);
        }
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return Direction.Axis.Y;
    }

    public Class<MechanicalInsolatorBlockEntity> getBlockEntityClass() {
        return MechanicalInsolatorBlockEntity.class;
    }

    public BlockEntityType<? extends MechanicalInsolatorBlockEntity> getBlockEntityType() {
        return (BlockEntityType)ModBlockEntityTypes.INSOLATOR.get();
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }
}

